/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.array.Byte1D;
import mitiv.array.Byte2D;
import mitiv.array.Byte3D;
import mitiv.array.impl.FlatByte1D;
import mitiv.array.impl.FlatByte2D;
import mitiv.array.impl.Helper;
import mitiv.array.impl.SelectedByte3D;
import mitiv.array.impl.StriddenByte2D;
import mitiv.array.impl.StriddenByte3D;
import mitiv.base.Shape;
import mitiv.base.indexing.CompiledRange;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.ByteFunction;
import mitiv.base.mapping.ByteScanner;
import mitiv.exception.NonConformableArrayException;
import mitiv.random.ByteGenerator;

public class FlatByte3D
extends Byte3D {
    static final int order = 1;
    final byte[] data;
    final int dim1dim2;

    public FlatByte3D(int n, int n2, int n3) {
        super(n, n2, n3);
        this.data = new byte[this.number];
        this.dim1dim2 = n * n2;
    }

    public FlatByte3D(int[] nArray) {
        super(nArray);
        this.data = new byte[this.number];
        this.dim1dim2 = this.dim1 * this.dim2;
    }

    public FlatByte3D(Shape shape) {
        super(shape);
        this.data = new byte[this.number];
        this.dim1dim2 = this.dim1 * this.dim2;
    }

    public FlatByte3D(byte[] byArray, int n, int n2, int n3) {
        super(n, n2, n3);
        this.checkSize(byArray);
        this.data = byArray;
        this.dim1dim2 = n * n2;
    }

    public FlatByte3D(byte[] byArray, int[] nArray) {
        super(nArray);
        this.checkSize(byArray);
        this.data = byArray;
        this.dim1dim2 = this.dim1 * this.dim2;
    }

    public FlatByte3D(byte[] byArray, Shape shape) {
        super(shape);
        this.checkSize(byArray);
        this.data = byArray;
        this.dim1dim2 = this.dim1 * this.dim2;
    }

    @Override
    public void checkSanity() {
        if (this.data == null) {
            throw new NonConformableArrayException("Wrapped array is null");
        }
        if (this.data.length < this.number) {
            throw new NonConformableArrayException("Wrapped array is too small");
        }
    }

    private void checkSize(byte[] byArray) {
        if (byArray == null || byArray.length < this.number) {
            throw new NonConformableArrayException("Wrapped array is too small");
        }
    }

    final int index(int n, int n2, int n3) {
        return this.dim1dim2 * n3 + this.dim1 * n2 + n;
    }

    @Override
    public final byte get(int n, int n2, int n3) {
        return this.data[this.dim1dim2 * n3 + this.dim1 * n2 + n];
    }

    @Override
    public final void set(int n, int n2, int n3, byte by) {
        this.data[this.dim1dim2 * n3 + this.dim1 * n2 + n] = by;
    }

    @Override
    public final int getOrder() {
        return 1;
    }

    @Override
    public void fill(byte by) {
        for (int i = 0; i < this.number; ++i) {
            this.data[i] = by;
        }
    }

    @Override
    public void fill(ByteGenerator byteGenerator) {
        for (int i = 0; i < this.number; ++i) {
            this.data[i] = byteGenerator.nextByte();
        }
    }

    @Override
    public void increment(byte by) {
        int n = 0;
        while (n < this.number) {
            int n2 = n++;
            this.data[n2] = (byte)(this.data[n2] + by);
        }
    }

    @Override
    public void decrement(byte by) {
        int n = 0;
        while (n < this.number) {
            int n2 = n++;
            this.data[n2] = (byte)(this.data[n2] - by);
        }
    }

    @Override
    public void scale(byte by) {
        int n = 0;
        while (n < this.number) {
            int n2 = n++;
            this.data[n2] = (byte)(this.data[n2] * by);
        }
    }

    @Override
    public void map(ByteFunction byteFunction) {
        for (int i = 0; i < this.number; ++i) {
            this.data[i] = byteFunction.apply(this.data[i]);
        }
    }

    @Override
    public void scan(ByteScanner byteScanner) {
        byteScanner.initialize(this.data[0]);
        for (int i = 1; i < this.number; ++i) {
            byteScanner.update(this.data[i]);
        }
    }

    @Override
    public final boolean isFlat() {
        return true;
    }

    @Override
    public byte[] flatten(boolean bl) {
        if (bl) {
            byte[] byArray = new byte[this.number];
            System.arraycopy(this.data, 0, byArray, 0, this.number);
            return byArray;
        }
        return this.data;
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    @Override
    public Byte2D slice(int n) {
        if ((n = Helper.fixIndex(n, this.dim3)) == 0) {
            return new FlatByte2D(this.data, this.dim1, this.dim2);
        }
        return new StriddenByte2D(this.data, this.dim1dim2 * n, 1, this.dim1, this.dim1, this.dim2);
    }

    @Override
    public Byte2D slice(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        if ((n2 = Helper.fixSliceIndex(n2, 3)) == 0) {
            n7 = Helper.fixIndex(n, this.dim1);
            n6 = this.dim1;
            n5 = this.dim1dim2;
            n4 = this.dim2;
            n3 = this.dim3;
        } else if (n2 == 1) {
            n7 = this.dim1 * Helper.fixIndex(n, this.dim2);
            n6 = 1;
            n5 = this.dim1dim2;
            n4 = this.dim1;
            n3 = this.dim3;
        } else {
            n7 = this.dim1dim2 * Helper.fixIndex(n, this.dim3);
            n6 = 1;
            n5 = this.dim1;
            n4 = this.dim1;
            n3 = this.dim2;
        }
        return new StriddenByte2D(this.data, n7, n6, n5, n4, n3);
    }

    @Override
    public Byte3D view(Range range, Range range2, Range range3) {
        CompiledRange compiledRange = new CompiledRange(range, this.dim1, 0, 1);
        CompiledRange compiledRange2 = new CompiledRange(range2, this.dim2, 0, this.dim1);
        CompiledRange compiledRange3 = new CompiledRange(range3, this.dim3, 0, this.dim1dim2);
        if (compiledRange.doesNothing() && compiledRange2.doesNothing() && compiledRange3.doesNothing()) {
            return this;
        }
        return new StriddenByte3D(this.data, compiledRange.getOffset() + compiledRange2.getOffset() + compiledRange3.getOffset(), compiledRange.getStride(), compiledRange2.getStride(), compiledRange3.getStride(), compiledRange.getNumber(), compiledRange2.getNumber(), compiledRange3.getNumber());
    }

    @Override
    public Byte3D view(int[] nArray, int[] nArray2, int[] nArray3) {
        int[] nArray4 = Helper.select(0, 1, this.dim1, nArray);
        int[] nArray5 = Helper.select(0, this.dim1, this.dim2, nArray2);
        int[] nArray6 = Helper.select(0, this.dim1dim2, this.dim3, nArray3);
        return new SelectedByte3D(this.data, nArray4, nArray5, nArray6);
    }

    @Override
    public Byte1D as1D() {
        return new FlatByte1D(this.data, this.number);
    }
}

