/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.array.Long1D;
import mitiv.array.LongScalar;
import mitiv.array.impl.Helper;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.LongFunction;
import mitiv.base.mapping.LongScanner;
import mitiv.random.LongGenerator;

public class SelectedLong1D
extends Long1D {
    static final int order = 0;
    final long[] data;
    final int[] idx1;

    public SelectedLong1D(long[] lArray, int[] nArray) {
        super(nArray.length);
        this.data = lArray;
        this.idx1 = nArray;
    }

    @Override
    public final void checkSanity() {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = n = this.idx1[0];
        for (int i = 1; i < this.dim1; ++i) {
            int n5 = this.idx1[i];
            if (n5 < n4) {
                n4 = n5;
            }
            if (n5 <= n) continue;
            n = n5;
        }
        if ((n2 += n4) < 0 || (n3 += n) >= this.data.length) {
            throw new IndexOutOfBoundsException("Selected indices are out of bounds");
        }
    }

    final int index(int n) {
        return this.idx1[n];
    }

    @Override
    public final long get(int n) {
        return this.data[this.idx1[n]];
    }

    @Override
    public final void set(int n, long l) {
        this.data[this.idx1[n]] = l;
    }

    @Override
    public final int getOrder() {
        return 0;
    }

    @Override
    public void fill(long l) {
        for (int i = 0; i < this.dim1; ++i) {
            int n = this.idx1[i];
            this.data[n] = l;
        }
    }

    @Override
    public void fill(LongGenerator longGenerator) {
        for (int i = 0; i < this.dim1; ++i) {
            int n = this.idx1[i];
            this.data[n] = longGenerator.nextLong();
        }
    }

    @Override
    public void increment(long l) {
        for (int i = 0; i < this.dim1; ++i) {
            int n;
            int n2 = n = this.idx1[i];
            this.data[n2] = this.data[n2] + l;
        }
    }

    @Override
    public void decrement(long l) {
        for (int i = 0; i < this.dim1; ++i) {
            int n;
            int n2 = n = this.idx1[i];
            this.data[n2] = this.data[n2] - l;
        }
    }

    @Override
    public void scale(long l) {
        for (int i = 0; i < this.dim1; ++i) {
            int n;
            int n2 = n = this.idx1[i];
            this.data[n2] = this.data[n2] * l;
        }
    }

    @Override
    public void map(LongFunction longFunction) {
        for (int i = 0; i < this.dim1; ++i) {
            int n = this.idx1[i];
            this.data[n] = longFunction.apply(this.data[n]);
        }
    }

    @Override
    public void scan(LongScanner longScanner) {
        boolean bl = false;
        for (int i = 0; i < this.dim1; ++i) {
            int n = this.idx1[i];
            if (bl) {
                longScanner.update(this.data[n]);
                continue;
            }
            longScanner.initialize(this.data[n]);
            bl = true;
        }
    }

    @Override
    public final boolean isFlat() {
        return false;
    }

    @Override
    public long[] flatten(boolean bl) {
        long[] lArray = new long[this.number];
        int n = -1;
        for (int i = 0; i < this.dim1; ++i) {
            int n2 = this.idx1[i];
            lArray[++n] = this.data[n2];
        }
        return lArray;
    }

    @Override
    public long[] getData() {
        return null;
    }

    @Override
    public LongScalar slice(int n) {
        return new LongScalar(this.data, this.idx1[Helper.fixIndex(n, this.dim1)]);
    }

    @Override
    public LongScalar slice(int n, int n2) {
        Helper.fixSliceIndex(n2, 1);
        return new LongScalar(this.data, Helper.fixIndex(n, this.dim1));
    }

    @Override
    public Long1D view(Range range) {
        int[] nArray = Helper.select(this.idx1, range);
        if (nArray == this.idx1) {
            return this;
        }
        return new SelectedLong1D(this.data, nArray);
    }

    @Override
    public Long1D view(int[] nArray) {
        int[] nArray2 = Helper.select(this.idx1, nArray);
        if (nArray2 == this.idx1) {
            return this;
        }
        return new SelectedLong1D(this.data, nArray2);
    }

    @Override
    public Long1D as1D() {
        return this;
    }
}

