/*
 * Decompiled with CFR 0.152.
 */
package mitiv.base.mapping;

import mitiv.base.mapping.Mapping;
import mitiv.exception.IncorrectSpaceException;
import mitiv.linalg.Vector;
import mitiv.linalg.VectorSpace;

public abstract class DifferentiableMapping
extends Mapping {
    protected DifferentiableMapping(VectorSpace vectorSpace, VectorSpace vectorSpace2) {
        super(vectorSpace, vectorSpace2);
    }

    protected DifferentiableMapping(VectorSpace vectorSpace) {
        super(vectorSpace);
    }

    public void applyJacobian(Vector vector, Vector vector2, Vector vector3) {
        if (!this.inputSpace.owns(vector)) {
            throw new IncorrectSpaceException("Destination does not belong to the input space");
        }
        if (!this.inputSpace.owns(vector2)) {
            throw new IncorrectSpaceException("Variables does not belong to the input space");
        }
        if (!this.outputSpace.owns(vector3)) {
            throw new IncorrectSpaceException("Source does not belong to the output space");
        }
        this._applyJacobian(vector, vector2, vector3);
    }

    protected abstract void _applyJacobian(Vector var1, Vector var2, Vector var3);
}

