/*
 * Decompiled with CFR 0.152.
 */
package mitiv.linalg;

import mitiv.base.mapping.DifferentiableMapping;
import mitiv.exception.IllegalLinearOperationException;
import mitiv.exception.IncorrectSpaceException;
import mitiv.exception.NotImplementedException;
import mitiv.linalg.Vector;
import mitiv.linalg.VectorSpace;

public abstract class LinearOperator
extends DifferentiableMapping {
    public static int DIRECT = 0;
    public static int ADJOINT = 1;
    public static int INVERSE = 2;
    public static int INVERSE_ADJOINT = ADJOINT | INVERSE;
    public static int ADJOINT_INVERSE = ADJOINT | INVERSE;

    public LinearOperator(VectorSpace vectorSpace) {
        super(vectorSpace);
    }

    protected LinearOperator(VectorSpace vectorSpace, VectorSpace vectorSpace2) {
        super(vectorSpace, vectorSpace2);
    }

    public void apply(Vector vector, Vector vector2, int n) throws IncorrectSpaceException, IllegalLinearOperationException, NotImplementedException {
        if (n == DIRECT || n == (INVERSE | ADJOINT)) {
            if (!this.outputSpace.owns(vector)) {
                throw new IncorrectSpaceException("Destination does not belong to the output space");
            }
            if (!this.inputSpace.owns(vector2)) {
                throw new IncorrectSpaceException("Source does not belong to the input space");
            }
        } else if (n == ADJOINT || n == INVERSE) {
            if (!this.inputSpace.owns(vector)) {
                throw new IncorrectSpaceException("Destination does not belong to the input space");
            }
            if (!this.outputSpace.owns(vector2)) {
                throw new IncorrectSpaceException("Source does not belong to the output space");
            }
        } else {
            throw new IllegalLinearOperationException();
        }
        this._apply(vector, vector2, n);
    }

    protected abstract void _apply(Vector var1, Vector var2, int var3) throws NotImplementedException;

    @Override
    protected void _apply(Vector vector, Vector vector2) {
        this._apply(vector, vector2, DIRECT);
    }

    @Override
    protected void _applyJacobian(Vector vector, Vector vector2, Vector vector3) {
        this._apply(vector, vector3, ADJOINT);
    }

    public static void checkLinearProblem(LinearOperator linearOperator, Vector vector, Vector vector2, boolean bl) throws IncorrectSpaceException {
        if (!vector2.belongsTo(linearOperator.getInputSpace()) || !vector.belongsTo(linearOperator.getOutputSpace())) {
            throw new IncorrectSpaceException();
        }
        if (bl && linearOperator.getInputSpace() != linearOperator.getOutputSpace()) {
            throw new IllegalArgumentException("LHS linear operator is not an endomorphism");
        }
    }

    public double checkAdjoint(Vector vector, Vector vector2) {
        Vector vector3 = this.outputSpace.create();
        this.apply(vector3, vector);
        Vector vector4 = this.inputSpace.create();
        this.apply(vector4, vector2, ADJOINT);
        double d = vector2.dot(vector3);
        double d2 = vector.dot(vector4);
        if (d == d2) {
            return 0.0;
        }
        return Math.abs(d - d2) / Math.max(Math.abs(d), Math.abs(d2));
    }
}

