/*
 * Decompiled with CFR 0.152.
 */
package mitiv.linalg;

import mitiv.exception.IncorrectSpaceException;
import mitiv.linalg.VectorSpace;

public abstract class Vector {
    protected final VectorSpace space;
    protected final int number;

    protected Vector(VectorSpace vectorSpace) {
        this.space = vectorSpace;
        this.number = vectorSpace.number;
    }

    public VectorSpace getOwner() {
        return this.space;
    }

    public VectorSpace getSpace() {
        return this.space;
    }

    public final int getNumber() {
        return this.number;
    }

    public final int length() {
        return this.number;
    }

    public final boolean belongsTo(VectorSpace vectorSpace) {
        return this.space == vectorSpace;
    }

    public final void assertBelongsTo(VectorSpace vectorSpace) throws IncorrectSpaceException {
        if (!this.belongsTo(vectorSpace)) {
            throw new IncorrectSpaceException();
        }
    }

    public abstract double get(int var1) throws IndexOutOfBoundsException;

    public abstract void set(int var1, double var2) throws IndexOutOfBoundsException;

    public Vector create() {
        return this.space.create();
    }

    public Vector clone() {
        return this.space._clone(this);
    }

    public final void copy(Vector vector) throws IncorrectSpaceException {
        if (vector != this) {
            this.space.check(vector);
            this.space._copy(this, vector);
        }
    }

    public final void swap(Vector vector) throws IncorrectSpaceException {
        if (vector != this) {
            this.space.check(vector);
            this.space._swap(this, vector);
        }
    }

    public final double dot(Vector vector) {
        this.space.check(vector);
        return this.space._dot(this, vector);
    }

    public final double dot(Vector vector, Vector vector2) {
        this.space.check(vector);
        this.space.check(vector2);
        return this.space._dot(this, vector, vector2);
    }

    public final double norm1() {
        return this.space._norm1(this);
    }

    public final double norm2() {
        return this.space._norm2(this);
    }

    public final double normInf() {
        return this.space._normInf(this);
    }

    public final void fill(double d) {
        this.space._fill(this, d);
    }

    public final void zero() {
        this.space._zero(this);
    }

    public final void scale(double d) {
        this.space._scale(this, d);
    }

    public final void scale(double d, Vector vector) {
        this.space.check(vector);
        this.space._scale(this, d, vector);
    }

    public final void add(double d, Vector vector) throws IncorrectSpaceException {
        this.space.check(vector);
        this.space._add(this, d, vector);
    }

    public final void combine(double d, Vector vector, double d2, Vector vector2) throws IncorrectSpaceException {
        this.space.check(vector);
        this.space.check(vector2);
        this.space._combine(this, d, vector, d2, vector2);
    }

    public final void combine(double d, Vector vector, double d2, Vector vector2, double d3, Vector vector3) throws IncorrectSpaceException {
        this.space.check(vector);
        this.space.check(vector2);
        this.space.check(vector3);
        this.space._combine(this, d, vector, d2, vector2, d3, vector3);
    }

    public final void multiply(Vector vector) throws IncorrectSpaceException {
        this.space.check(vector);
        this.space._multiply(this, this, vector);
    }

    public final void multiply(Vector vector, Vector vector2) throws IncorrectSpaceException {
        this.space.check(vector);
        this.space.check(vector2);
        this.space._multiply(this, vector, vector2);
    }

    public String toString() {
        return this.toString(this.number);
    }

    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        if (this.number > n) {
            if (n <= 0) {
                stringBuffer.append("...");
            } else {
                int n2;
                for (n2 = 0; n2 < Math.min(this.number, (n + 1) / 2); ++n2) {
                    stringBuffer.append(String.format(n2 > 0 ? ", %g" : "%g", this.get(n2)));
                }
                stringBuffer.append(", ...");
                for (n2 = this.number - (n - (n + 1) / 2); n2 < this.number; ++n2) {
                    stringBuffer.append(String.format(", %g", this.get(n2)));
                }
            }
        } else {
            for (int i = 0; i < this.number; ++i) {
                stringBuffer.append(String.format(i > 0 ? ", %g" : "%g", this.get(i)));
            }
        }
        return stringBuffer.append("}").toString();
    }
}

