/*
 * Decompiled with CFR 0.152.
 */
package mitiv.linalg.shaped;

import mitiv.base.Shape;
import mitiv.linalg.LinearOperator;
import mitiv.linalg.Vector;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.DoubleShapedVectorSpace;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.FloatShapedVectorSpace;
import mitiv.linalg.shaped.ShapedLinearOperator;
import mitiv.linalg.shaped.ShapedVectorSpace;
import org.jtransforms.fft.DoubleFFT_1D;
import org.jtransforms.fft.DoubleFFT_2D;
import org.jtransforms.fft.DoubleFFT_3D;
import org.jtransforms.fft.FloatFFT_1D;
import org.jtransforms.fft.FloatFFT_2D;
import org.jtransforms.fft.FloatFFT_3D;

public class RealComplexFFT
extends ShapedLinearOperator {
    private Object xform = null;
    private double[] tempDouble = null;
    private float[] tempFloat = null;
    private final int number;
    private final int rank;
    private final Shape shape;
    private final boolean single;
    public boolean useSystemArrayCopy = false;

    public RealComplexFFT(ShapedVectorSpace shapedVectorSpace) {
        super(shapedVectorSpace, RealComplexFFT.complexSpace(shapedVectorSpace));
        this.number = shapedVectorSpace.getNumber();
        this.shape = shapedVectorSpace.getShape();
        this.single = shapedVectorSpace.getType() == 4;
        this.rank = shapedVectorSpace.getRank();
        if (this.rank < 1 || this.rank > 3) {
            throw new IllegalArgumentException("Only 1D, 2D or 3D transforms supported");
        }
    }

    private static ShapedVectorSpace complexSpace(ShapedVectorSpace shapedVectorSpace) {
        ShapedVectorSpace shapedVectorSpace2;
        Shape shape = shapedVectorSpace.getShape();
        if (shapedVectorSpace.getRank() < 1) {
            throw new IllegalArgumentException("Rank must be at least 1 for the FFT.");
        }
        int[] nArray = shape.copyDimensions();
        nArray[0] = nArray[0] * 2;
        Shape shape2 = new Shape(nArray);
        int n = shapedVectorSpace.getType();
        if (n == 4) {
            shapedVectorSpace2 = new FloatShapedVectorSpace(shape2);
        } else if (n == 5) {
            shapedVectorSpace2 = new DoubleShapedVectorSpace(shape2);
        } else {
            throw new IllegalArgumentException("Only float or double supported");
        }
        return shapedVectorSpace2;
    }

    @Override
    protected void _apply(Vector vector, Vector vector2, int n) {
        if (this.single) {
            if (this.xform == null) {
                this.xform = this.rank == 1 ? new FloatFFT_1D(this.shape.dimension(0)) : (this.rank == 2 ? new FloatFFT_2D(this.shape.dimension(1), this.shape.dimension(0)) : new FloatFFT_3D(this.shape.dimension(2), this.shape.dimension(1), this.shape.dimension(0)));
            }
            if (this.tempFloat == null) {
                this.tempFloat = new float[2 * this.number];
            }
            float[] fArray = this.tempFloat;
            float[] fArray2 = ((FloatShapedVector)vector2).getData();
            float[] fArray3 = ((FloatShapedVector)vector).getData();
            if (n == LinearOperator.ADJOINT || n == LinearOperator.INVERSE) {
                int n2;
                int n3;
                if (this.useSystemArrayCopy) {
                    System.arraycopy(fArray2, 0, fArray, 0, 2 * this.number);
                } else {
                    for (n3 = 0; n3 < this.number; ++n3) {
                        n2 = n3 + n3;
                        int n4 = n2 + 1;
                        fArray[n2] = fArray2[n2];
                        fArray[n4] = fArray2[n4];
                    }
                }
                if (this.rank == 1) {
                    ((FloatFFT_1D)this.xform).complexInverse(fArray, false);
                } else if (this.rank == 2) {
                    ((FloatFFT_2D)this.xform).complexInverse(fArray, false);
                } else {
                    ((FloatFFT_3D)this.xform).complexInverse(fArray, false);
                }
                if (n == LinearOperator.INVERSE) {
                    float f = 1.0f / (float)this.number;
                    for (n2 = 0; n2 < this.number; ++n2) {
                        fArray3[n2] = f * fArray[2 * n2];
                    }
                } else {
                    for (n3 = 0; n3 < this.number; ++n3) {
                        fArray3[n3] = fArray[2 * n3];
                    }
                }
            } else {
                if (n == LinearOperator.DIRECT) {
                    for (int i = 0; i < this.number; ++i) {
                        fArray3[2 * i] = fArray2[i];
                        fArray3[2 * i + 1] = 0.0f;
                    }
                } else {
                    float f = 1.0f / (float)this.number;
                    for (int i = 0; i < this.number; ++i) {
                        fArray3[2 * i] = f * fArray2[i];
                        fArray3[2 * i + 1] = 0.0f;
                    }
                }
                if (this.rank == 1) {
                    ((FloatFFT_1D)this.xform).complexForward(fArray3);
                } else if (this.rank == 2) {
                    ((FloatFFT_2D)this.xform).complexForward(fArray3);
                } else {
                    ((FloatFFT_3D)this.xform).complexForward(fArray3);
                }
            }
        } else {
            if (this.xform == null) {
                this.xform = this.rank == 1 ? new DoubleFFT_1D(this.shape.dimension(0)) : (this.rank == 2 ? new DoubleFFT_2D(this.shape.dimension(1), this.shape.dimension(0)) : new DoubleFFT_3D(this.shape.dimension(2), this.shape.dimension(1), this.shape.dimension(0)));
            }
            if (this.tempDouble == null) {
                this.tempDouble = new double[2 * this.number];
            }
            double[] dArray = this.tempDouble;
            double[] dArray2 = ((DoubleShapedVector)vector2).getData();
            double[] dArray3 = ((DoubleShapedVector)vector).getData();
            if (n == LinearOperator.ADJOINT || n == LinearOperator.INVERSE) {
                int n5;
                int n6;
                if (this.useSystemArrayCopy) {
                    System.arraycopy(dArray2, 0, dArray, 0, 2 * this.number);
                } else {
                    for (n6 = 0; n6 < this.number; ++n6) {
                        int n7 = n6 + n6;
                        n5 = n7 + 1;
                        dArray[n7] = dArray2[n7];
                        dArray[n5] = dArray2[n5];
                    }
                }
                if (this.rank == 1) {
                    ((DoubleFFT_1D)this.xform).complexInverse(dArray, false);
                } else if (this.rank == 2) {
                    ((DoubleFFT_2D)this.xform).complexInverse(dArray, false);
                } else {
                    ((DoubleFFT_3D)this.xform).complexInverse(dArray, false);
                }
                if (n == LinearOperator.INVERSE) {
                    double d = 1.0 / (double)this.number;
                    for (n5 = 0; n5 < this.number; ++n5) {
                        dArray3[n5] = d * dArray[2 * n5];
                    }
                } else {
                    for (n6 = 0; n6 < this.number; ++n6) {
                        dArray3[n6] = dArray[2 * n6];
                    }
                }
            } else {
                if (n == LinearOperator.DIRECT) {
                    for (int i = 0; i < this.number; ++i) {
                        dArray3[2 * i] = dArray2[i];
                        dArray3[2 * i + 1] = 0.0;
                    }
                } else {
                    double d = 1.0 / (double)this.number;
                    for (int i = 0; i < this.number; ++i) {
                        dArray3[2 * i] = d * dArray2[i];
                        dArray3[2 * i + 1] = 0.0;
                    }
                }
                if (this.rank == 1) {
                    ((DoubleFFT_1D)this.xform).complexForward(dArray3);
                } else if (this.rank == 2) {
                    ((DoubleFFT_2D)this.xform).complexForward(dArray3);
                } else {
                    ((DoubleFFT_3D)this.xform).complexForward(dArray3);
                }
            }
        }
    }
}

