/*
 * Decompiled with CFR 0.152.
 */
package mitiv.optim;

import mitiv.cost.DifferentiableCostFunction;
import mitiv.exception.IncorrectSpaceException;
import mitiv.linalg.Vector;
import mitiv.linalg.VectorSpace;
import mitiv.optim.OptimStatus;
import mitiv.optim.OptimTask;
import mitiv.optim.ReverseCommunicationOptimizer;
import mitiv.utils.Timer;

public class IterativeDifferentiableSolver {
    private VectorSpace space = null;
    private DifferentiableCostFunction cost = null;
    private ReverseCommunicationOptimizer optimizer = null;
    private Vector gx = null;
    private Vector xBest = null;
    private Vector gxBest = null;
    private double fx = -1.0;
    private double fxBest;
    private boolean firstTime = true;
    private boolean stepping = false;
    private boolean saveBest = false;
    private final Timer timer = new Timer();
    private boolean updatePending = false;
    private int iterations = 0;
    private int evaluations = 0;
    private int restarts = 0;
    private int maxeval = -1;
    private int maxiter = 200;

    public IterativeDifferentiableSolver(DifferentiableCostFunction differentiableCostFunction, ReverseCommunicationOptimizer reverseCommunicationOptimizer) {
        this.setComponents(differentiableCostFunction, reverseCommunicationOptimizer);
    }

    public IterativeDifferentiableSolver() {
    }

    public OptimTask start(Vector vector) {
        return this.start(vector, false);
    }

    public OptimTask start(Vector vector, boolean bl) {
        if (this.optimizer == null) {
            throw new RuntimeException("Optimizer not yet specified");
        }
        if (this.cost == null) {
            throw new RuntimeException("Cost function not yet specified");
        }
        if (this.gx == null || this.gx.getSpace() != this.space) {
            this.gx = this.space.create();
        }
        if (!this.saveBest || this.xBest != null && this.xBest.getSpace() != this.space) {
            this.xBest = null;
        }
        if (!this.saveBest || this.gxBest != null && this.gxBest.getSpace() != this.space) {
            this.gxBest = null;
        }
        this.updatePending = false;
        this.firstTime = true;
        if (bl) {
            this.timer.start();
            this.timer.stop();
            this.iterations = 0;
            this.evaluations = 0;
            this.restarts = 0;
        }
        OptimTask optimTask = this.optimizer.start();
        while (optimTask == OptimTask.COMPUTE_FG) {
            optimTask = this.computeFG(vector);
            if (!this.stepping) continue;
            break;
        }
        return optimTask;
    }

    public OptimTask iterate(Vector vector) {
        if (this.updatePending) {
            return this.start(vector, false);
        }
        OptimTask optimTask = this.optimizer.getTask();
        if (optimTask == OptimTask.ERROR || optimTask == OptimTask.WARNING) {
            return optimTask;
        }
        if (this.maxiter >= 0 && this.iterations >= this.maxiter) {
            return this.optimizer.warning(OptimStatus.TOO_MANY_ITERATIONS);
        }
        if (optimTask == OptimTask.NEW_X || optimTask == OptimTask.FINAL_X) {
            optimTask = this.optimizer.iterate(vector, this.fx, this.gx);
        }
        while (optimTask == OptimTask.COMPUTE_FG) {
            optimTask = this.computeFG(vector);
            if (!this.stepping) continue;
        }
        if (optimTask == OptimTask.NEW_X || optimTask == OptimTask.FINAL_X) {
            ++this.iterations;
        }
        return optimTask;
    }

    private OptimTask computeFG(Vector vector) {
        if (this.maxeval >= 0 && this.evaluations >= this.maxeval) {
            return this.optimizer.warning(OptimStatus.TOO_MANY_EVALUATIONS);
        }
        int n = this.optimizer.getRestarts();
        this.timer.resume();
        this.fx = this.cost.computeCostAndGradient(1.0, vector, this.gx, true);
        this.timer.stop();
        ++this.evaluations;
        n = this.optimizer.getRestarts() - n;
        if (n > 0) {
            this.restarts += n;
        }
        if (this.firstTime || this.fx < this.fxBest) {
            if (this.saveBest) {
                if (this.xBest == null) {
                    this.xBest = this.space.create();
                }
                this.xBest.copy(vector);
            }
            this.fxBest = this.fx;
            this.firstTime = false;
        }
        return this.optimizer.iterate(vector, this.fx, this.gx);
    }

    public double getCost() {
        return this.fx;
    }

    public Vector getBestSolution() {
        return this.xBest;
    }

    public double getBestCost() {
        return this.fxBest;
    }

    public Vector getGradient() {
        return this.gx;
    }

    public Vector getBestGradient() {
        return this.gxBest;
    }

    public boolean getStepping() {
        return this.stepping;
    }

    public void setStepping(boolean bl) {
        this.stepping = bl;
    }

    public int getIterations() {
        return this.iterations;
    }

    public void resetIteration() {
        this.iterations = 0;
        this.evaluations = 0;
    }

    public int getEvaluations() {
        return this.evaluations;
    }

    public int getRestarts() {
        return this.restarts;
    }

    public double getElapsedTime() {
        return this.timer.getElapsedTime();
    }

    public int getMaximumEvaluations() {
        return this.maxeval;
    }

    public void setMaximumEvaluations(int n) {
        if (n < 0) {
            n = -1;
        }
        this.maxeval = n;
    }

    public int getMaximumIterations() {
        return this.maxiter;
    }

    public void setMaximumIterations(int n) {
        if (n < 0) {
            n = -1;
        }
        this.maxiter = n;
    }

    public ReverseCommunicationOptimizer getOptimizer() {
        return this.optimizer;
    }

    public void setOptimizer(ReverseCommunicationOptimizer reverseCommunicationOptimizer) {
        this.setComponents(this.cost, reverseCommunicationOptimizer);
    }

    public DifferentiableCostFunction getCostFunction() {
        return this.cost;
    }

    public void setCostFunction(DifferentiableCostFunction differentiableCostFunction) {
        this.setComponents(differentiableCostFunction, this.optimizer);
    }

    public VectorSpace getSpace() {
        return this.space;
    }

    public boolean getSaveBest() {
        return this.saveBest;
    }

    public void setSaveBest(boolean bl) {
        this.saveBest = bl;
    }

    private void setComponents(DifferentiableCostFunction differentiableCostFunction, ReverseCommunicationOptimizer reverseCommunicationOptimizer) {
        if (reverseCommunicationOptimizer != this.optimizer || differentiableCostFunction != this.cost) {
            if (differentiableCostFunction != null && reverseCommunicationOptimizer != null && differentiableCostFunction.getInputSpace() != reverseCommunicationOptimizer.getSpace()) {
                throw new IncorrectSpaceException("Optimizer and cost function must operate on the same vector space");
            }
            this.optimizer = reverseCommunicationOptimizer;
            this.cost = differentiableCostFunction;
            this.space = differentiableCostFunction != null ? differentiableCostFunction.getInputSpace() : (reverseCommunicationOptimizer != null ? reverseCommunicationOptimizer.getSpace() : null);
            this.updatePending = true;
        }
    }

    public String getReason() {
        if (this.optimizer == null) {
            return "Iterative algorithm not yet specified";
        }
        return this.optimizer.getReason();
    }

    public OptimTask getTask() {
        if (this.optimizer == null) {
            return OptimTask.ERROR;
        }
        return this.optimizer.getTask();
    }
}

