/*
 * Decompiled with CFR 0.152.
 */
package mitiv.optim;

import mitiv.optim.LineSearchTask;
import mitiv.optim.OptimStatus;

public abstract class LineSearch {
    protected double stp = 0.0;
    protected double stpmin = 0.0;
    protected double stpmax = 0.0;
    protected double finit = 0.0;
    protected double ginit = 0.0;
    private LineSearchTask task;
    private OptimStatus status;

    protected LineSearch() {
        this.failure(OptimStatus.LNSRCH_NOT_STARTED);
    }

    public LineSearchTask start(double d, double d2, double d3, double d4, double d5) {
        if (d4 < 0.0) {
            this.failure(OptimStatus.STPMIN_LT_ZERO);
        } else if (d4 > d5) {
            this.failure(OptimStatus.STPMIN_GT_STPMAX);
        } else if (d3 < d4) {
            this.failure(OptimStatus.STEP_LT_STPMIN);
        } else if (d3 > d5) {
            this.failure(OptimStatus.STEP_GT_STPMAX);
        } else if (d2 >= 0.0) {
            this.failure(OptimStatus.NOT_A_DESCENT);
        } else {
            this.stp = d3;
            this.stpmin = d4;
            this.stpmax = d5;
            this.finit = d;
            this.ginit = d2;
            this.startHook();
        }
        return this.task;
    }

    public LineSearchTask iterate(double d, double d2) {
        if (this.task == LineSearchTask.SEARCH) {
            int n = this.stp <= this.stpmin ? -1 : (this.stp >= this.stpmax ? 1 : 0);
            this.iterateHook(d, d2);
            if (this.task == LineSearchTask.SEARCH) {
                if (this.stp <= this.stpmin) {
                    if (n < 0) {
                        this.warning(OptimStatus.STEP_EQ_STPMIN);
                    }
                    this.stp = this.stpmin;
                } else if (this.stp >= this.stpmax) {
                    if (n > 0) {
                        this.warning(OptimStatus.STEP_EQ_STPMAX);
                    }
                    this.stp = this.stpmax;
                }
            }
        } else {
            this.failure(OptimStatus.LNSRCH_NOT_STARTED);
        }
        return this.task;
    }

    public abstract boolean useDerivative();

    protected void startHook() {
        this.success(LineSearchTask.SEARCH);
    }

    protected abstract void iterateHook(double var1, double var3);

    public double getStep() {
        return this.stp;
    }

    public final LineSearchTask getTask() {
        return this.task;
    }

    public final OptimStatus getStatus() {
        return this.status;
    }

    protected final LineSearchTask failure(OptimStatus optimStatus) {
        this.status = optimStatus;
        this.task = LineSearchTask.ERROR;
        return this.task;
    }

    protected final LineSearchTask warning(OptimStatus optimStatus) {
        this.status = optimStatus;
        this.task = LineSearchTask.WARNING;
        return this.task;
    }

    protected final LineSearchTask success(LineSearchTask lineSearchTask) {
        this.status = OptimStatus.SUCCESS;
        this.task = lineSearchTask;
        return this.task;
    }

    public final String getMessage() {
        return this.status == OptimStatus.SUCCESS ? this.task.toString() : this.status.toString();
    }

    public final boolean hasErrors() {
        return this.task.isError();
    }

    public final boolean hasWarnings() {
        return this.task.isWarning();
    }

    public final boolean converged() {
        return this.task == LineSearchTask.CONVERGENCE;
    }

    public final boolean finished() {
        return this.task != LineSearchTask.SEARCH;
    }

    static int checkWolfeConditions(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        if (d2 - d4 > d6 * d5 * d) {
            return 0;
        }
        double d8 = d7 * d5;
        if (d3 < d8) {
            return 1;
        }
        if (Math.abs(d3) > -d8) {
            return 2;
        }
        return 3;
    }
}

