/*
 * Decompiled with CFR 0.152.
 */
package org.jtransforms.fft;

import pl.edu.icm.jlargearrays.DoubleLargeArray;
import pl.edu.icm.jlargearrays.FloatLargeArray;

public class RealFFTUtils_3D {
    private static final int ONE = 1;
    private static final int TWO = 2;
    private static final int ZERO = 0;
    private static final long ONEL = 1L;
    private static final long TWOL = 2L;
    private static final long ZEROL = 0L;
    private final int columns;
    private final long columnsl;
    private final int rows;
    private final long rowsl;
    private final int rowStride;
    private final long rowStridel;
    private final int slices;
    private final long slicesl;
    private final int sliceStride;
    private final long sliceStridel;

    public RealFFTUtils_3D(long l, long l2, long l3) {
        this.slices = (int)l;
        this.rows = (int)l2;
        this.columns = (int)l3;
        this.rowStride = (int)l3;
        this.sliceStride = (int)l2 * this.rowStride;
        this.slicesl = l;
        this.rowsl = l2;
        this.columnsl = l3;
        this.rowStridel = l3;
        this.sliceStridel = l2 * this.rowStridel;
    }

    public int getIndex(int n, int n2, int n3) {
        int n4;
        int n5 = n3 & 1;
        int n6 = n2 << 1;
        int n7 = n << 1;
        int n8 = n == 0 ? 0 : this.slices - n;
        int n9 = n4 = n2 == 0 ? 0 : this.rows - n2;
        if (n3 <= 1) {
            if (n2 == 0) {
                if (n == 0) {
                    return n3 == 0 ? 0 : Integer.MIN_VALUE;
                }
                if (n7 < this.slices) {
                    return n * this.sliceStride + n3;
                }
                if (n7 > this.slices) {
                    int n10 = n8 * this.sliceStride;
                    return n5 == 0 ? n10 : -(n10 + 1);
                }
                return n5 == 0 ? n * this.sliceStride : Integer.MIN_VALUE;
            }
            if (n6 < this.rows) {
                return n * this.sliceStride + n2 * this.rowStride + n3;
            }
            if (n6 > this.rows) {
                int n11 = n8 * this.sliceStride + n4 * this.rowStride;
                return n5 == 0 ? n11 : -(n11 + 1);
            }
            if (n == 0) {
                return n5 == 0 ? n2 * this.rowStride : Integer.MIN_VALUE;
            }
            if (n7 < this.slices) {
                return n * this.sliceStride + n2 * this.rowStride + n3;
            }
            if (n7 > this.slices) {
                int n12 = n8 * this.sliceStride + n2 * this.rowStride;
                return n5 == 0 ? n12 : -(n12 + 1);
            }
            int n13 = n * this.sliceStride + n2 * this.rowStride;
            return n5 == 0 ? n13 : Integer.MIN_VALUE;
        }
        if (n3 < this.columns) {
            return n * this.sliceStride + n2 * this.rowStride + n3;
        }
        if (n3 > this.columns + 1) {
            int n14 = (this.columns << 1) - n3;
            int n15 = n8 * this.sliceStride + n4 * this.rowStride + n14;
            return n5 == 0 ? n15 : -(n15 + 2);
        }
        if (n2 == 0) {
            if (n == 0) {
                return n5 == 0 ? 1 : Integer.MIN_VALUE;
            }
            if (n7 < this.slices) {
                int n16 = n8 * this.sliceStride;
                return n5 == 0 ? n16 + 1 : -n16;
            }
            if (n7 > this.slices) {
                int n17 = n * this.sliceStride;
                return n5 == 0 ? n17 + 1 : n17;
            }
            int n18 = n * this.sliceStride;
            return n5 == 0 ? n18 + 1 : Integer.MIN_VALUE;
        }
        if (n6 < this.rows) {
            int n19 = n8 * this.sliceStride + n4 * this.rowStride;
            return n5 == 0 ? n19 + 1 : -n19;
        }
        if (n6 > this.rows) {
            int n20 = n * this.sliceStride + n2 * this.rowStride;
            return n5 == 0 ? n20 + 1 : n20;
        }
        if (n == 0) {
            int n21 = n2 * this.rowStride + 1;
            return n5 == 0 ? n21 : Integer.MIN_VALUE;
        }
        if (n7 < this.slices) {
            int n22 = n8 * this.sliceStride + n2 * this.rowStride;
            return n5 == 0 ? n22 + 1 : -n22;
        }
        if (n7 > this.slices) {
            int n23 = n * this.sliceStride + n2 * this.rowStride;
            return n5 == 0 ? n23 + 1 : n23;
        }
        int n24 = n * this.sliceStride + n2 * this.rowStride;
        return n5 == 0 ? n24 + 1 : Integer.MIN_VALUE;
    }

    public long getIndex(long l, long l2, long l3) {
        long l4;
        long l5 = l3 & 1L;
        long l6 = l2 << 1;
        long l7 = l << 1;
        long l8 = l == 0L ? 0L : this.slicesl - l;
        long l9 = l4 = l2 == 0L ? 0L : this.rowsl - l2;
        if (l3 <= 1L) {
            if (l2 == 0L) {
                if (l == 0L) {
                    return l3 == 0L ? 0L : Long.MIN_VALUE;
                }
                if (l7 < this.slicesl) {
                    return l * this.sliceStridel + l3;
                }
                if (l7 > this.slicesl) {
                    long l10 = l8 * this.sliceStridel;
                    return l5 == 0L ? l10 : -(l10 + 1L);
                }
                return l5 == 0L ? l * this.sliceStridel : Long.MIN_VALUE;
            }
            if (l6 < this.rowsl) {
                return l * this.sliceStridel + l2 * this.rowStridel + l3;
            }
            if (l6 > this.rowsl) {
                long l11 = l8 * this.sliceStridel + l4 * this.rowStridel;
                return l5 == 0L ? l11 : -(l11 + 1L);
            }
            if (l == 0L) {
                return l5 == 0L ? l2 * this.rowStridel : Long.MIN_VALUE;
            }
            if (l7 < this.slicesl) {
                return l * this.sliceStridel + l2 * this.rowStridel + l3;
            }
            if (l7 > this.slicesl) {
                long l12 = l8 * this.sliceStridel + l2 * this.rowStridel;
                return l5 == 0L ? l12 : -(l12 + 1L);
            }
            long l13 = l * this.sliceStridel + l2 * this.rowStridel;
            return l5 == 0L ? l13 : Long.MIN_VALUE;
        }
        if (l3 < this.columnsl) {
            return l * this.sliceStridel + l2 * this.rowStridel + l3;
        }
        if (l3 > this.columnsl + 1L) {
            long l14 = (this.columnsl << 1) - l3;
            long l15 = l8 * this.sliceStridel + l4 * this.rowStridel + l14;
            return l5 == 0L ? l15 : -(l15 + 2L);
        }
        if (l2 == 0L) {
            if (l == 0L) {
                return l5 == 0L ? 1L : Long.MIN_VALUE;
            }
            if (l7 < this.slicesl) {
                long l16 = l8 * this.sliceStridel;
                return l5 == 0L ? l16 + 1L : -l16;
            }
            if (l7 > this.slicesl) {
                long l17 = l * this.sliceStridel;
                return l5 == 0L ? l17 + 1L : l17;
            }
            long l18 = l * this.sliceStridel;
            return l5 == 0L ? l18 + 1L : Long.MIN_VALUE;
        }
        if (l6 < this.rowsl) {
            long l19 = l8 * this.sliceStridel + l4 * this.rowStridel;
            return l5 == 0L ? l19 + 1L : -l19;
        }
        if (l6 > this.rowsl) {
            long l20 = l * this.sliceStridel + l2 * this.rowStridel;
            return l5 == 0L ? l20 + 1L : l20;
        }
        if (l == 0L) {
            long l21 = l2 * this.rowStridel + 1L;
            return l5 == 0L ? l21 : Long.MIN_VALUE;
        }
        if (l7 < this.slicesl) {
            long l22 = l8 * this.sliceStridel + l2 * this.rowStridel;
            return l5 == 0L ? l22 + 1L : -l22;
        }
        if (l7 > this.slicesl) {
            long l23 = l * this.sliceStridel + l2 * this.rowStridel;
            return l5 == 0L ? l23 + 1L : l23;
        }
        long l24 = l * this.sliceStridel + l2 * this.rowStridel;
        return l5 == 0L ? l24 + 1L : Long.MIN_VALUE;
    }

    public void pack(double d, int n, int n2, int n3, double[] dArray, int n4) {
        int n5 = this.getIndex(n, n2, n3);
        if (n5 >= 0) {
            dArray[n4 + n5] = d;
        } else if (n5 > Integer.MIN_VALUE) {
            dArray[n4 - n5] = -d;
        } else {
            throw new IllegalArgumentException(String.format("[%d][%d][%d] component cannot be modified (always zero)", n, n2, n3));
        }
    }

    public void pack(double d, long l, long l2, long l3, DoubleLargeArray doubleLargeArray, long l4) {
        long l5 = this.getIndex(l, l2, l3);
        if (l5 >= 0L) {
            doubleLargeArray.setDouble(l4 + l5, d);
        } else if (l5 > Long.MIN_VALUE) {
            doubleLargeArray.setDouble(l4 - l5, -d);
        } else {
            throw new IllegalArgumentException(String.format("[%d][%d][%d] component cannot be modified (always zero)", l, l2, l3));
        }
    }

    public void pack(double d, int n, int n2, int n3, double[][][] dArray) {
        int n4 = this.getIndex(n, n2, n3);
        int n5 = Math.abs(n4);
        int n6 = n5 / this.sliceStride;
        int n7 = n5 % this.sliceStride;
        int n8 = n7 / this.rowStride;
        int n9 = n7 % this.rowStride;
        if (n4 >= 0) {
            dArray[n6][n8][n9] = d;
        } else if (n4 > Integer.MIN_VALUE) {
            dArray[n6][n8][n9] = -d;
        } else {
            throw new IllegalArgumentException(String.format("[%d][%d] component cannot be modified (always zero)", n2, n3));
        }
    }

    public void pack(float f, int n, int n2, int n3, float[] fArray, int n4) {
        int n5 = this.getIndex(n, n2, n3);
        if (n5 >= 0) {
            fArray[n4 + n5] = f;
        } else if (n5 > Integer.MIN_VALUE) {
            fArray[n4 - n5] = -f;
        } else {
            throw new IllegalArgumentException(String.format("[%d][%d][%d] component cannot be modified (always zero)", n, n2, n3));
        }
    }

    public void pack(float f, long l, long l2, long l3, FloatLargeArray floatLargeArray, long l4) {
        long l5 = this.getIndex(l, l2, l3);
        if (l5 >= 0L) {
            floatLargeArray.setFloat(l4 + l5, f);
        } else if (l5 > Long.MIN_VALUE) {
            floatLargeArray.setFloat(l4 - l5, -f);
        } else {
            throw new IllegalArgumentException(String.format("[%d][%d][%d] component cannot be modified (always zero)", l, l2, l3));
        }
    }

    public void pack(float f, int n, int n2, int n3, float[][][] fArray) {
        int n4 = this.getIndex(n, n2, n3);
        int n5 = Math.abs(n4);
        int n6 = n5 / this.sliceStride;
        int n7 = n5 % this.sliceStride;
        int n8 = n7 / this.rowStride;
        int n9 = n7 % this.rowStride;
        if (n4 >= 0) {
            fArray[n6][n8][n9] = f;
        } else if (n4 > Integer.MIN_VALUE) {
            fArray[n6][n8][n9] = -f;
        } else {
            throw new IllegalArgumentException(String.format("[%d][%d][%d] component cannot be modified (always zero)", n, n2, n3));
        }
    }

    public double unpack(int n, int n2, int n3, double[] dArray, int n4) {
        int n5 = this.getIndex(n, n2, n3);
        if (n5 >= 0) {
            return dArray[n4 + n5];
        }
        if (n5 > Integer.MIN_VALUE) {
            return -dArray[n4 - n5];
        }
        return 0.0;
    }

    public double unpack(long l, long l2, long l3, DoubleLargeArray doubleLargeArray, long l4) {
        long l5 = this.getIndex(l, l2, l3);
        if (l5 >= 0L) {
            return doubleLargeArray.getDouble(l4 + l5);
        }
        if (l5 > Long.MIN_VALUE) {
            return -doubleLargeArray.getDouble(l4 - l5);
        }
        return 0.0;
    }

    public double unpack(int n, int n2, int n3, double[][][] dArray) {
        int n4 = this.getIndex(n, n2, n3);
        int n5 = Math.abs(n4);
        int n6 = n5 / this.sliceStride;
        int n7 = n5 % this.sliceStride;
        int n8 = n7 / this.rowStride;
        int n9 = n7 % this.rowStride;
        if (n4 >= 0) {
            return dArray[n6][n8][n9];
        }
        if (n4 > Integer.MIN_VALUE) {
            return -dArray[n6][n8][n9];
        }
        return 0.0;
    }

    public float unpack(int n, int n2, int n3, float[] fArray, int n4) {
        int n5 = this.getIndex(n, n2, n3);
        if (n5 >= 0) {
            return fArray[n4 + n5];
        }
        if (n5 > Integer.MIN_VALUE) {
            return -fArray[n4 - n5];
        }
        return 0.0f;
    }

    public float unpack(long l, long l2, long l3, FloatLargeArray floatLargeArray, long l4) {
        long l5 = this.getIndex(l, l2, l3);
        if (l5 >= 0L) {
            return floatLargeArray.getFloat(l4 + l5);
        }
        if (l5 > Long.MIN_VALUE) {
            return -floatLargeArray.getFloat(l4 - l5);
        }
        return 0.0f;
    }

    public float unpack(int n, int n2, int n3, float[][][] fArray) {
        int n4 = this.getIndex(n, n2, n3);
        int n5 = Math.abs(n4);
        int n6 = n5 / this.sliceStride;
        int n7 = n5 % this.sliceStride;
        int n8 = n7 / this.rowStride;
        int n9 = n7 % this.rowStride;
        if (n4 >= 0) {
            return fArray[n6][n8][n9];
        }
        if (n4 > Integer.MIN_VALUE) {
            return -fArray[n6][n8][n9];
        }
        return 0.0f;
    }
}

