package plugins.tprovoost.sequenceblocks.importer;

import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginBundled;
import icy.plugin.interface_.PluginLibrary;
import plugins.adufour.blocks.tools.io.IOBlock;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarString;
import plugins.adufour.vars.util.VarException;
import plugins.tprovoost.sequenceblocks.SequenceBlocks;

/**
 * Block to returns the currently opened file path of the specified SequenceFileImporter.
 * 
 * @author Stephane
 */
public class SequenceFileImporterGetOpened extends Plugin implements IOBlock, PluginLibrary, PluginBundled
{
    final protected Var<PositionedSequenceFileImporter> importer;
    final protected VarString path;

    public SequenceFileImporterGetOpened()
    {
        super();

        importer = new Var<PositionedSequenceFileImporter>("Importer", PositionedSequenceFileImporter.class);
        path = new VarString("path", "");
    }

    @Override
    public void run()
    {
        final PositionedSequenceFileImporter pi = importer.getValue();

        if (pi == null)
            throw new VarException(importer, "Importer is null !");

        path.setValue(pi.importer.getOpened());
    }

    @Override
    public void declareInput(VarList inputMap)
    {
        inputMap.add("importer", importer);
    }

    @Override
    public void declareOutput(VarList outputMap)
    {
        outputMap.add("path", path);
    }

    @Override
    public String getMainPluginClassName()
    {
        return SequenceBlocks.class.getName();
    }
}
