package plugins.tprovoost.sequenceblocks.loop;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;

import icy.file.SequenceFileImporter;
import icy.roi.ROI;
import icy.sequence.MetaDataUtil;
import plugins.adufour.vars.lang.VarROIArray;
import plugins.adufour.vars.util.VarException;
import plugins.tprovoost.sequenceblocks.importer.PositionedSequenceFileImporter;

/**
 * Simple batch loop to iterate over a set of XY region defined by ROIs from the specified opened
 * {@link SequenceFileImporter} object.
 * 
 * @author Stephane
 */
public class SequenceFileImporterRegionBatch extends SequenceFileImporterBatch
{
    protected final VarROIArray rois;
    protected List<Rectangle> regions;
    protected Rectangle regionMask;

    public SequenceFileImporterRegionBatch()
    {
        super();

        rois = new VarROIArray("XY regions (ROIs)");
    }

    @Override
    public void initializeLoop()
    {
        super.initializeLoop();

        final PositionedSequenceFileImporter pi = positionedImporter.getValue();

        // can iterate over XY dimension ?
        if ((pi.xyRegion == null) && (rois.getValue() != null))
        {
            final int s = (pi.s == -1) ? 0 : pi.s;

            try
            {
                // mask for region
                regionMask = new Rectangle(0, 0, MetaDataUtil.getSizeX(pi.getMetadata(), s),
                        MetaDataUtil.getSizeY(pi.getMetadata(), s));
            }
            catch (Exception e)
            {
                throw new VarException(element,
                        "Error while initializing SequenceFileImporter region batch: " + e.getMessage());
            }

            // build 2D regions from ROI
            regions = new ArrayList<Rectangle>();
            for (ROI roi : rois.getValue())
                regions.add(roi.getBounds5D().toRectangle2D().getBounds());

            // set limit
            limit = regions.size();
        }
        else
            limit = 1;
    }

    @Override
    public void beforeIteration()
    {
        // set current position XY region
        if (positionedImporter.getValue().xyRegion == null)
        {
            element.getValue().xyRegion = regions.get(getIterationCounter().getValue().intValue())
                    .intersection(regionMask);
            // force element changed event so loop get correctly executed
            element.valueChanged(element, element.getValue(), element.getValue());
        }
    }

    @Override
    public boolean isStopConditionReached()
    {
        return getIterationCounter().getValue().intValue() >= limit;
    }
}
