package plugins.fab.invert;

import icy.image.IcyBufferedImage;
import icy.plugin.abstract_.Plugin;
import icy.plugin.abstract_.PluginActionable;
import icy.plugin.interface_.PluginImageAnalysis;
import icy.sequence.Sequence;
import icy.type.collection.array.Array1DUtil;
import icy.type.collection.array.ArrayUtil;

import java.util.ArrayList;

/**
 * 
 * Inverts data in the image. ( values are inverted between min and max ie: min and max will still be the same at the end of the process )
 * 
 * @author Fabrice de Chaumont
 *
 */
public class Invert extends PluginActionable {

	@Override
	public void run() {

		invert( getFocusedSequence() );

	}


	public static void invert(Sequence sequence ) {

		if ( sequence == null ) return;
				
		double[] minAndMax = sequence.getChannelsGlobalTypeBounds();
		
		double min = minAndMax[0];
		double max = minAndMax[1];		 
		
		ArrayList<IcyBufferedImage> images = sequence.getAllImage();
				
		for ( IcyBufferedImage image : images )
		{
			for ( int channel=0 ; channel < images.get( 0 ).getSizeC() ; channel++ )
			{
				
				double[] resultDataBuffer = Array1DUtil.arrayToDoubleArray( image.getDataXY( channel ) , image.isSignedDataType() );
				for ( int i = 0 ; i < resultDataBuffer.length ; i++ )
				{					
					resultDataBuffer[i] = min + max - resultDataBuffer[i] ;
				}
				Array1DUtil.doubleArrayToArray( resultDataBuffer , image.getDataXY( channel ) ) ;
			}
		}
		sequence.dataChanged();
		
	}

	
	
}
