package plugins.tprovoost.sequenceblocks.files;

import java.io.File;

import icy.file.FileUtil;
import icy.file.Saver;
import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginBundled;
import icy.plugin.interface_.PluginLibrary;
import icy.util.StringUtil;
import plugins.adufour.blocks.tools.sequence.SequenceBlock;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarBoolean;
import plugins.adufour.vars.lang.VarMutable;
import plugins.adufour.vars.lang.VarSequence;
import plugins.adufour.vars.util.VarException;
import plugins.tprovoost.sequenceblocks.SequenceBlocks;

/**
 * Block to save a Sequence into a file
 * 
 * @author Stephane
 */
public class SaveSequence extends Plugin implements SequenceBlock, PluginLibrary, PluginBundled
{
    final protected VarMutable f_in = new VarMutable("File", null)
    {
        @Override
        public boolean isAssignableFrom(@SuppressWarnings("rawtypes") Var source)
        {
            return String.class == source.getType() || File.class == source.getType();
        }
    };
    final protected VarBoolean overwriteForce = new VarBoolean("Overwrite", Boolean.TRUE);
    final protected VarBoolean multipleFile = new VarBoolean("Multiple file", Boolean.FALSE);
    final protected VarSequence seq_out = new VarSequence("Sequence", null);

    @Override
    public void run()
    {
        if (seq_out.getValue() != null)
        {
            final Object obj = f_in.getValue();
            if (obj != null)
            {
                File f;

                if (obj instanceof String)
                    f = new File((String) obj);
                else
                    f = (File) obj;

                if (f.isDirectory())
                    f = new File(f.getAbsolutePath() + FileUtil.separator + seq_out.getValue() + ".tif");

                if (f.exists() && !overwriteForce.getValue().booleanValue())
                    throw new VarException(f_in,
                            "File already exists. If you want to overwrite, please check the \"overwrite\" field.");

                if (StringUtil.isEmpty(FileUtil.getFileExtension(f.getAbsolutePath(), false)))
                    f = new File(f.getAbsolutePath() + ".tif");

                // save sequence
                Saver.save(seq_out.getValue(), f, multipleFile.getValue().booleanValue(), false);
            }
        }
    }

    @Override
    public void declareInput(VarList inputMap)
    {
        inputMap.add("file", f_in);
        inputMap.add("sequence", seq_out);
        inputMap.add("overwrite", overwriteForce);
        inputMap.add("multiple file", multipleFile);
    }

    @Override
    public void declareOutput(VarList outputMap)
    {
        //
    }

    @Override
    public String getMainPluginClassName()
    {
        return SequenceBlocks.class.getName();
    }
}
