package plugins.adufour.blocks.tools.roi;

import icy.plugin.abstract_.Plugin;
import icy.roi.ROI;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.VarROIArray;

public class SubtractROI extends Plugin implements ROIBlock
{
    VarROIArray roiA   = new VarROIArray("List of ROI #1");
    
    VarROIArray roiB   = new VarROIArray("List of ROI #2");
    
    VarROIArray roiOut = new VarROIArray("Subtracted ROI");
    
    @Override
    public void run()
    {
        roiOut.setValue(new ROI[0]);
        
        for (ROI a : roiA.getValue())
        {
            ROI subtraction = a.getCopy();
            
            for (ROI b : roiB.getValue())
                subtraction = subtraction.getSubtraction(b);
            
            if (subtraction == null || subtraction.isEmpty()) continue;
            
            if (!subtraction.getBounds5D().isEmpty()) roiOut.add(subtraction);
        }
    }
    
    @Override
    public void declareInput(VarList inputMap)
    {
        inputMap.add("List of ROI #1", roiA);
        inputMap.add("List of ROI #2", roiB);
    }
    
    @Override
    public void declareOutput(VarList outputMap)
    {
        outputMap.add("subtraction output ROI", roiOut);
    }
    
}
