/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.ui.common;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import org.pushingpixels.flamingo.internal.ui.common.BasicCommandToggleButtonUI;
import org.pushingpixels.flamingo.internal.utils.FlamingoUtilities;

public class BasicCommandToggleMenuButtonUI
extends BasicCommandToggleButtonUI {
    public static ComponentUI createUI(JComponent c) {
        return new BasicCommandToggleMenuButtonUI();
    }

    @Override
    protected void paintButtonIcon(Graphics g, Rectangle iconRect) {
        boolean isSelected = this.commandButton.getActionModel().isSelected();
        if (isSelected) {
            Color selectionColor = FlamingoUtilities.getColor(Color.blue.darker(), "Table.selectionBackground", "textHighlight");
            Rectangle extended = new Rectangle(iconRect.x - 1, iconRect.y - 1, iconRect.width + 1, iconRect.height + 1);
            g.setColor(selectionColor);
            g.fillRect(extended.x, extended.y, extended.width, extended.height);
            g.setColor(selectionColor.darker());
            g.drawRect(extended.x, extended.y, extended.width, extended.height);
        }
        super.paintButtonIcon(g, iconRect);
        Icon iconToPaint = this.getIconToPaint();
        if (isSelected && iconToPaint == null) {
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setColor(this.getForegroundColor(this.commandButton.getActionModel().isEnabled()));
            int iw = iconRect.width;
            int ih = iconRect.height;
            GeneralPath path = new GeneralPath();
            path.moveTo(0.2f * (float)iw, 0.5f * (float)ih);
            path.lineTo(0.42f * (float)iw, 0.8f * (float)ih);
            path.lineTo(0.8f * (float)iw, 0.2f * (float)ih);
            g2d.translate(iconRect.x, iconRect.y);
            BasicStroke stroke = new BasicStroke(0.1f * (float)iw, 1, 1);
            g2d.setStroke(stroke);
            g2d.draw(path);
            g2d.dispose();
        }
    }

    @Override
    protected boolean isPaintingBackground() {
        boolean isActionRollover = this.commandButton.getActionModel().isRollover();
        return isActionRollover || !this.commandButton.isFlat();
    }
}

