/*
 * Decompiled with CFR 0.152.
 */
package mitiv.linalg;

import mitiv.exception.IncorrectSpaceException;
import mitiv.linalg.LinearOperator;
import mitiv.linalg.Vector;
import mitiv.linalg.VectorSpace;
import mitiv.utils.Poly;

public class TruncatedConjugateGradient {
    public static final int SUCCESS = 0;
    public static final int FAILURE = -1;
    public static final int IN_PROGRESS = 0;
    public static final int CONVERGED = 1;
    public static final int TRUNCATED = 2;
    public static final int TOO_MANY_ITERATIONS = 3;
    public static final int A_IS_NOT_POSITIVE_DEFINITE = 4;
    public static final int P_IS_NOT_POSITIVE_DEFINITE = 5;
    public static final int BUG = 7;
    public static final int FOREVER = -1;
    public static final double DEFAULT_ABSOLUTE_TOLERANCE = 0.0;
    public static final double DEFAULT_RELATIVE_TOLERANCE = 1.0E-6;
    public static final int DEFAULT_MAXIMUM_ITERATIONS = -1;
    protected double atol = 0.0;
    protected double rtol = 1.0E-6;
    protected int maxiter = -1;
    protected LinearOperator A = null;
    protected Vector b = null;
    protected double delta = 0.0;

    public void setDefaults() {
        this.atol = 0.0;
        this.rtol = 1.0E-6;
        this.maxiter = -1;
    }

    public void releaseMemory() {
        this.b = null;
    }

    public void setPreconditioner(LinearOperator linearOperator) {
    }

    public void setRightHandSideVector(Vector vector) {
    }

    public void setLeftHandSideOperator(LinearOperator linearOperator) {
    }

    public double getAbsoluteTolerance() {
        return this.atol;
    }

    public void setAbsoluteTolerance(double d) {
        this.atol = Math.max(0.0, d);
    }

    public double getRelativeTolerance() {
        return this.rtol;
    }

    public void setRelativeTolerance(double d) {
        this.rtol = Math.max(0.0, d);
    }

    public int getMaximumIterations() {
        return this.maxiter;
    }

    public void setMaximumIterations(int n) {
        this.maxiter = n >= 0 ? n : -1;
    }

    public static int adjustStep(Vector vector, Vector vector2, double d, double d2) throws IncorrectSpaceException {
        if (d < 0.0) {
            return -1;
        }
        if (d2 == d) {
            return 0;
        }
        double d3 = vector2.dot(vector2);
        double d4 = 2.0 * vector2.dot(vector);
        double d5 = (d2 + d) * (d2 - d);
        double[] dArray = new double[2];
        double d6 = 0.0;
        if (Poly.solveQuadratic(dArray, d3, d4, d5) >= 1) {
            d6 = d2 > d ? Math.min(0.0, dArray[0]) : Math.max(0.0, dArray[1]);
        }
        if (d6 == 0.0) {
            return -1;
        }
        vector.add(d6, vector2);
        return 0;
    }

    public int truncatedConjugateGradient(LinearOperator linearOperator, Vector vector, Vector vector2, double d, int n) throws IncorrectSpaceException {
        return this.truncatedConjugateGradient(linearOperator, vector, vector2, null, d, n);
    }

    public int truncatedConjugateGradient(LinearOperator linearOperator, Vector vector, Vector vector2, LinearOperator linearOperator2, double d, int n) throws IncorrectSpaceException {
        LinearOperator.checkLinearProblem(linearOperator, vector, vector2, true);
        VectorSpace vectorSpace = vector.getSpace();
        Vector vector3 = vectorSpace.create();
        Vector vector4 = vectorSpace.create();
        Vector vector5 = vectorSpace.create();
        Vector vector6 = null;
        vector2.fill(0.0);
        double d2 = 0.0;
        vector3.copy(vector);
        if (linearOperator2 != null) {
            if (linearOperator2.getInputSpace() != vectorSpace || linearOperator2.getOutputSpace() != vectorSpace) {
                throw new IncorrectSpaceException();
            }
            vector6 = vectorSpace.create();
            linearOperator2.apply(vector6, vector3);
        } else {
            vector6 = vector3;
        }
        double d3 = vector6.dot(vector3);
        double d4 = 0.0;
        double d5 = 0.0;
        int n2 = 0;
        while (!(d3 <= d5)) {
            double d6;
            if (n >= 0 && n2 >= n) {
                return 3;
            }
            if (n2 == 0) {
                vector4.copy(vector6);
            } else {
                d6 = d3 / d4;
                vector4.combine(1.0, vector6, d6, vector4);
            }
            linearOperator.apply(vector5, vector4);
            d6 = vector4.dot(vector5);
            if (d6 <= 0.0) {
                TruncatedConjugateGradient.adjustStep(vector2, vector4, d, d2);
                return 4;
            }
            double d7 = d3 / d6;
            vector2.add(d7, vector4);
            d2 = vector2.norm2();
            if (d2 >= d) {
                TruncatedConjugateGradient.adjustStep(vector2, vector4, d, d2);
                return 2;
            }
            vector3.add(-d7, vector5);
            if (linearOperator2 != null) {
                linearOperator2.apply(vector6, vector3);
            }
            d4 = d3;
            d3 = vector6.dot(vector3);
            ++n2;
        }
        return 1;
    }
}

