/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.ArrayList;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.units.unit.Unit;
import ome.xml.model.primitives.Color;
import ome.xml.model.primitives.NonNegativeInteger;

public class IMODReader
extends FormatReader {
    private static final String MAGIC_STRING = "IMODV1.2";
    private float[][][][] points;
    private byte[][] colors;

    public IMODReader() {
        super("IMOD", "mod");
        this.domains = new String[]{"Unknown"};
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 8;
        if (!FormatTools.validStream(stream, 8, false)) {
            return false;
        }
        return stream.readString(8).equals(MAGIC_STRING);
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.points = null;
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        String check = this.in.readString(8);
        if (!check.equals(MAGIC_STRING)) {
            throw new FormatException("Invalid file ID: " + check);
        }
        CoreMetadata m = (CoreMetadata)this.core.get(0);
        String filename = this.in.readString(128);
        m.sizeX = this.in.readInt();
        m.sizeY = this.in.readInt();
        m.sizeZ = this.in.readInt();
        int nObjects = this.in.readInt();
        this.points = new float[nObjects][][][];
        this.colors = new byte[nObjects][3];
        int flags = this.in.readInt();
        int drawMode = this.in.readInt();
        int mouseMode = this.in.readInt();
        int blackLevel = this.in.readInt();
        int whiteLevel = this.in.readInt();
        float xOffset = this.in.readFloat();
        float yOffset = this.in.readFloat();
        float zOffset = this.in.readFloat();
        float xScale = this.in.readFloat();
        float yScale = this.in.readFloat();
        float zScale = this.in.readFloat();
        int currentObject = this.in.readInt();
        int currentContour = this.in.readInt();
        int currentPoint = this.in.readInt();
        int res = this.in.readInt();
        int thresh = this.in.readInt();
        float pixSize = this.in.readFloat();
        int pixSizeUnits = this.in.readInt();
        int checksum = this.in.readInt();
        float alpha = this.in.readFloat();
        float beta = this.in.readFloat();
        float gamma = this.in.readFloat();
        this.addGlobalMeta("Model name", filename);
        this.addGlobalMeta("Model flags", flags);
        this.addGlobalMeta("Model drawing mode", drawMode);
        this.addGlobalMeta("Mouse mode", mouseMode);
        this.addGlobalMeta("Black level", blackLevel);
        this.addGlobalMeta("White level", whiteLevel);
        this.addGlobalMeta("X offset", xOffset);
        this.addGlobalMeta("Y offset", yOffset);
        this.addGlobalMeta("Z offset", zOffset);
        this.addGlobalMeta("X scale", xScale);
        this.addGlobalMeta("Y scale", yScale);
        this.addGlobalMeta("Z scale", zScale);
        this.addGlobalMeta("Alpha", alpha);
        this.addGlobalMeta("Beta", beta);
        this.addGlobalMeta("Gamma", gamma);
        MetadataStore store = this.makeFilterMetadata();
        ArrayList<String> roiIDs = new ArrayList<String>();
        for (int obj = 0; obj < nObjects; ++obj) {
            String objt = this.in.readString(4);
            while (!objt.equals("OBJT") && this.in.getFilePointer() < this.in.length()) {
                String prefix = "Object #" + obj + " ";
                if (objt.equals("IMAT")) {
                    this.addGlobalMeta(prefix + "ambient", this.in.read());
                    this.addGlobalMeta(prefix + "diffuse", this.in.read());
                    this.addGlobalMeta(prefix + "specular", this.in.read());
                    this.addGlobalMeta(prefix + "shininess", this.in.read());
                    this.addGlobalMeta(prefix + "fill red", this.in.read());
                    this.addGlobalMeta(prefix + "fill green", this.in.read());
                    this.addGlobalMeta(prefix + "fill blue", this.in.read());
                    this.addGlobalMeta(prefix + "sphere quality", this.in.read());
                    this.in.skipBytes(4);
                    this.addGlobalMeta(prefix + "black level", this.in.read());
                    this.addGlobalMeta(prefix + "white level", this.in.read());
                    this.in.skipBytes(2);
                }
                objt = this.in.readString(4);
            }
            if (!objt.equals("OBJT")) break;
            String objName = this.in.readString(64);
            this.in.skipBytes(64);
            int nContours = this.in.readInt();
            this.points[obj] = new float[nContours][][];
            int objFlags = this.in.readInt();
            int axis = this.in.readInt();
            int objDrawMode = this.in.readInt();
            float red = this.in.readFloat();
            float green = this.in.readFloat();
            float blue = this.in.readFloat();
            this.colors[obj][0] = (byte)(red * 255.0f);
            this.colors[obj][1] = (byte)(green * 255.0f);
            this.colors[obj][2] = (byte)(blue * 255.0f);
            int pixelRadius = this.in.readInt();
            int pixelSymbol = this.in.read();
            int symbolSize = this.in.read();
            int lineWidth2D = this.in.read();
            int lineWidth3D = this.in.read();
            int lineStyle = this.in.read();
            int symbolFlags = this.in.read();
            int symbolPadding = this.in.read();
            int transparency = this.in.read();
            int nMeshes = this.in.readInt();
            int nSurfaces = this.in.readInt();
            if (this.getMetadataOptions().getMetadataLevel() == MetadataLevel.ALL) {
                String roiID = MetadataTools.createLSID("ROI", obj);
                store.setROIID(roiID, obj);
                store.setROIName(objName, obj);
                roiIDs.add(roiID);
            }
            int nextShape = 0;
            for (int contour = 0; contour < nContours; ++contour) {
                Length l;
                boolean wild;
                this.in.skipBytes(4);
                int nPoints = this.in.readInt();
                int contourFlags = this.in.readInt();
                int timeIndex = this.in.readInt();
                int surface = this.in.readInt();
                if ((long)nPoints > this.in.length() || nPoints < 0) {
                    while (!"CONT".equals(this.in.readString(4))) {
                        this.in.seek(this.in.getFilePointer() - 8L);
                    }
                    nPoints = this.in.readInt();
                    contourFlags = this.in.readInt();
                    timeIndex = this.in.readInt();
                    surface = this.in.readInt();
                }
                this.points[obj][contour] = new float[nPoints][3];
                for (int p = 0; p < nPoints; ++p) {
                    for (int i = 0; i < this.points[obj][contour][p].length; ++i) {
                        this.points[obj][contour][p][i] = this.in.readFloat();
                    }
                }
                if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.ALL) continue;
                boolean bl = wild = (contourFlags & 0x10) == 16;
                if (wild) {
                    int r = this.colors[obj][0] & 0xFF;
                    int g = this.colors[obj][1] & 0xFF;
                    int b = this.colors[obj][2] & 0xFF;
                    for (int i = 0; i < nPoints; ++i) {
                        String shapeID = MetadataTools.createLSID("Shape", obj, nextShape);
                        store.setPointID(shapeID, obj, nextShape);
                        store.setPointStrokeColor(new Color(r, g, b, 255), obj, nextShape);
                        Length l2 = new Length(new Double(lineWidth2D), UNITS.PIXEL);
                        store.setPointStrokeWidth(l2, obj, nextShape);
                        if (lineStyle == 1) {
                            store.setPointStrokeDashArray("5", obj, nextShape);
                        }
                        store.setPointX(new Double(this.points[obj][contour][i][0]), obj, nextShape);
                        store.setPointY(new Double(this.points[obj][contour][i][1]), obj, nextShape);
                        if (this.points[obj][contour][i][2] >= 0.0f) {
                            store.setPointTheZ(new NonNegativeInteger((int)this.points[obj][contour][i][2]), obj, nextShape);
                        }
                        ++nextShape;
                    }
                    continue;
                }
                String shapeID = MetadataTools.createLSID("Shape", obj, nextShape);
                boolean closed = (contourFlags & 8) == 0;
                int r = this.colors[obj][0] & 0xFF;
                int g = this.colors[obj][1] & 0xFF;
                int b = this.colors[obj][2] & 0xFF;
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < nPoints; ++i) {
                    sb.append(this.points[obj][contour][i][0]);
                    sb.append(",");
                    sb.append(this.points[obj][contour][i][1]);
                    if (i >= nPoints - 1) continue;
                    sb.append(" ");
                }
                if (closed) {
                    store.setPolygonID(shapeID, obj, nextShape);
                    store.setPolygonStrokeColor(new Color(r, g, b, 255), obj, nextShape);
                    l = new Length(new Double(lineWidth2D), UNITS.PIXEL);
                    store.setPolygonStrokeWidth(l, obj, nextShape);
                    if (lineStyle == 1) {
                        store.setPolygonStrokeDashArray("5", obj, nextShape);
                    }
                    if (nPoints > 0 && this.points[obj][contour][0][2] >= 0.0f) {
                        store.setPolygonTheZ(new NonNegativeInteger((int)this.points[obj][contour][0][2]), obj, nextShape);
                    }
                    store.setPolygonPoints(sb.toString(), obj, nextShape);
                } else {
                    store.setPolylineID(shapeID, obj, nextShape);
                    store.setPolylineStrokeColor(new Color(r, g, b, 255), obj, nextShape);
                    l = new Length(new Double(lineWidth2D), UNITS.PIXEL);
                    store.setPolylineStrokeWidth(l, obj, nextShape);
                    if (lineStyle == 1) {
                        store.setPolylineStrokeDashArray("5", obj, nextShape);
                    }
                    if (nPoints > 0 && this.points[obj][contour][0][2] >= 0.0f) {
                        store.setPolylineTheZ(new NonNegativeInteger((int)this.points[obj][contour][0][2]), obj, nextShape);
                    }
                    store.setPolylinePoints(sb.toString(), obj, nextShape);
                }
                ++nextShape;
            }
            for (int mesh = 0; mesh < nMeshes; ++mesh) {
                this.in.skipBytes(4);
                int vsize = this.in.readInt();
                int lsize = this.in.readInt();
                int meshFlags = this.in.readInt();
                short timeIndex = this.in.readShort();
                short surface = this.in.readShort();
                this.in.skipBytes(12 * vsize + 4 * lsize);
            }
        }
        double physicalX = 0.0;
        double physicalY = 0.0;
        double physicalZ = 0.0;
        while (this.in.getFilePointer() + 4L < this.in.length()) {
            String chunkType = this.in.readString(4);
            if (chunkType.equals("IMAT")) {
                this.in.skipBytes(20);
                continue;
            }
            if (chunkType.equals("VIEW")) {
                this.in.skipBytes(4);
                if (this.in.readInt() == 1) continue;
                this.in.skipBytes(176);
                int bytesPerView = this.in.readInt();
                this.in.skipBytes(bytesPerView);
                continue;
            }
            if (!chunkType.equals("MINX")) continue;
            this.in.skipBytes(40);
            physicalX = this.in.readFloat();
            physicalY = this.in.readFloat();
            physicalZ = this.in.readFloat();
        }
        m.sizeT = 1;
        m.sizeC = 3;
        m.rgb = true;
        m.interleaved = true;
        m.imageCount = this.getSizeT() * this.getSizeZ();
        m.littleEndian = false;
        m.dimensionOrder = "XYCZT";
        m.pixelType = 1;
        MetadataTools.populatePixels(store, this);
        if (this.getMetadataOptions().getMetadataLevel() == MetadataLevel.ALL) {
            for (int i = 0; i < roiIDs.size(); ++i) {
                store.setROIID((String)roiIDs.get(i), i);
                store.setImageROIRef((String)roiIDs.get(i), 0, i);
            }
        }
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            Length z;
            Length y;
            Length x;
            Unit<Length> physicalSizeUnit = this.convertUnits(pixSizeUnits);
            if (physicalX > 0.0 && (x = FormatTools.getPhysicalSizeX((Double)physicalX, physicalSizeUnit)) != null) {
                store.setPixelsPhysicalSizeX(x, 0);
            }
            if (physicalY > 0.0 && (y = FormatTools.getPhysicalSizeY((Double)physicalY, physicalSizeUnit)) != null) {
                store.setPixelsPhysicalSizeY(y, 0);
            }
            if (physicalZ > 0.0 && (z = FormatTools.getPhysicalSizeZ((Double)physicalZ, physicalSizeUnit)) != null) {
                store.setPixelsPhysicalSizeZ(z, 0);
            }
        }
    }

    private Unit<Length> convertUnits(int units) {
        switch (units) {
            case 0: {
                return UNITS.PIXEL;
            }
            case 1: {
                return UNITS.METER;
            }
            case 3: {
                return UNITS.KILOMETER;
            }
            case -2: {
                return UNITS.CENTIMETER;
            }
            case -3: {
                return UNITS.MILLIMETER;
            }
            case -6: {
                return UNITS.MICROMETER;
            }
            case -9: {
                return UNITS.NANOMETER;
            }
            case -10: {
                return UNITS.ANGSTROM;
            }
            case -12: {
                return UNITS.PICOMETER;
            }
        }
        return UNITS.MICROMETER;
    }
}

