package plugins.ylemontag.sequencecomparator.comparators;

import icy.sequence.Sequence;
import plugins.ylemontag.sequencecomparator.ErrorMeasure;
import plugins.ylemontag.ssim.SSIMCalculator;

/**
 * 
 * @author Yoann Le Montagner
 *
 * Global SSIM distance 
 */
public class GlobalSSIM extends PlaneSeparableGlobalComparator
{	
	private SSIMCalculator _calculator;
	
	/**
	 * Constructor
	 */
	public GlobalSSIM(String distanceName, SSIMCalculator calculator)
	{
		super(distanceName);
		if(calculator==null) {
			throw new IllegalArgumentException("No SSIM calculator specified");
		}
		_calculator = calculator.clone();
	}
	
	@Override
	protected double aggregateOutsideXY(double accu, double errorOverPlane)
	{
		return accu + errorOverPlane;
	}

	@Override
	protected double computePlaneError(int sizeX, int sizeY, double[] refPlane, double[] seqPlane)
	{
		return _calculator.computeMean(sizeX, sizeY, refPlane, seqPlane);
	}
	
	@Override
	protected void normalizeErrorMeasure(ErrorMeasure retVal, Sequence seq)
	{
		int sizeZ = seq.getSizeZ();
		int sizeT = seq.getSizeT();
		int sizeC = seq.getSizeC();
		retVal.errorAll = normalize0D(retVal.errorAll, sizeC*sizeT*sizeZ);
		normalize1D(retVal.errorZ, sizeC*sizeT);
		normalize1D(retVal.errorT, sizeC*sizeZ);
		normalize1D(retVal.errorC, sizeT*sizeZ);
	}
	
	/**
	 * Normalization function for 0D arrays
	 */
	private double normalize0D(double src, double factor) {
		return src/factor;
	}
	
	/**
	 * Normalization function for 1D arrays
	 */
	private void normalize1D(double[] target, double factor) {
		for(int k=0; k<target.length; ++k) {
			target[k] /= factor;
		}
	}
}
