/*
 * Decompiled with CFR 0.152.
 */
package mitiv.base.mapping;

import mitiv.exception.IncorrectSpaceException;
import mitiv.linalg.Vector;
import mitiv.linalg.VectorSpace;

public abstract class Mapping {
    protected final VectorSpace inputSpace;
    protected final VectorSpace outputSpace;

    protected Mapping(VectorSpace vectorSpace, VectorSpace vectorSpace2) {
        this.inputSpace = vectorSpace;
        this.outputSpace = vectorSpace2;
    }

    protected Mapping(VectorSpace vectorSpace) {
        this.inputSpace = vectorSpace;
        this.outputSpace = vectorSpace;
    }

    public VectorSpace getInputSpace() {
        return this.inputSpace;
    }

    public VectorSpace getOutputSpace() {
        return this.outputSpace;
    }

    public boolean isEndomorphism() {
        return this.outputSpace == this.inputSpace;
    }

    public void apply(Vector vector, Vector vector2) throws IncorrectSpaceException {
        if (!this.outputSpace.owns(vector)) {
            throw new IncorrectSpaceException("Destination does not belong to the output space");
        }
        if (!this.inputSpace.owns(vector2)) {
            throw new IncorrectSpaceException("Source does not belong to the input space");
        }
        this._apply(vector, vector2);
    }

    protected abstract void _apply(Vector var1, Vector var2);
}

