/*
 * Decompiled with CFR 0.152.
 */
package mitiv.deconv;

import mitiv.array.ShapedArray;
import mitiv.base.Shape;
import mitiv.deconv.ConvolutionDouble2D;
import mitiv.deconv.WeightedConvolutionDouble;
import mitiv.linalg.Vector;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.ShapedVector;

class WeightedConvolutionDouble2D
extends WeightedConvolutionDouble {
    private final int dim1;
    private final int off1;
    private final int end1;
    private final int dim2;
    private final int off2;
    private final int end2;
    private final ConvolutionDouble2D cnvl;

    public WeightedConvolutionDouble2D(ConvolutionDouble2D convolutionDouble2D) {
        super(convolutionDouble2D.getInputSpace(), convolutionDouble2D.getOutputSpace());
        this.cnvl = convolutionDouble2D;
        Shape shape = convolutionDouble2D.workShape;
        Shape shape2 = convolutionDouble2D.getOutputSpace().getShape();
        int[] nArray = convolutionDouble2D.outputOffsets;
        this.dim1 = shape.dimension(0);
        this.off1 = nArray[0];
        this.end1 = this.off1 + shape2.dimension(0);
        this.dim2 = shape.dimension(1);
        this.off2 = nArray[1];
        this.end2 = this.off2 + shape2.dimension(1);
    }

    @Override
    protected double _cost(double d, Vector vector) {
        this.checkSetup();
        this.cnvl.push((ShapedVector)vector, false);
        this.cnvl.convolve(false);
        double d2 = 0.0;
        double[] dArray = this.cnvl.getWorkArray();
        int n = 0;
        if (this.wgt == null) {
            for (int i = this.off2; i < this.end2; ++i) {
                int n2 = 2 * (this.off1 + this.dim1 * i);
                for (int j = this.off1; j < this.end1; ++j) {
                    double d3 = dArray[n2] - this.dat[n];
                    d2 += d3 * d3;
                    ++n;
                    n2 += 2;
                }
            }
        } else {
            for (int i = this.off2; i < this.end2; ++i) {
                int n3 = 2 * (this.off1 + this.dim1 * i);
                for (int j = this.off1; j < this.end1; ++j) {
                    double d4 = this.wgt[n];
                    double d5 = dArray[n3] - this.dat[n];
                    d2 += d4 * d5 * d5;
                    ++n;
                    n3 += 2;
                }
            }
        }
        return d * d2 / 2.0;
    }

    @Override
    protected double _cost(double d, Vector vector, Vector vector2, boolean bl) {
        int n;
        int n2;
        this.checkSetup();
        this.cnvl.push((ShapedVector)vector, false);
        this.cnvl.convolve(false);
        boolean bl2 = this.wgt != null;
        double d2 = d;
        double d3 = 0.0;
        double[] dArray = this.cnvl.getWorkArray();
        int n3 = 0;
        int n4 = 0;
        for (n2 = 0; n2 < this.off2; ++n2) {
            for (n = 0; n < this.dim1; ++n) {
                dArray[n4] = 0.0;
                dArray[n4 + 1] = 0.0;
                n4 += 2;
            }
        }
        for (n2 = this.off2; n2 < this.end2; ++n2) {
            double d4;
            for (n = 0; n < this.off1; ++n) {
                dArray[n4] = 0.0;
                dArray[n4 + 1] = 0.0;
                n4 += 2;
            }
            if (bl2) {
                for (n = this.off1; n < this.end1; ++n) {
                    d4 = this.wgt[n3];
                    double d5 = dArray[n4] - this.dat[n3];
                    double d6 = d4 * d5;
                    d3 += d5 * d6;
                    dArray[n4] = d2 * d6;
                    dArray[n4 + 1] = 0.0;
                    ++n3;
                    n4 += 2;
                }
            } else {
                for (n = this.off1; n < this.end1; ++n) {
                    d4 = dArray[n4] - this.dat[n3];
                    d3 += d4 * d4;
                    dArray[n4] = d2 * d4;
                    dArray[n4 + 1] = 0.0;
                    ++n3;
                    n4 += 2;
                }
            }
            for (n = this.end1; n < this.dim1; ++n) {
                dArray[n4] = 0.0;
                dArray[n4 + 1] = 0.0;
                n4 += 2;
            }
        }
        for (n2 = this.end2; n2 < this.dim2; ++n2) {
            for (n = 0; n < this.dim1; ++n) {
                dArray[n4] = 0.0;
                dArray[n4 + 1] = 0.0;
                n4 += 2;
            }
        }
        double[] dArray2 = ((DoubleShapedVector)vector2).getData();
        this.cnvl.convolve(true);
        if (bl) {
            n3 = 0;
            n4 = 0;
            while (n3 < dArray2.length) {
                dArray2[n3] = dArray[n4];
                ++n3;
                n4 += 2;
            }
        } else {
            n3 = 0;
            n4 = 0;
            while (n3 < dArray2.length) {
                int n5 = n3++;
                dArray2[n5] = dArray2[n5] + dArray[n4];
                n4 += 2;
            }
        }
        return d * d3 / 2.0;
    }

    @Override
    public void setPSF(ShapedArray shapedArray, int[] nArray, boolean bl) {
        this.cnvl.setPSF(shapedArray, nArray, bl);
    }

    @Override
    public void setPSF(ShapedVector shapedVector) {
        this.cnvl.setPSF(shapedVector);
    }
}

