/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.buffer.tbyte;

import cern.colt.PersistentObject;
import cern.colt.buffer.tbyte.ByteBuffer3DConsumer;
import cern.colt.list.tbyte.ByteArrayList;

public class ByteBuffer3D
extends PersistentObject
implements ByteBuffer3DConsumer {
    private static final long serialVersionUID = 1L;
    protected ByteBuffer3DConsumer target;
    protected byte[] xElements;
    protected byte[] yElements;
    protected byte[] zElements;
    protected ByteArrayList xList;
    protected ByteArrayList yList;
    protected ByteArrayList zList;
    protected int capacity;
    protected int size;

    public ByteBuffer3D(ByteBuffer3DConsumer target, int capacity) {
        this.target = target;
        this.capacity = capacity;
        this.xElements = new byte[capacity];
        this.yElements = new byte[capacity];
        this.zElements = new byte[capacity];
        this.xList = new ByteArrayList(this.xElements);
        this.yList = new ByteArrayList(this.yElements);
        this.zList = new ByteArrayList(this.zElements);
        this.size = 0;
    }

    public void add(byte x, byte y, byte z) {
        if (this.size == this.capacity) {
            this.flush();
        }
        this.xElements[this.size] = x;
        this.yElements[this.size] = y;
        this.zElements[this.size++] = z;
    }

    @Override
    public void addAllOf(ByteArrayList xElements, ByteArrayList yElements, ByteArrayList zElements) {
        int listSize = xElements.size();
        if (this.size + listSize >= this.capacity) {
            this.flush();
        }
        this.target.addAllOf(xElements, yElements, zElements);
    }

    public void clear() {
        this.size = 0;
    }

    public void flush() {
        if (this.size > 0) {
            this.xList.setSize(this.size);
            this.yList.setSize(this.size);
            this.zList.setSize(this.size);
            this.target.addAllOf(this.xList, this.yList, this.zList);
            this.size = 0;
        }
    }
}

