/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tobject;

import cern.colt.PersistentObject;
import cern.colt.list.tobject.ObjectArrayList;
import cern.colt.matrix.tobject.ObjectMatrix1D;
import cern.colt.matrix.tobject.impl.DenseObjectMatrix1D;
import cern.colt.matrix.tobject.impl.SparseObjectMatrix1D;

public class ObjectFactory1D
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    public static final ObjectFactory1D dense = new ObjectFactory1D();
    public static final ObjectFactory1D sparse = new ObjectFactory1D();

    protected ObjectFactory1D() {
    }

    public ObjectMatrix1D append(ObjectMatrix1D A, ObjectMatrix1D B) {
        ObjectMatrix1D matrix = this.make((int)(A.size() + B.size()));
        matrix.viewPart(0, (int)A.size()).assign(A);
        matrix.viewPart((int)A.size(), (int)B.size()).assign(B);
        return matrix;
    }

    public ObjectMatrix1D make(ObjectMatrix1D[] parts) {
        if (parts.length == 0) {
            return this.make(0);
        }
        int size = 0;
        int i = 0;
        while (i < parts.length) {
            size = (int)((long)size + parts[i].size());
            ++i;
        }
        ObjectMatrix1D vector = this.make(size);
        size = 0;
        int i2 = 0;
        while (i2 < parts.length) {
            vector.viewPart(size, (int)parts[i2].size()).assign(parts[i2]);
            size = (int)((long)size + parts[i2].size());
            ++i2;
        }
        return vector;
    }

    public ObjectMatrix1D make(Object[] values) {
        if (this == sparse) {
            return new SparseObjectMatrix1D(values);
        }
        return new DenseObjectMatrix1D(values);
    }

    public ObjectMatrix1D make(int size) {
        if (this == sparse) {
            return new SparseObjectMatrix1D(size);
        }
        return new DenseObjectMatrix1D(size);
    }

    public ObjectMatrix1D make(int size, Object initialValue) {
        return this.make(size).assign(initialValue);
    }

    public ObjectMatrix1D make(ObjectArrayList values) {
        int size = values.size();
        ObjectMatrix1D vector = this.make(size);
        int i = size;
        while (--i >= 0) {
            vector.set(i, values.get(i));
        }
        return vector;
    }

    public ObjectMatrix1D repeat(ObjectMatrix1D A, int repeat) {
        int size = (int)A.size();
        ObjectMatrix1D matrix = this.make(repeat * size);
        int i = repeat;
        while (--i >= 0) {
            matrix.viewPart(size * i, size).assign(A);
        }
        return matrix;
    }

    public ObjectArrayList toList(ObjectMatrix1D values) {
        int size = (int)values.size();
        ObjectArrayList list = new ObjectArrayList(size);
        list.setSize(size);
        int i = size;
        while (--i >= 0) {
            list.set(i, values.get(i));
        }
        return list;
    }
}

