/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.stat.tfloat.quantile;

import cern.colt.list.tfloat.FloatArrayList;
import cern.colt.list.tobject.ObjectArrayList;
import cern.jet.random.tfloat.engine.FloatRandomEngine;
import cern.jet.random.tfloat.sampling.WeightedFloatRandomSampler;
import cern.jet.stat.Utils;
import cern.jet.stat.tfloat.quantile.FloatBuffer;
import cern.jet.stat.tfloat.quantile.FloatQuantileEstimator;
import java.util.Comparator;

class UnknownFloatQuantileEstimator
extends FloatQuantileEstimator {
    private static final long serialVersionUID = 1L;
    protected int currentTreeHeight;
    protected final int treeHeightStartingSampling;
    protected WeightedFloatRandomSampler sampler;
    protected float precomputeEpsilon;

    public UnknownFloatQuantileEstimator(int b, int k, int h, float precomputeEpsilon, FloatRandomEngine generator) {
        this.sampler = new WeightedFloatRandomSampler(1, generator);
        this.setUp(b, k);
        this.treeHeightStartingSampling = h;
        this.precomputeEpsilon = precomputeEpsilon;
        this.clear();
    }

    @Override
    protected FloatBuffer[] buffersToCollapse() {
        FloatBuffer[] fullBuffers = this.bufferSet._getFullOrPartialBuffers();
        UnknownFloatQuantileEstimator.sortAscendingByLevel(fullBuffers);
        int minLevel = fullBuffers[1].level();
        if (fullBuffers[0].level() < minLevel) {
            fullBuffers[0].level(minLevel);
        }
        return this.bufferSet._getFullOrPartialBuffersWithLevel(minLevel);
    }

    @Override
    public synchronized void clear() {
        super.clear();
        this.currentTreeHeight = 1;
        this.sampler.setWeight(1);
    }

    @Override
    public Object clone() {
        UnknownFloatQuantileEstimator copy = (UnknownFloatQuantileEstimator)super.clone();
        if (this.sampler != null) {
            copy.sampler = (WeightedFloatRandomSampler)copy.sampler.clone();
        }
        return copy;
    }

    @Override
    protected void newBuffer() {
        this.currentBufferToFill = this.bufferSet._getFirstEmptyBuffer();
        if (this.currentBufferToFill == null) {
            throw new RuntimeException("Oops, no empty buffer.");
        }
        this.currentBufferToFill.level(this.currentTreeHeight - 1);
        this.currentBufferToFill.weight(this.sampler.getWeight());
    }

    @Override
    protected void postCollapse(FloatBuffer[] toCollapse) {
        if (toCollapse.length == this.bufferSet.b()) {
            ++this.currentTreeHeight;
            if (this.currentTreeHeight >= this.treeHeightStartingSampling) {
                this.sampler.setWeight(this.sampler.getWeight() * 2);
            }
        }
    }

    @Override
    public FloatArrayList quantileElements(FloatArrayList phis) {
        if ((double)this.precomputeEpsilon <= 0.0) {
            return super.quantileElements(phis);
        }
        int quantilesToPrecompute = (int)Utils.epsilonCeiling(1.0 / (double)this.precomputeEpsilon);
        phis = phis.copy();
        float e = this.precomputeEpsilon;
        int index = phis.size();
        while (--index >= 0) {
            float phi = phis.get(index);
            int i = (int)Math.round((2.0 * (double)phi / (double)e - 1.0) / 2.0);
            i = Math.min(quantilesToPrecompute - 1, Math.max(0, i));
            float augmentedPhi = e / 2.0f * (float)(1 + 2 * i);
            phis.set(index, augmentedPhi);
        }
        return super.quantileElements(phis);
    }

    @Override
    protected boolean sampleNextElement() {
        return this.sampler.sampleNextElement();
    }

    protected static void sortAscendingByLevel(FloatBuffer[] fullBuffers) {
        new ObjectArrayList(fullBuffers).quickSortFromTo(0, fullBuffers.length - 1, new Comparator(){

            public int compare(Object o1, Object o2) {
                int l2;
                int l1 = ((FloatBuffer)o1).level();
                return l1 < (l2 = ((FloatBuffer)o2).level()) ? -1 : (l1 == l2 ? 0 : 1);
            }
        });
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer(super.toString());
        buf.setLength(buf.length() - 1);
        return buf + ", h=" + this.currentTreeHeight + ", hStartSampling=" + this.treeHeightStartingSampling + ", precomputeEpsilon=" + this.precomputeEpsilon + ")";
    }
}

