/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.array.Int1D;
import mitiv.array.Int5D;
import mitiv.array.Int6D;
import mitiv.array.impl.FlatInt1D;
import mitiv.array.impl.FlatInt5D;
import mitiv.array.impl.Helper;
import mitiv.array.impl.SelectedInt6D;
import mitiv.array.impl.StriddenInt5D;
import mitiv.array.impl.StriddenInt6D;
import mitiv.base.Shape;
import mitiv.base.indexing.CompiledRange;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.IntFunction;
import mitiv.base.mapping.IntScanner;
import mitiv.exception.NonConformableArrayException;
import mitiv.random.IntGenerator;

public class FlatInt6D
extends Int6D {
    static final int order = 1;
    final int[] data;
    final int dim1dim2;
    final int dim1dim2dim3;
    final int dim1dim2dim3dim4;
    final int dim1dim2dim3dim4dim5;

    public FlatInt6D(int n, int n2, int n3, int n4, int n5, int n6) {
        super(n, n2, n3, n4, n5, n6);
        this.data = new int[this.number];
        this.dim1dim2 = n * n2;
        this.dim1dim2dim3 = this.dim1dim2 * n3;
        this.dim1dim2dim3dim4 = this.dim1dim2dim3 * n4;
        this.dim1dim2dim3dim4dim5 = this.dim1dim2dim3dim4 * n5;
    }

    public FlatInt6D(int[] nArray) {
        super(nArray);
        this.data = new int[this.number];
        this.dim1dim2 = this.dim1 * this.dim2;
        this.dim1dim2dim3 = this.dim1dim2 * this.dim3;
        this.dim1dim2dim3dim4 = this.dim1dim2dim3 * this.dim4;
        this.dim1dim2dim3dim4dim5 = this.dim1dim2dim3dim4 * this.dim5;
    }

    public FlatInt6D(Shape shape) {
        super(shape);
        this.data = new int[this.number];
        this.dim1dim2 = this.dim1 * this.dim2;
        this.dim1dim2dim3 = this.dim1dim2 * this.dim3;
        this.dim1dim2dim3dim4 = this.dim1dim2dim3 * this.dim4;
        this.dim1dim2dim3dim4dim5 = this.dim1dim2dim3dim4 * this.dim5;
    }

    public FlatInt6D(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        super(n, n2, n3, n4, n5, n6);
        this.checkSize(nArray);
        this.data = nArray;
        this.dim1dim2 = n * n2;
        this.dim1dim2dim3 = this.dim1dim2 * n3;
        this.dim1dim2dim3dim4 = this.dim1dim2dim3 * n4;
        this.dim1dim2dim3dim4dim5 = this.dim1dim2dim3dim4 * n5;
    }

    public FlatInt6D(int[] nArray, int[] nArray2) {
        super(nArray2);
        this.checkSize(nArray);
        this.data = nArray;
        this.dim1dim2 = this.dim1 * this.dim2;
        this.dim1dim2dim3 = this.dim1dim2 * this.dim3;
        this.dim1dim2dim3dim4 = this.dim1dim2dim3 * this.dim4;
        this.dim1dim2dim3dim4dim5 = this.dim1dim2dim3dim4 * this.dim5;
    }

    public FlatInt6D(int[] nArray, Shape shape) {
        super(shape);
        this.checkSize(nArray);
        this.data = nArray;
        this.dim1dim2 = this.dim1 * this.dim2;
        this.dim1dim2dim3 = this.dim1dim2 * this.dim3;
        this.dim1dim2dim3dim4 = this.dim1dim2dim3 * this.dim4;
        this.dim1dim2dim3dim4dim5 = this.dim1dim2dim3dim4 * this.dim5;
    }

    @Override
    public void checkSanity() {
        if (this.data == null) {
            throw new NonConformableArrayException("Wrapped array is null");
        }
        if (this.data.length < this.number) {
            throw new NonConformableArrayException("Wrapped array is too small");
        }
    }

    private void checkSize(int[] nArray) {
        if (nArray == null || nArray.length < this.number) {
            throw new NonConformableArrayException("Wrapped array is too small");
        }
    }

    final int index(int n, int n2, int n3, int n4, int n5, int n6) {
        return this.dim1dim2dim3dim4dim5 * n6 + this.dim1dim2dim3dim4 * n5 + this.dim1dim2dim3 * n4 + this.dim1dim2 * n3 + this.dim1 * n2 + n;
    }

    @Override
    public final int get(int n, int n2, int n3, int n4, int n5, int n6) {
        return this.data[this.dim1dim2dim3dim4dim5 * n6 + this.dim1dim2dim3dim4 * n5 + this.dim1dim2dim3 * n4 + this.dim1dim2 * n3 + this.dim1 * n2 + n];
    }

    @Override
    public final void set(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.data[this.dim1dim2dim3dim4dim5 * n6 + this.dim1dim2dim3dim4 * n5 + this.dim1dim2dim3 * n4 + this.dim1dim2 * n3 + this.dim1 * n2 + n] = n7;
    }

    @Override
    public final int getOrder() {
        return 1;
    }

    @Override
    public void fill(int n) {
        for (int i = 0; i < this.number; ++i) {
            this.data[i] = n;
        }
    }

    @Override
    public void fill(IntGenerator intGenerator) {
        for (int i = 0; i < this.number; ++i) {
            this.data[i] = intGenerator.nextInt();
        }
    }

    @Override
    public void increment(int n) {
        int n2 = 0;
        while (n2 < this.number) {
            int n3 = n2++;
            this.data[n3] = this.data[n3] + n;
        }
    }

    @Override
    public void decrement(int n) {
        int n2 = 0;
        while (n2 < this.number) {
            int n3 = n2++;
            this.data[n3] = this.data[n3] - n;
        }
    }

    @Override
    public void scale(int n) {
        int n2 = 0;
        while (n2 < this.number) {
            int n3 = n2++;
            this.data[n3] = this.data[n3] * n;
        }
    }

    @Override
    public void map(IntFunction intFunction) {
        for (int i = 0; i < this.number; ++i) {
            this.data[i] = intFunction.apply(this.data[i]);
        }
    }

    @Override
    public void scan(IntScanner intScanner) {
        intScanner.initialize(this.data[0]);
        for (int i = 1; i < this.number; ++i) {
            intScanner.update(this.data[i]);
        }
    }

    @Override
    public final boolean isFlat() {
        return true;
    }

    @Override
    public int[] flatten(boolean bl) {
        if (bl) {
            int[] nArray = new int[this.number];
            System.arraycopy(this.data, 0, nArray, 0, this.number);
            return nArray;
        }
        return this.data;
    }

    @Override
    public int[] getData() {
        return this.data;
    }

    @Override
    public Int5D slice(int n) {
        if ((n = Helper.fixIndex(n, this.dim6)) == 0) {
            return new FlatInt5D(this.data, this.dim1, this.dim2, this.dim3, this.dim4, this.dim5);
        }
        return new StriddenInt5D(this.data, this.dim1dim2dim3dim4dim5 * n, 1, this.dim1, this.dim1dim2, this.dim1dim2dim3, this.dim1dim2dim3dim4, this.dim1, this.dim2, this.dim3, this.dim4, this.dim5);
    }

    @Override
    public Int5D slice(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        if ((n2 = Helper.fixSliceIndex(n2, 6)) == 0) {
            n13 = Helper.fixIndex(n, this.dim1);
            n12 = this.dim1;
            n11 = this.dim1dim2;
            n10 = this.dim1dim2dim3;
            n9 = this.dim1dim2dim3dim4;
            n8 = this.dim1dim2dim3dim4dim5;
            n7 = this.dim2;
            n6 = this.dim3;
            n5 = this.dim4;
            n4 = this.dim5;
            n3 = this.dim6;
        } else if (n2 == 1) {
            n13 = this.dim1 * Helper.fixIndex(n, this.dim2);
            n12 = 1;
            n11 = this.dim1dim2;
            n10 = this.dim1dim2dim3;
            n9 = this.dim1dim2dim3dim4;
            n8 = this.dim1dim2dim3dim4dim5;
            n7 = this.dim1;
            n6 = this.dim3;
            n5 = this.dim4;
            n4 = this.dim5;
            n3 = this.dim6;
        } else if (n2 == 2) {
            n13 = this.dim1dim2 * Helper.fixIndex(n, this.dim3);
            n12 = 1;
            n11 = this.dim1;
            n10 = this.dim1dim2dim3;
            n9 = this.dim1dim2dim3dim4;
            n8 = this.dim1dim2dim3dim4dim5;
            n7 = this.dim1;
            n6 = this.dim2;
            n5 = this.dim4;
            n4 = this.dim5;
            n3 = this.dim6;
        } else if (n2 == 3) {
            n13 = this.dim1dim2dim3 * Helper.fixIndex(n, this.dim4);
            n12 = 1;
            n11 = this.dim1;
            n10 = this.dim1dim2;
            n9 = this.dim1dim2dim3dim4;
            n8 = this.dim1dim2dim3dim4dim5;
            n7 = this.dim1;
            n6 = this.dim2;
            n5 = this.dim3;
            n4 = this.dim5;
            n3 = this.dim6;
        } else if (n2 == 4) {
            n13 = this.dim1dim2dim3dim4 * Helper.fixIndex(n, this.dim5);
            n12 = 1;
            n11 = this.dim1;
            n10 = this.dim1dim2;
            n9 = this.dim1dim2dim3;
            n8 = this.dim1dim2dim3dim4dim5;
            n7 = this.dim1;
            n6 = this.dim2;
            n5 = this.dim3;
            n4 = this.dim4;
            n3 = this.dim6;
        } else {
            n13 = this.dim1dim2dim3dim4dim5 * Helper.fixIndex(n, this.dim6);
            n12 = 1;
            n11 = this.dim1;
            n10 = this.dim1dim2;
            n9 = this.dim1dim2dim3;
            n8 = this.dim1dim2dim3dim4;
            n7 = this.dim1;
            n6 = this.dim2;
            n5 = this.dim3;
            n4 = this.dim4;
            n3 = this.dim5;
        }
        return new StriddenInt5D(this.data, n13, n12, n11, n10, n9, n8, n7, n6, n5, n4, n3);
    }

    @Override
    public Int6D view(Range range, Range range2, Range range3, Range range4, Range range5, Range range6) {
        CompiledRange compiledRange = new CompiledRange(range, this.dim1, 0, 1);
        CompiledRange compiledRange2 = new CompiledRange(range2, this.dim2, 0, this.dim1);
        CompiledRange compiledRange3 = new CompiledRange(range3, this.dim3, 0, this.dim1dim2);
        CompiledRange compiledRange4 = new CompiledRange(range4, this.dim4, 0, this.dim1dim2dim3);
        CompiledRange compiledRange5 = new CompiledRange(range5, this.dim5, 0, this.dim1dim2dim3dim4);
        CompiledRange compiledRange6 = new CompiledRange(range6, this.dim6, 0, this.dim1dim2dim3dim4dim5);
        if (compiledRange.doesNothing() && compiledRange2.doesNothing() && compiledRange3.doesNothing() && compiledRange4.doesNothing() && compiledRange5.doesNothing() && compiledRange6.doesNothing()) {
            return this;
        }
        return new StriddenInt6D(this.data, compiledRange.getOffset() + compiledRange2.getOffset() + compiledRange3.getOffset() + compiledRange4.getOffset() + compiledRange5.getOffset() + compiledRange6.getOffset(), compiledRange.getStride(), compiledRange2.getStride(), compiledRange3.getStride(), compiledRange4.getStride(), compiledRange5.getStride(), compiledRange6.getStride(), compiledRange.getNumber(), compiledRange2.getNumber(), compiledRange3.getNumber(), compiledRange4.getNumber(), compiledRange5.getNumber(), compiledRange6.getNumber());
    }

    @Override
    public Int6D view(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5, int[] nArray6) {
        int[] nArray7 = Helper.select(0, 1, this.dim1, nArray);
        int[] nArray8 = Helper.select(0, this.dim1, this.dim2, nArray2);
        int[] nArray9 = Helper.select(0, this.dim1dim2, this.dim3, nArray3);
        int[] nArray10 = Helper.select(0, this.dim1dim2dim3, this.dim4, nArray4);
        int[] nArray11 = Helper.select(0, this.dim1dim2dim3dim4, this.dim5, nArray5);
        int[] nArray12 = Helper.select(0, this.dim1dim2dim3dim4dim5, this.dim6, nArray6);
        return new SelectedInt6D(this.data, nArray7, nArray8, nArray9, nArray10, nArray11, nArray12);
    }

    @Override
    public Int1D as1D() {
        return new FlatInt1D(this.data, this.number);
    }
}

