/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.tool;

import ij.ImagePlus;
import ij.gui.ImageCanvas;
import ij.gui.Overlay;
import ij.gui.Roi;
import ij.plugin.tool.PixelInspector;
import ij.plugin.tool.PlugInTool;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public class PixelInspectionTool
extends PlugInTool {
    PixelInspector pi;

    public void mousePressed(ImagePlus imp, MouseEvent e) {
        this.drawOutline(imp, e);
    }

    public void mouseDragged(ImagePlus imp, MouseEvent e) {
        this.drawOutline(imp, e);
    }

    public void showOptionsDialog() {
        if (this.pi != null) {
            this.pi.showDialog();
        }
    }

    void drawOutline(ImagePlus imp, MouseEvent e) {
        ImageCanvas ic = imp.getCanvas();
        int x = ic.offScreenX(e.getX());
        int y = ic.offScreenY(e.getY());
        int radius = PixelInspector.radius;
        int size = radius * 2 + 1;
        Overlay overlay = imp.getOverlay();
        if (overlay == null) {
            overlay = new Overlay();
        }
        Roi roi = null;
        int index = PixelInspector.getIndex(overlay, "Pixel Inspector");
        if (index >= 0) {
            roi = overlay.get(index);
            Rectangle r = roi.getBounds();
            if (r.width != size || r.height != size) {
                overlay.remove(index);
                roi = null;
            }
            if (roi != null) {
                roi.setLocation(x - radius, y - radius);
            }
        }
        if (roi == null) {
            roi = new Roi(x - radius, y - radius, size, size);
            roi.setName("Pixel Inspector");
            roi.setStrokeColor(Color.red);
            overlay.add(roi);
        }
        imp.setOverlay(overlay);
        if (this.pi == null) {
            if (PixelInspector.instance != null) {
                PixelInspector.instance.close();
            }
            this.pi = new PixelInspector(imp, this);
        }
        this.pi.update(imp, 1, x, y);
    }

    public String getToolName() {
        return "Pixel Inspection Tool";
    }

    public String getToolIcon() {
        return "Cb00T3b09PT8b09xC037L2e0cL0c02L0220L20d0Pd0f2fcde2e0BccP125665210";
    }
}

