/*
 * Decompiled with CFR 0.152.
 */
package mitiv.optim;

import mitiv.base.Traits;
import mitiv.linalg.Vector;
import mitiv.linalg.VectorSpace;
import mitiv.optim.LineSearch;
import mitiv.optim.ReverseCommunicationOptimizerWithLineSearch;

abstract class QuasiNewton
extends ReverseCommunicationOptimizerWithLineSearch {
    public static final double SFTOL = 1.0E-4;
    public static final double SGTOL = 0.9;
    public static final double SXTOL = Traits.DBL_EPSILON;
    protected double epsilon = 0.0;
    protected double delta = 0.001;
    protected double grtol;
    protected double gatol;
    protected double ginit;
    protected double stpmin = 1.0E-20;
    protected double stpmax = 1.0E20;

    public QuasiNewton(VectorSpace vectorSpace, LineSearch lineSearch) {
        super(vectorSpace, lineSearch);
    }

    public double getSufficientDescentThreshold() {
        return this.epsilon;
    }

    public void setSufficientDescentThreshold(double d) {
        if (Double.isNaN(d) || Double.isInfinite(d) || d < 0.0 || d >= 1.0) {
            throw new IllegalArgumentException("Bad value for the sufficient descent threshold");
        }
        this.epsilon = d;
    }

    boolean checkSufficientDescent(double d, double d2, Vector vector) {
        double d3;
        if (this.epsilon > 0.0 && (d3 = this.epsilon * d2 * vector.norm2()) > 0.0) {
            return d <= -d3;
        }
        return d < 0.0;
    }

    boolean checkSufficientDescent(double d, double d2, double d3) {
        double d4;
        if (this.epsilon > 0.0 && (d4 = this.epsilon * d2 * d3) > 0.0) {
            return d <= -d4;
        }
        return d < 0.0;
    }

    public double getRelativeSmallStep() {
        return this.delta;
    }

    public void setRelativeSmallStep(double d) {
        if (Double.isNaN(d) || Double.isInfinite(d) || d <= 0.0 || d >= 1.0) {
            throw new IllegalArgumentException("Bad value for relative small step size");
        }
        this.delta = d;
    }

    public void setAbsoluteTolerance(double d) {
        this.gatol = d;
    }

    public void setRelativeTolerance(double d) {
        this.grtol = d;
    }

    public double getAbsoluteTolerance() {
        return this.gatol;
    }

    public double getRelativeTolerance() {
        return this.grtol;
    }

    public double getGradientThreshold(double d) {
        return QuasiNewton.max(0.0, this.gatol, this.grtol * d);
    }

    private static final double max(double d, double d2, double d3) {
        if (d3 >= d2) {
            return d3 >= d ? d3 : d;
        }
        return d2 >= d ? d2 : d;
    }
}

