/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.List;
import loci.common.DataTools;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataStore;

public class SPEReader
extends FormatReader {
    public static final int FLOAT = 0;
    public static final int INT32 = 1;
    public static final int INT16 = 2;
    public static final int UNINT16 = 3;
    public static final int UNINT32 = 4;
    public static final List<SpeHeaderEntry> coreMetaData = Arrays.asList(SpeHeaderEntry.DATATYPE, SpeHeaderEntry.HEIGHT, SpeHeaderEntry.WIDTH, SpeHeaderEntry.NUM_FRAMES, SpeHeaderEntry.XML_OFFSET, SpeHeaderEntry.HEADER_VER);
    private SpeHeader header;

    public SPEReader() {
        super("Princeton Instruments SPE", "spe");
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 4;
        return FormatTools.validStream(stream, 4, false);
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        if (this.header != null) {
            FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
            long planeSize = FormatTools.getPlaneSize(this);
            long offset = (long)this.header.getHeaderSize() + (long)no * planeSize;
            if (offset + planeSize <= this.in.length() && offset >= 0L) {
                this.in.seek(offset);
                this.readPlane(this.in, x, y, w, h, buf);
            }
        } else {
            throw new FormatException("Header file not found.");
        }
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.header = null;
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        CoreMetadata m = (CoreMetadata)this.core.get(0);
        byte[] h = new byte[4100];
        this.in.read(h, 0, h.length);
        this.header = new SpeHeader(h);
        int speType = this.header.getShort(SpeHeaderEntry.DATATYPE);
        switch (speType) {
            case 0: {
                m.pixelType = 6;
                break;
            }
            case 1: {
                m.pixelType = 4;
                break;
            }
            case 2: {
                m.pixelType = 2;
                break;
            }
            case 3: {
                m.pixelType = 3;
                break;
            }
            case 4: {
                m.pixelType = 5;
                break;
            }
            default: {
                throw new FormatException("Invalid pixel type");
            }
        }
        int numFrames = this.header.getInt(SpeHeaderEntry.NUM_FRAMES);
        if (numFrames < 1 && this.header.getStackSize() >= 1) {
            numFrames = this.header.getStackSize();
        }
        m.sizeX = this.header.getShort(SpeHeaderEntry.WIDTH);
        m.sizeY = this.header.getShort(SpeHeaderEntry.HEIGHT);
        m.sizeZ = 1;
        m.sizeC = 1;
        m.sizeT = numFrames;
        m.imageCount = this.getSizeZ() * this.getSizeT();
        m.rgb = false;
        m.indexed = false;
        m.dimensionOrder = "XYZTC";
        m.interleaved = false;
        m.littleEndian = true;
        this.in.order(this.isLittleEndian());
        int headerVer = this.header.getInt(SpeHeaderEntry.HEADER_VER);
        long xmlOffset = this.header.getLong(SpeHeaderEntry.XML_OFFSET);
        if (headerVer >= 3 || xmlOffset > 0L) {
            LOGGER.debug("Metadata stored in Princeton Instruments SPE Version 3 Footer XML not supported");
            m.metadataComplete = false;
        } else {
            m.metadataComplete = true;
        }
        MetadataStore store = this.makeFilterMetadata();
        this.populateGlobalMetaData();
        MetadataTools.populatePixels(store, this);
        this.populateRoiMetaData(store);
    }

    private void populateGlobalMetaData() throws FormatException, UnsupportedEncodingException {
        block10: for (SpeHeaderEntry headerEntry : SpeHeaderEntry.values()) {
            if (coreMetaData.contains((Object)headerEntry)) continue;
            switch (headerEntry.type) {
                case INT: {
                    int intValue = this.header.getInt(headerEntry);
                    if (intValue <= 0) continue block10;
                    this.addGlobalMeta(headerEntry.name(), intValue);
                    continue block10;
                }
                case SHORT: {
                    int shortValue = this.header.getShort(headerEntry);
                    if (shortValue <= 0) continue block10;
                    this.addGlobalMeta(headerEntry.name(), shortValue);
                    continue block10;
                }
                case LONG: {
                    long longValue = this.header.getLong(headerEntry);
                    if (longValue <= 0L) continue block10;
                    this.addGlobalMeta(headerEntry.name(), longValue);
                    continue block10;
                }
                case BYTE: {
                    int byteValue = this.header.getByte(headerEntry);
                    if (byteValue <= 0) continue block10;
                    this.addGlobalMeta(headerEntry.name(), byteValue);
                    continue block10;
                }
                case STRING: {
                    String stringValue = this.header.getString(headerEntry);
                    if (stringValue == null || stringValue.length() <= 0) continue block10;
                    this.addGlobalMeta(headerEntry.name(), stringValue);
                    continue block10;
                }
                case INTARRAY: {
                    int[] intArrayValue = this.header.getIntArray(headerEntry);
                    if (intArrayValue == null || intArrayValue.length <= 0) continue block10;
                    this.addGlobalMeta(headerEntry.name(), Arrays.toString(intArrayValue));
                    continue block10;
                }
                case LONGARRAY: {
                    long[] longArrayValue = this.header.getLongArray(headerEntry);
                    if (longArrayValue == null || longArrayValue.length <= 0) continue block10;
                    this.addGlobalMeta(headerEntry.name(), Arrays.toString(longArrayValue));
                    continue block10;
                }
                case SHORTARRAY: {
                    int[] shortArrayValue = this.header.getShortArray(headerEntry);
                    if (shortArrayValue == null || shortArrayValue.length <= 0) continue block10;
                    this.addGlobalMeta(headerEntry.name(), Arrays.toString(shortArrayValue));
                    continue block10;
                }
            }
        }
    }

    private void populateRoiMetaData(MetadataStore store) throws FormatException {
        int numROIs = this.header.getShort(SpeHeaderEntry.NUM_ROIS);
        if (numROIs > 0) {
            SpeROI[] rois = this.header.getROIs();
            int roiIndex = 0;
            for (SpeROI roi : rois) {
                String prefix = "ROI " + (roiIndex + 1);
                this.addGlobalMeta(prefix + " Start X", roi.getStartX());
                this.addGlobalMeta(prefix + " End X", roi.getEndX());
                this.addGlobalMeta(prefix + " Group X", roi.getGroupX());
                this.addGlobalMeta(prefix + " Start Y", roi.getStartY());
                this.addGlobalMeta(prefix + " End Y", roi.getEndY());
                this.addGlobalMeta(prefix + " Group Y", roi.getGroupY());
                String roiID = MetadataTools.createLSID("ROI", roiIndex);
                store.setROIID(roiID, roiIndex);
                for (int i = 0; i < this.core.size(); ++i) {
                    store.setImageROIRef(roiID, i, roiIndex);
                }
                store.setLabelID(MetadataTools.createLSID("Shape", roiIndex, 0), roiIndex, 0);
                store.setLabelText(prefix + ", X-Binning = " + roi.getGroupX() + ", Y-Binning = " + roi.getGroupY(), roiIndex, 0);
                store.setLabelX(Double.valueOf(roi.getStartX()), roiIndex, 0);
                store.setLabelY(Double.valueOf(roi.getStartY()), roiIndex, 0);
                store.setRectangleID(MetadataTools.createLSID("Shape", roiIndex, 1), roiIndex, 1);
                store.setRectangleX(Double.valueOf(roi.getStartX()), roiIndex, 1);
                store.setRectangleY(Double.valueOf(roi.getStartY()), roiIndex, 1);
                store.setRectangleWidth((double)roi.getEndX() - (double)roi.getStartX(), roiIndex, 1);
                store.setRectangleHeight((double)roi.getEndY() - (double)roi.getStartY(), roiIndex, 1);
                ++roiIndex;
            }
        }
    }

    private class SpeHeader {
        private static final int headerSize = 4100;
        private byte[] header;

        public SpeHeader(byte[] header) {
            this.header = header;
        }

        public byte[] getHeader() {
            return this.header;
        }

        public void setHeader(byte[] header) {
            this.header = header;
        }

        public int getHeaderSize() {
            return 4100;
        }

        public int getByte(SpeHeaderEntry entry) throws FormatException {
            if (entry.type != SpeHeaderType.BYTE) {
                throw new FormatException("Attempted to read Spe Header Entry " + entry.name() + " as Byte. Expected data type was " + entry.type.name());
            }
            return this.getByte(entry.offset);
        }

        private int getByte(int index) {
            int value = this.header[index];
            if (value < 0) {
                value += 256;
            }
            return value;
        }

        private boolean setByte(int index, int value) {
            if (value >= 0 && value < 128) {
                this.header[index] = (byte)value;
                return true;
            }
            if (value >= 128 && value < 256) {
                this.header[index] = (byte)(value - 256);
                return true;
            }
            return false;
        }

        public int getShort(SpeHeaderEntry entry) throws FormatException {
            if (entry.type != SpeHeaderType.SHORT) {
                throw new FormatException("Attempted to read Spe Header Entry " + entry.name() + " as Short. Expected data type was " + entry.type.name());
            }
            return this.getShort(entry.offset);
        }

        private int getShort(int index) {
            int b1 = this.getByte(index);
            int b2 = this.getByte(index + 1);
            return b2 << 8 | b1;
        }

        private boolean setShort(int index, int value) {
            if (value >= Short.MIN_VALUE && value < 32768) {
                int b1 = value & 0xFF;
                int b2 = value >> 8 & 0xFF;
                this.setByte(index, b1);
                this.setByte(index + 1, b2);
                return true;
            }
            return false;
        }

        public int getInt(SpeHeaderEntry entry) throws FormatException {
            if (entry.type != SpeHeaderType.INT) {
                throw new FormatException("Attempted to read Spe Header Entry " + entry.name() + " as Int. Expected data type was " + entry.type.name());
            }
            return this.getInt(entry.offset);
        }

        private int getInt(int index) {
            return DataTools.bytesToInt(this.header, index, true);
        }

        private void setInt(int index, int value) {
            byte[] intValue = DataTools.intToBytes(value, true);
            for (int i = 0; i < intValue.length; ++i) {
                this.setByte(index + i, intValue[i]);
            }
        }

        public long getLong(SpeHeaderEntry entry) throws FormatException {
            if (entry.type != SpeHeaderType.LONG) {
                throw new FormatException("Attempted to read Spe Header Entry " + entry.name() + " as Long. Expected data type was " + entry.type.name());
            }
            return this.getLong(entry.offset);
        }

        private long getLong(int index) {
            return DataTools.bytesToLong(this.header, index, true);
        }

        private void setLong(int index, int value) {
            byte[] longValue = DataTools.longToBytes(value, true);
            for (int i = 0; i < longValue.length; ++i) {
                this.setByte(index + i, longValue[i]);
            }
        }

        public String getString(SpeHeaderEntry entry) throws FormatException, UnsupportedEncodingException {
            if (entry.type != SpeHeaderType.STRING) {
                throw new FormatException("Attempted to read Spe Header Entry " + entry.name() + " as String. Expected data type was " + entry.type.name());
            }
            SpeHeaderEntry nextEntry = SpeHeaderEntry.values()[entry.ordinal() + 1];
            if (nextEntry == null) {
                throw new FormatException("Could not determind length of String value for " + entry.name());
            }
            int length = nextEntry.offset - entry.offset;
            return this.getString(entry.offset, length);
        }

        private String getString(int index, int length) throws UnsupportedEncodingException {
            byte[] byteValues = new byte[length];
            for (int i = 0; i < length; ++i) {
                byteValues[i] = this.header[index + i];
            }
            String returnString = new String(byteValues, "UTF-8");
            return returnString.trim();
        }

        private void setString(int index, String string) {
            for (int i = 0; i < string.length(); ++i) {
                this.setByte(index + i, string.charAt(i));
            }
        }

        public int[] getIntArray(SpeHeaderEntry entry) throws FormatException {
            if (entry.type != SpeHeaderType.INTARRAY) {
                throw new FormatException("Attempted to read Spe Header Entry " + entry.name() + " as Int Array. Expected data type was " + entry.type.name());
            }
            SpeHeaderEntry nextEntry = SpeHeaderEntry.values()[entry.ordinal() + 1];
            if (nextEntry == null) {
                throw new FormatException("Could not determind length of Int Array for " + entry.name());
            }
            int length = nextEntry.offset - entry.offset;
            int arraySize = length / 4;
            int[] returnArray = new int[arraySize];
            int offset = entry.offset;
            boolean isEmpty = true;
            for (int i = 0; i < arraySize; ++i) {
                int value = this.getInt(offset);
                if (value > 0) {
                    isEmpty = false;
                }
                returnArray[i] = value;
                offset += 4;
            }
            if (isEmpty) {
                returnArray = null;
            }
            return returnArray;
        }

        public int[] getShortArray(SpeHeaderEntry entry) throws FormatException {
            if (entry.type != SpeHeaderType.SHORTARRAY) {
                throw new FormatException("Attempted to read Spe Header Entry " + entry.name() + " as Short Array. Expected data type was " + entry.type.name());
            }
            SpeHeaderEntry nextEntry = SpeHeaderEntry.values()[entry.ordinal() + 1];
            if (nextEntry == null) {
                throw new FormatException("Could not determind length of Short Array for " + entry.name());
            }
            int length = nextEntry.offset - entry.offset;
            int arraySize = length / 2;
            int[] returnArray = new int[arraySize];
            int offset = entry.offset;
            boolean isEmpty = true;
            for (int i = 0; i < arraySize; ++i) {
                int value = this.getShort(offset);
                if (value > 0) {
                    isEmpty = false;
                }
                returnArray[i] = value;
                offset += 2;
            }
            if (isEmpty) {
                returnArray = null;
            }
            return returnArray;
        }

        public long[] getLongArray(SpeHeaderEntry entry) throws FormatException {
            if (entry.type != SpeHeaderType.LONGARRAY) {
                throw new FormatException("Attempted to read Spe Header Entry " + entry.name() + " as Long Array. Expected data type was " + entry.type.name());
            }
            SpeHeaderEntry nextEntry = SpeHeaderEntry.values()[entry.ordinal() + 1];
            if (nextEntry == null) {
                throw new FormatException("Could not determind length of Long Array for " + entry.name());
            }
            int length = nextEntry.offset - entry.offset;
            int arraySize = length / 8;
            long[] returnArray = new long[arraySize];
            int offset = entry.offset;
            boolean isEmpty = true;
            for (int i = 0; i < arraySize; ++i) {
                long value = this.getLong(offset);
                if (value > 0L) {
                    isEmpty = false;
                }
                returnArray[i] = value;
                offset += 8;
            }
            if (isEmpty) {
                returnArray = null;
            }
            return returnArray;
        }

        public SpeROI[] getROIs() throws FormatException {
            SpeROI[] roiArray = null;
            int numROIs = this.getShort(SpeHeaderEntry.NUM_ROIS);
            if (numROIs > 0) {
                roiArray = new SpeROI[numROIs];
                int offset = SpeHeaderEntry.ROI_BEGIN.offset;
                for (int i = 0; i < numROIs; ++i) {
                    int startX = this.getShort(offset);
                    int endX = this.getShort(offset + 2);
                    int groupX = this.getShort(offset + 4);
                    int startY = this.getShort(offset + 6);
                    int endY = this.getShort(offset + 8);
                    int groupY = this.getShort(offset + 10);
                    roiArray[i] = new SpeROI(startX, endX, groupX, startY, endY, groupY);
                    offset += 12;
                }
            }
            return roiArray;
        }

        public int getStackSize() throws FormatException {
            int stripe = this.getShort(SpeHeaderEntry.HEIGHT);
            int noscan = this.getShort(SpeHeaderEntry.NOSCAN);
            int numFrames = this.getInt(SpeHeaderEntry.NUM_FRAMES);
            if (stripe == 0 || noscan == 0) {
                return numFrames;
            }
            if (noscan == 65535) {
                int lnoscan = this.getInt(SpeHeaderEntry.LNOSCAN);
                if (lnoscan == -1 || lnoscan == 0) {
                    return numFrames;
                }
                return lnoscan / stripe;
            }
            return noscan / stripe;
        }
    }

    private class SpeROI {
        private int startX;
        private int endX;
        private int groupX;
        private int startY;
        private int endY;
        private int groupY;

        public SpeROI(int xStart, int xEnd, int xGroup, int yStart, int yEnd, int yGroup) {
            this.startX = xStart;
            this.endX = xEnd;
            this.groupX = xGroup;
            this.startY = yStart;
            this.endY = yEnd;
            this.groupY = yGroup;
        }

        public int getStartX() {
            return this.startX;
        }

        public int getEndX() {
            return this.endX;
        }

        public int getGroupX() {
            return this.groupX;
        }

        public int getStartY() {
            return this.startY;
        }

        public int getEndY() {
            return this.endY;
        }

        public int getGroupY() {
            return this.groupY;
        }
    }

    private static enum SpeHeaderEntry {
        CONTROLLER_VER(0, SpeHeaderType.SHORT),
        LOGIC_OUTPUT(2, SpeHeaderType.SHORT),
        AMP_MODE(4, SpeHeaderType.SHORT),
        X_DIMENSION(6, SpeHeaderType.SHORT),
        MODE(8, SpeHeaderType.SHORT),
        EXPOSURE(10, SpeHeaderType.INT),
        VIRTUAL_XDIM(14, SpeHeaderType.SHORT),
        VIRTUAL_YDIM(16, SpeHeaderType.SHORT),
        Y_DIMENSION(18, SpeHeaderType.SHORT),
        DATE(20, SpeHeaderType.BYTE),
        VIRTUAL_CHIP(30, SpeHeaderType.SHORT),
        NOSCAN(34, SpeHeaderType.SHORT),
        DETECTOR_TEMP(36, SpeHeaderType.INT),
        DETECTOR_TYPE(40, SpeHeaderType.SHORT),
        WIDTH(42, SpeHeaderType.SHORT),
        TRIGGER_DIODE(44, SpeHeaderType.SHORT),
        DELAY_TIME(46, SpeHeaderType.INT),
        SHUTTER_CTRL(50, SpeHeaderType.SHORT),
        ABSORB_LIVE(52, SpeHeaderType.SHORT),
        ABSORB_MODE(54, SpeHeaderType.SHORT),
        CAN_VRTL_CHIP(56, SpeHeaderType.SHORT),
        THRESHOLD_MIN_LIVE(58, SpeHeaderType.SHORT),
        THRESHOLD_MIN_VAL(60, SpeHeaderType.INT),
        THRESHOLD_MAX_LIVE(64, SpeHeaderType.SHORT),
        THRESHOLD_MAX_VAL(66, SpeHeaderType.INT),
        AUTO_SPECTRO(70, SpeHeaderType.SHORT),
        SPEC_CENTER_WAVELEN(72, SpeHeaderType.INT),
        SPEC_GLUE_FLAG(76, SpeHeaderType.SHORT),
        SPEC_GLUE_START(78, SpeHeaderType.INT),
        SPEC_GLUE_END(82, SpeHeaderType.INT),
        SPEC_GLUE_MIN_OVRLP(86, SpeHeaderType.INT),
        SPEC_GLUE_FINAL_RES(90, SpeHeaderType.INT),
        PULSAR_TYPE(94, SpeHeaderType.SHORT),
        CHIP_FLAG(96, SpeHeaderType.SHORT),
        X_PRE_PIXELS(98, SpeHeaderType.SHORT),
        X_POST_PIXELS(100, SpeHeaderType.SHORT),
        Y_PRE_PIXELS(102, SpeHeaderType.SHORT),
        Y_POST_PIXELS(104, SpeHeaderType.SHORT),
        ASYNCH(106, SpeHeaderType.SHORT),
        DATATYPE(108, SpeHeaderType.SHORT),
        PULSER_MODE(110, SpeHeaderType.SHORT),
        PULSER_CHIP_ACCUMS(112, SpeHeaderType.SHORT),
        PULSE_REP_EXP(114, SpeHeaderType.INT),
        PULSE_REP_WIDTH(118, SpeHeaderType.INT),
        PULSE_REP_DELAY(122, SpeHeaderType.INT),
        PULSE_START_WIDTH(126, SpeHeaderType.INT),
        PULSE_END_WIDTH(130, SpeHeaderType.INT),
        PULSE_START_DELAY(134, SpeHeaderType.INT),
        PULSE_END_DELAY(138, SpeHeaderType.INT),
        PULSE_INC_MODE(142, SpeHeaderType.SHORT),
        PI_MAX_USED(144, SpeHeaderType.SHORT),
        PI_MAX_MODE(146, SpeHeaderType.SHORT),
        PI_MAX_GAIN(148, SpeHeaderType.SHORT),
        BCKGRND_SUB(150, SpeHeaderType.SHORT),
        PI_MAX_2NS_BRD(152, SpeHeaderType.SHORT),
        MIN_BLK(154, SpeHeaderType.SHORT),
        NUM_IN_BLK(156, SpeHeaderType.SHORT),
        SPEC_MIRR_LOC(158, SpeHeaderType.SHORTARRAY),
        SPEC_SLIT_LOC(162, SpeHeaderType.SHORTARRAY),
        CUS_TIMING_FLAG(170, SpeHeaderType.SHORT),
        EXP_TIME_LOCAL(172, SpeHeaderType.STRING),
        EXP_TIME_UTC(179, SpeHeaderType.STRING),
        EXPOSURE_UNITS(186, SpeHeaderType.SHORT),
        ADC_OFFSET(188, SpeHeaderType.SHORT),
        ADC_RATE(190, SpeHeaderType.SHORT),
        ADC_TYPE(192, SpeHeaderType.SHORT),
        ADC_RESOLUTION(194, SpeHeaderType.SHORT),
        ADC_BIT_ADJUST(196, SpeHeaderType.SHORT),
        GAIN(198, SpeHeaderType.SHORT),
        COMMENTS(200, SpeHeaderType.STRING),
        GEOMETRIC(600, SpeHeaderType.SHORT),
        X_LABEL(602, SpeHeaderType.STRING),
        CLEANS(618, SpeHeaderType.SHORT),
        LFLOAT(620, SpeHeaderType.SHORT),
        SPEC_MIRROR_POS(622, SpeHeaderType.SHORTARRAY),
        SPEC_SLIT_POS(626, SpeHeaderType.INTARRAY),
        AUTO_CLEAN(642, SpeHeaderType.SHORT),
        CONT_CLEAN(644, SpeHeaderType.SHORT),
        ABSORB_STRIP_NUM(646, SpeHeaderType.SHORT),
        SPEC_SLIT_POS_UNITS(648, SpeHeaderType.SHORT),
        SPEC_GROOVES(650, SpeHeaderType.INT),
        SOURCE_COMP(654, SpeHeaderType.SHORT),
        HEIGHT(656, SpeHeaderType.SHORT),
        SCRAMBLE(658, SpeHeaderType.SHORT),
        LEXPOS(660, SpeHeaderType.SHORT),
        EXT_TRIGGER(662, SpeHeaderType.SHORT),
        LNOSCAN(664, SpeHeaderType.INT),
        ACCUMULATIONS(668, SpeHeaderType.INT),
        READOUT_TIME(672, SpeHeaderType.INT),
        TRIGGER_MODE(676, SpeHeaderType.SHORT),
        XML_OFFSET(678, SpeHeaderType.LONG),
        VERSION(688, SpeHeaderType.STRING),
        TYPE(704, SpeHeaderType.SHORT),
        FLAT_FIELD(706, SpeHeaderType.SHORT),
        KINETIC_TRIGGER(724, SpeHeaderType.SHORT),
        DATA_LABEL(726, SpeHeaderType.STRING),
        SPARE4(742, SpeHeaderType.STRING),
        PULSE_FILENAME(1178, SpeHeaderType.STRING),
        ABSORB_FILENAME(1298, SpeHeaderType.STRING),
        EXP_REPEATS(1418, SpeHeaderType.INT),
        EXP_ACCUMS(1422, SpeHeaderType.INT),
        YT_FLAG(1426, SpeHeaderType.SHORT),
        VERT_CLOCK_SPEED(1428, SpeHeaderType.INT),
        HW_ACCUM(1432, SpeHeaderType.SHORT),
        STORE_SYNC(1434, SpeHeaderType.SHORT),
        BLEMISH_APPLIED(1436, SpeHeaderType.SHORT),
        COSMIC_APPLIED(1438, SpeHeaderType.SHORT),
        COSMIC_TYPE(1440, SpeHeaderType.SHORT),
        COSMIC_THRESHOLD(1442, SpeHeaderType.INT),
        NUM_FRAMES(1446, SpeHeaderType.INT),
        MAX_INTENSITY(1450, SpeHeaderType.INT),
        MIN_INTENSITY(1454, SpeHeaderType.INT),
        Y_LABEL(1458, SpeHeaderType.STRING),
        SHUTTER_TYPE(1474, SpeHeaderType.SHORT),
        SHUTTER_COMP(1476, SpeHeaderType.INT),
        READOUT_MODE(1480, SpeHeaderType.SHORT),
        WINDOW_SIZE(1482, SpeHeaderType.SHORT),
        CLOCK_SPEED(1484, SpeHeaderType.SHORT),
        INTERFACE_TYPE(1486, SpeHeaderType.SHORT),
        NUM_EXP_ROIS(1488, SpeHeaderType.SHORT),
        CONTROLLER_NUM(1506, SpeHeaderType.SHORT),
        SOFTWARE(1508, SpeHeaderType.SHORT),
        NUM_ROIS(1510, SpeHeaderType.SHORT),
        ROI_BEGIN(1512, SpeHeaderType.ROIARRAY),
        FLAT_FIELD_FILE(1632, SpeHeaderType.STRING),
        BACKGROUND_FILE(1752, SpeHeaderType.STRING),
        BLEMISH_FILE(1872, SpeHeaderType.STRING),
        HEADER_VER(1992, SpeHeaderType.INT),
        YT_INFO(1996, SpeHeaderType.STRING),
        WINVIEW_ID(2996, SpeHeaderType.INT),
        X_SCALING_OFFSET(3000, SpeHeaderType.LONG),
        X_SCALING_FACTOR(3008, SpeHeaderType.LONG),
        X_SCALING_UNIT(3016, SpeHeaderType.BYTE),
        X_RESERVED(3017, SpeHeaderType.BYTE),
        X_SPECIAL_STRING(3018, SpeHeaderType.STRING),
        X_RESERVED2(3058, SpeHeaderType.STRING),
        X_CALIB_VALID(3098, SpeHeaderType.BYTE),
        X_INPUT_UNIT(3099, SpeHeaderType.BYTE),
        X_POLYNUM_UNIT(3100, SpeHeaderType.BYTE),
        X_POLYNUM_ORDER(3101, SpeHeaderType.BYTE),
        X_CALIB_COUNT(3102, SpeHeaderType.BYTE),
        X_PIXEL_POSITION(3103, SpeHeaderType.BYTE),
        X_CALIB_VALUE(3183, SpeHeaderType.LONGARRAY),
        X_POLYNUM_COEFF(3263, SpeHeaderType.LONGARRAY),
        X_LASER_POS(3311, SpeHeaderType.LONGARRAY),
        X_RESERVED3(3319, SpeHeaderType.LONG),
        X_CALIB_FLAG(3320, SpeHeaderType.BYTE),
        X_CALIB_LABEL(3321, SpeHeaderType.STRING),
        X_EXPANSION(3402, SpeHeaderType.STRING),
        Y_SCALING_OFFSET(3489, SpeHeaderType.LONG),
        Y_SCALING_FACTOR(3497, SpeHeaderType.LONG),
        Y_SCALING_UNIT(3505, SpeHeaderType.BYTE),
        Y_RESERVED(3506, SpeHeaderType.STRING),
        Y_SPECIAL_STRING(3507, SpeHeaderType.STRING),
        Y_RESERVED2(3547, SpeHeaderType.BYTE),
        Y_CALIB_VALID(3587, SpeHeaderType.BYTE),
        Y_INPUT_UNIT(3588, SpeHeaderType.BYTE),
        Y_POLYNUM_UNIT(3589, SpeHeaderType.BYTE),
        Y_POLYNUM_ORDER(3590, SpeHeaderType.BYTE),
        Y_CALIB_COUNT(3591, SpeHeaderType.BYTE),
        Y_PIXEL_POSITION(3592, SpeHeaderType.BYTE),
        Y_CALIB_VALUE(3672, SpeHeaderType.LONGARRAY),
        Y_POLYNUM_COEFF(3752, SpeHeaderType.LONGARRAY),
        Y_LASER_POS(3800, SpeHeaderType.LONGARRAY),
        Y_RESERVED3(3808, SpeHeaderType.LONG),
        Y_CALIB_FLAG(3809, SpeHeaderType.BYTE),
        Y_CALIB_LABEL(3810, SpeHeaderType.STRING),
        Y_EXPANSION(3891, SpeHeaderType.STRING),
        INTENSITY_STRING(3978, SpeHeaderType.STRING),
        SPARE6(4018, SpeHeaderType.STRING),
        SPEC_TYPE(4043, SpeHeaderType.BYTE),
        SPEC_MODEL(4044, SpeHeaderType.BYTE),
        PULSE_BURST_USED(4045, SpeHeaderType.BYTE),
        PULSE_BURST_COUNT(4046, SpeHeaderType.INT),
        PULSE_BURST_PERIOD(4050, SpeHeaderType.LONG),
        PULSE_BRACKET_USED(4058, SpeHeaderType.BYTE),
        PULSE_BRACKET_TYPE(4059, SpeHeaderType.BYTE),
        PULSE_TIMECONST_FAST(4060, SpeHeaderType.LONG),
        PULSE_AMP_FAST(4068, SpeHeaderType.LONG),
        PULSE_TIMECONST_SLOW(4076, SpeHeaderType.LONG),
        PULSE_AMP_SLOW(4084, SpeHeaderType.LONG),
        ANALOG_GAIN(4092, SpeHeaderType.SHORT),
        AV_GAIN_USED(4094, SpeHeaderType.SHORT),
        AV_GAIN(4096, SpeHeaderType.SHORT),
        LAST_VALUE(4098, SpeHeaderType.SHORT);

        private final int offset;
        private final SpeHeaderType type;

        private SpeHeaderEntry(int entryOffset, SpeHeaderType entryType) {
            this.offset = entryOffset;
            this.type = entryType;
        }
    }

    private static enum SpeHeaderType {
        FLOAT,
        LONG,
        INT,
        SHORT,
        BYTE,
        STRING,
        LONGARRAY,
        INTARRAY,
        SHORTARRAY,
        ROIARRAY;

    }
}

