/*
 * Decompiled with CFR 0.152.
 */
package mitiv.base.indexing;

public enum BoundaryConditions {
    NORMAL(0, "propagate leftmost or rightmost value"),
    PERIODIC(1, "periodic boundary conditions"),
    MIRROR(2, "mirror boundary conditions");

    private final int identifier;
    private final String description;

    private BoundaryConditions(int n2, String string2) {
        this.identifier = n2;
        this.description = string2;
    }

    public int getIdentifier() {
        return this.identifier;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.description;
    }

    public static final void buildIndex(int[] nArray, int n, BoundaryConditions boundaryConditions) {
        int n2 = nArray.length;
        if (boundaryConditions == PERIODIC) {
            for (int i = 0; i < n2; ++i) {
                int n3 = i + n;
                if (n3 < 0) {
                    n3 = n2 + n3 % n2;
                }
                if (n3 >= n2) {
                    n3 %= n2;
                }
                nArray[i] = n3;
            }
        } else if (boundaryConditions == MIRROR) {
            int n4 = 2 * n2;
            int n5 = n4 - 1;
            for (int i = 0; i < n2; ++i) {
                int n6 = i + n;
                if (n6 < 0) {
                    n6 = -n6;
                }
                if (n6 >= n4) {
                    n6 %= n4;
                }
                if (n6 >= n2) {
                    n6 = n5 - n6;
                }
                nArray[i] = n6;
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                int n7 = i + n;
                if (n7 < 0) {
                    n7 = 0;
                }
                if (n7 >= n2) {
                    n7 = n2 - 1;
                }
                nArray[i] = n7;
            }
        }
    }

    public static final int[] buildIndex(int n, int n2, BoundaryConditions boundaryConditions) {
        int[] nArray = new int[n];
        BoundaryConditions.buildIndex(nArray, n2, boundaryConditions);
        return nArray;
    }

    public static String stringify(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(i == 0 ? "{" : ", ");
            stringBuffer.append(byArray[i]);
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public static String stringify(short[] sArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < sArray.length; ++i) {
            stringBuffer.append(i == 0 ? "{" : ", ");
            stringBuffer.append(sArray[i]);
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public static String stringify(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            stringBuffer.append(i == 0 ? "{" : ", ");
            stringBuffer.append(nArray[i]);
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public static String stringify(long[] lArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < lArray.length; ++i) {
            stringBuffer.append(i == 0 ? "{" : ", ");
            stringBuffer.append(lArray[i]);
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public static String stringify(float[] fArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < fArray.length; ++i) {
            stringBuffer.append(i == 0 ? "{" : ", ");
            stringBuffer.append(fArray[i]);
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public static String stringify(double[] dArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < dArray.length; ++i) {
            stringBuffer.append(i == 0 ? "{" : ", ");
            stringBuffer.append(dArray[i]);
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        int n = 10;
        int[] nArray = BoundaryConditions.buildIndex(n, -1, NORMAL);
        int[] nArray2 = BoundaryConditions.buildIndex(n, -1, PERIODIC);
        int[] nArray3 = BoundaryConditions.buildIndex(n, -1, MIRROR);
        System.out.println("i1 = " + BoundaryConditions.stringify(nArray));
        System.out.println("i2 = " + BoundaryConditions.stringify(nArray2));
        System.out.println("i3 = " + BoundaryConditions.stringify(nArray3));
        System.out.println("i4 = " + BoundaryConditions.stringify(BoundaryConditions.buildIndex(n, -3, MIRROR)));
        System.out.println("i5 = " + BoundaryConditions.stringify(BoundaryConditions.buildIndex(n, -12, PERIODIC)));
        System.out.println("buildIndex(7, -1, NORMAL) -----> " + BoundaryConditions.stringify(BoundaryConditions.buildIndex(7, -1, NORMAL)));
        System.out.println("buildIndex(7, -2, PERIODIC) ---> " + BoundaryConditions.stringify(BoundaryConditions.buildIndex(7, -2, PERIODIC)));
        System.out.println("buildIndex(7, -2, MIRROR) -----> " + BoundaryConditions.stringify(BoundaryConditions.buildIndex(7, -2, MIRROR)));
    }
}

