/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.event;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;

public class WeakEventListenerList
implements Serializable {
    protected transient List<WeakReference<? extends EventListener>> weakReferences;
    protected transient List<Class<? extends EventListener>> classes;

    public Object[] getListenerList() {
        List listeners = this.cleanReferences();
        Object[] result = new Object[listeners.size() * 2];
        for (int i = 0; i < listeners.size(); ++i) {
            result[2 * i + 1] = listeners.get(i);
            result[2 * i] = this.getClasses().get(i);
        }
        return result;
    }

    private synchronized <T extends EventListener> List<T> cleanReferences() {
        ArrayList<EventListener> listeners = new ArrayList<EventListener>();
        for (int i = this.getReferences().size() - 1; i >= 0; --i) {
            Object listener = this.getReferences().get(i).get();
            if (listener == null) {
                this.getReferences().remove(i);
                this.getClasses().remove(i);
                continue;
            }
            listeners.add(0, (EventListener)listener);
        }
        return listeners;
    }

    private List<WeakReference<? extends EventListener>> getReferences() {
        if (this.weakReferences == null) {
            this.weakReferences = new ArrayList<WeakReference<? extends EventListener>>();
        }
        return this.weakReferences;
    }

    private List<Class<? extends EventListener>> getClasses() {
        if (this.classes == null) {
            this.classes = new ArrayList<Class<? extends EventListener>>();
        }
        return this.classes;
    }

    public <T extends EventListener> T[] getListeners(Class<T> t) {
        List<T> liveListeners = this.cleanReferences();
        ArrayList<T> listeners = new ArrayList<T>();
        for (int i = 0; i < liveListeners.size(); ++i) {
            if (this.getClasses().get(i) != t) continue;
            listeners.add(liveListeners.get(i));
        }
        EventListener[] result = (EventListener[])Array.newInstance(t, listeners.size());
        return listeners.toArray(result);
    }

    public synchronized <T extends EventListener> void add(Class<T> t, T l) {
        if (l == null) {
            return;
        }
        if (!t.isInstance(l)) {
            throw new IllegalArgumentException("Listener " + l + " is not of type " + t);
        }
        this.cleanReferences();
        this.getReferences().add(new WeakReference<T>(l));
        this.getClasses().add(t);
    }

    public synchronized <T extends EventListener> void remove(Class<T> t, T l) {
        if (l == null) {
            return;
        }
        if (!t.isInstance(l)) {
            throw new IllegalArgumentException("Listener " + l + " is not of type " + t);
        }
        for (int i = 0; i < this.getReferences().size(); ++i) {
            if (!l.equals(this.getReferences().get(i).get()) || t != this.getClasses().get(i)) continue;
            this.getReferences().remove(i);
            this.getClasses().remove(i);
            break;
        }
    }
}

