/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.fysat.util;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class EndianByteBuffer {
    public static short LITTLE_ENDIAN = 0;
    public static short BIG_ENDIAN = (short)-1;
    private short awxEndian = LITTLE_ENDIAN;
    private ByteBuffer byteBuffer;

    public EndianByteBuffer(byte[] byteArray, short endian) {
        this.awxEndian = endian == 0 ? LITTLE_ENDIAN : BIG_ENDIAN;
        this.byteBuffer = ByteBuffer.allocate(byteArray.length);
        this.byteBuffer.put(byteArray);
        this.byteBuffer.position(0);
    }

    public EndianByteBuffer(byte[] byteArray) {
        this(byteArray, LITTLE_ENDIAN);
    }

    public void setEndian(short endian) {
        this.awxEndian = endian == 0 ? LITTLE_ENDIAN : BIG_ENDIAN;
    }

    public int getInt() {
        int v = this.awxEndian == LITTLE_ENDIAN ? this.byteBuffer.order(ByteOrder.LITTLE_ENDIAN).getInt() : this.byteBuffer.getInt();
        return v;
    }

    public short getShort() {
        short v = this.awxEndian == LITTLE_ENDIAN ? this.byteBuffer.order(ByteOrder.LITTLE_ENDIAN).getShort() : this.byteBuffer.getShort();
        return v;
    }

    public long getLong() {
        long v = this.awxEndian == LITTLE_ENDIAN ? this.byteBuffer.order(ByteOrder.LITTLE_ENDIAN).getLong() : this.byteBuffer.getLong();
        return v;
    }

    public float getFloat() {
        float v = this.awxEndian == LITTLE_ENDIAN ? this.byteBuffer.order(ByteOrder.LITTLE_ENDIAN).getFloat() : this.byteBuffer.getFloat();
        return v;
    }

    public double getDouble() {
        double v = this.awxEndian == LITTLE_ENDIAN ? this.byteBuffer.order(ByteOrder.LITTLE_ENDIAN).getDouble() : this.byteBuffer.getDouble();
        return v;
    }

    public String getString(int byteCount) {
        byte[] buf = new byte[byteCount];
        this.byteBuffer.get(buf);
        String v = null;
        try {
            v = new String(buf, "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return v;
    }

    public short[] getShortArray() {
        int count = (this.byteBuffer.array().length - this.byteBuffer.position()) / 2;
        short[] va = new short[count];
        if (this.awxEndian == LITTLE_ENDIAN) {
            for (int i = 0; i < count; ++i) {
                va[i] = this.byteBuffer.order(ByteOrder.LITTLE_ENDIAN).getShort();
            }
        } else {
            for (int i = 0; i < count; ++i) {
                va[i] = this.byteBuffer.getShort();
            }
        }
        return va;
    }

    public long[] getLongArray() {
        int count = (this.byteBuffer.array().length - this.byteBuffer.position()) / 8;
        long[] va = new long[count];
        if (this.awxEndian == LITTLE_ENDIAN) {
            for (int i = 0; i < count; ++i) {
                va[i] = this.byteBuffer.order(ByteOrder.LITTLE_ENDIAN).getLong();
            }
        } else {
            for (int i = 0; i < count; ++i) {
                va[i] = this.byteBuffer.getLong();
            }
        }
        return va;
    }

    public int[] getIntArray() {
        int count = (this.byteBuffer.array().length - this.byteBuffer.position()) / 4;
        int[] va = new int[count];
        if (this.awxEndian == LITTLE_ENDIAN) {
            for (int i = 0; i < count; ++i) {
                va[i] = this.byteBuffer.order(ByteOrder.LITTLE_ENDIAN).getInt();
            }
        } else {
            for (int i = 0; i < count; ++i) {
                va[i] = this.byteBuffer.getInt();
            }
        }
        return va;
    }

    public final void position(int newPosition) {
        this.byteBuffer.position(newPosition);
    }
}

