/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.array.Byte1D;
import mitiv.array.ByteScalar;
import mitiv.array.impl.Helper;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.ByteFunction;
import mitiv.base.mapping.ByteScanner;
import mitiv.random.ByteGenerator;

public class SelectedByte1D
extends Byte1D {
    static final int order = 0;
    final byte[] data;
    final int[] idx1;

    public SelectedByte1D(byte[] byArray, int[] nArray) {
        super(nArray.length);
        this.data = byArray;
        this.idx1 = nArray;
    }

    @Override
    public final void checkSanity() {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = n = this.idx1[0];
        for (int i = 1; i < this.dim1; ++i) {
            int n5 = this.idx1[i];
            if (n5 < n4) {
                n4 = n5;
            }
            if (n5 <= n) continue;
            n = n5;
        }
        if ((n2 += n4) < 0 || (n3 += n) >= this.data.length) {
            throw new IndexOutOfBoundsException("Selected indices are out of bounds");
        }
    }

    final int index(int n) {
        return this.idx1[n];
    }

    @Override
    public final byte get(int n) {
        return this.data[this.idx1[n]];
    }

    @Override
    public final void set(int n, byte by) {
        this.data[this.idx1[n]] = by;
    }

    @Override
    public final int getOrder() {
        return 0;
    }

    @Override
    public void fill(byte by) {
        for (int i = 0; i < this.dim1; ++i) {
            int n = this.idx1[i];
            this.data[n] = by;
        }
    }

    @Override
    public void fill(ByteGenerator byteGenerator) {
        for (int i = 0; i < this.dim1; ++i) {
            int n = this.idx1[i];
            this.data[n] = byteGenerator.nextByte();
        }
    }

    @Override
    public void increment(byte by) {
        for (int i = 0; i < this.dim1; ++i) {
            int n;
            int n2 = n = this.idx1[i];
            this.data[n2] = (byte)(this.data[n2] + by);
        }
    }

    @Override
    public void decrement(byte by) {
        for (int i = 0; i < this.dim1; ++i) {
            int n;
            int n2 = n = this.idx1[i];
            this.data[n2] = (byte)(this.data[n2] - by);
        }
    }

    @Override
    public void scale(byte by) {
        for (int i = 0; i < this.dim1; ++i) {
            int n;
            int n2 = n = this.idx1[i];
            this.data[n2] = (byte)(this.data[n2] * by);
        }
    }

    @Override
    public void map(ByteFunction byteFunction) {
        for (int i = 0; i < this.dim1; ++i) {
            int n = this.idx1[i];
            this.data[n] = byteFunction.apply(this.data[n]);
        }
    }

    @Override
    public void scan(ByteScanner byteScanner) {
        boolean bl = false;
        for (int i = 0; i < this.dim1; ++i) {
            int n = this.idx1[i];
            if (bl) {
                byteScanner.update(this.data[n]);
                continue;
            }
            byteScanner.initialize(this.data[n]);
            bl = true;
        }
    }

    @Override
    public final boolean isFlat() {
        return false;
    }

    @Override
    public byte[] flatten(boolean bl) {
        byte[] byArray = new byte[this.number];
        int n = -1;
        for (int i = 0; i < this.dim1; ++i) {
            int n2 = this.idx1[i];
            byArray[++n] = this.data[n2];
        }
        return byArray;
    }

    @Override
    public byte[] getData() {
        return null;
    }

    @Override
    public ByteScalar slice(int n) {
        return new ByteScalar(this.data, this.idx1[Helper.fixIndex(n, this.dim1)]);
    }

    @Override
    public ByteScalar slice(int n, int n2) {
        Helper.fixSliceIndex(n2, 1);
        return new ByteScalar(this.data, Helper.fixIndex(n, this.dim1));
    }

    @Override
    public Byte1D view(Range range) {
        int[] nArray = Helper.select(this.idx1, range);
        if (nArray == this.idx1) {
            return this;
        }
        return new SelectedByte1D(this.data, nArray);
    }

    @Override
    public Byte1D view(int[] nArray) {
        int[] nArray2 = Helper.select(this.idx1, nArray);
        if (nArray2 == this.idx1) {
            return this;
        }
        return new SelectedByte1D(this.data, nArray2);
    }

    @Override
    public Byte1D as1D() {
        return this;
    }
}

