/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.array.Int1D;
import mitiv.array.Int8D;
import mitiv.array.Int9D;
import mitiv.array.impl.FlatInt1D;
import mitiv.array.impl.Helper;
import mitiv.array.impl.SelectedInt9D;
import mitiv.array.impl.StriddenInt8D;
import mitiv.base.indexing.CompiledRange;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.IntFunction;
import mitiv.base.mapping.IntScanner;
import mitiv.random.IntGenerator;

public class StriddenInt9D
extends Int9D {
    final int order;
    final int[] data;
    final int offset;
    final int stride1;
    final int stride2;
    final int stride3;
    final int stride4;
    final int stride5;
    final int stride6;
    final int stride7;
    final int stride8;
    final int stride9;
    final boolean flat;

    public StriddenInt9D(int[] nArray, int n, int[] nArray2, int[] nArray3) {
        super(nArray3);
        if (nArray2.length != 9) {
            throw new IllegalArgumentException("There must be as many strides as the rank");
        }
        this.data = nArray;
        this.offset = n;
        this.stride1 = nArray2[0];
        this.stride2 = nArray2[1];
        this.stride3 = nArray2[2];
        this.stride4 = nArray2[3];
        this.stride5 = nArray2[4];
        this.stride6 = nArray2[5];
        this.stride7 = nArray2[6];
        this.stride8 = nArray2[7];
        this.stride9 = nArray2[8];
        this.order = Int9D.checkViewStrides(this.data.length, n, this.stride1, this.stride2, this.stride3, this.stride4, this.stride5, this.stride6, this.stride7, this.stride8, this.stride9, this.dim1, this.dim2, this.dim3, this.dim4, this.dim5, this.dim6, this.dim7, this.dim8, this.dim9);
        this.flat = n == 0 && this.stride1 == 1 && this.stride2 == this.dim1 && this.stride3 == this.dim2 * this.stride2 && this.stride4 == this.dim3 * this.stride3 && this.stride5 == this.dim4 * this.stride4 && this.stride6 == this.dim5 * this.stride5 && this.stride7 == this.dim6 * this.stride6 && this.stride8 == this.dim7 * this.stride7 && this.stride9 == this.dim8 * this.stride8;
    }

    public StriddenInt9D(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16, int n17, int n18, int n19) {
        super(n11, n12, n13, n14, n15, n16, n17, n18, n19);
        this.data = nArray;
        this.offset = n;
        this.stride1 = n2;
        this.stride2 = n3;
        this.stride3 = n4;
        this.stride4 = n5;
        this.stride5 = n6;
        this.stride6 = n7;
        this.stride7 = n8;
        this.stride8 = n9;
        this.stride9 = n10;
        this.order = Int9D.checkViewStrides(this.data.length, n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13, n14, n15, n16, n17, n18, n19);
        this.flat = n == 0 && n2 == 1 && n3 == n11 && n4 == n12 * n3 && n5 == n13 * n4 && n6 == n14 * n5 && n7 == n15 * n6 && n8 == n16 * n7 && n9 == n17 * n8 && n10 == n18 * n9;
    }

    @Override
    public void checkSanity() {
        Int9D.checkViewStrides(this.data.length, this.offset, this.stride1, this.stride2, this.stride3, this.stride4, this.stride5, this.stride6, this.stride7, this.stride8, this.stride9, this.dim1, this.dim2, this.dim3, this.dim4, this.dim5, this.dim6, this.dim7, this.dim8, this.dim9);
    }

    final int index(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        return this.offset + this.stride9 * n9 + this.stride8 * n8 + this.stride7 * n7 + this.stride6 * n6 + this.stride5 * n5 + this.stride4 * n4 + this.stride3 * n3 + this.stride2 * n2 + this.stride1 * n;
    }

    @Override
    public final int get(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        return this.data[this.offset + this.stride9 * n9 + this.stride8 * n8 + this.stride7 * n7 + this.stride6 * n6 + this.stride5 * n5 + this.stride4 * n4 + this.stride3 * n3 + this.stride2 * n2 + this.stride1 * n];
    }

    @Override
    public final void set(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        this.data[this.offset + this.stride9 * n9 + this.stride8 * n8 + this.stride7 * n7 + this.stride6 * n6 + this.stride5 * n5 + this.stride4 * n4 + this.stride3 * n3 + this.stride2 * n2 + this.stride1 * n] = n10;
    }

    @Override
    public final int getOrder() {
        return this.order;
    }

    @Override
    public void fill(int n) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n2 = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n3 = this.stride2 * j + n2;
                    for (int k = 0; k < this.dim3; ++k) {
                        int n4 = this.stride3 * k + n3;
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            int n5 = this.stride4 * i2 + n4;
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                int n6 = this.stride5 * i3 + n5;
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    int n7 = this.stride6 * i4 + n6;
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        int n8 = this.stride7 * i5 + n7;
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            int n9 = this.stride8 * i6 + n8;
                                            for (int i7 = 0; i7 < this.dim9; ++i7) {
                                                int n10 = this.stride9 * i7 + n9;
                                                this.data[n10] = n;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim9; ++i) {
                int n11 = this.stride9 * i + this.offset;
                for (int j = 0; j < this.dim8; ++j) {
                    int n12 = this.stride8 * j + n11;
                    for (int k = 0; k < this.dim7; ++k) {
                        int n13 = this.stride7 * k + n12;
                        for (int i8 = 0; i8 < this.dim6; ++i8) {
                            int n14 = this.stride6 * i8 + n13;
                            for (int i9 = 0; i9 < this.dim5; ++i9) {
                                int n15 = this.stride5 * i9 + n14;
                                for (int i10 = 0; i10 < this.dim4; ++i10) {
                                    int n16 = this.stride4 * i10 + n15;
                                    for (int i11 = 0; i11 < this.dim3; ++i11) {
                                        int n17 = this.stride3 * i11 + n16;
                                        for (int i12 = 0; i12 < this.dim2; ++i12) {
                                            int n18 = this.stride2 * i12 + n17;
                                            for (int i13 = 0; i13 < this.dim1; ++i13) {
                                                int n19 = this.stride1 * i13 + n18;
                                                this.data[n19] = n;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void fill(IntGenerator intGenerator) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n2 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim3; ++k) {
                        int n3 = this.stride3 * k + n2;
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            int n4 = this.stride4 * i2 + n3;
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                int n5 = this.stride5 * i3 + n4;
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    int n6 = this.stride6 * i4 + n5;
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        int n7 = this.stride7 * i5 + n6;
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            int n8 = this.stride8 * i6 + n7;
                                            for (int i7 = 0; i7 < this.dim9; ++i7) {
                                                int n9 = this.stride9 * i7 + n8;
                                                this.data[n9] = intGenerator.nextInt();
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim9; ++i) {
                int n = this.stride9 * i + this.offset;
                for (int j = 0; j < this.dim8; ++j) {
                    int n10 = this.stride8 * j + n;
                    for (int k = 0; k < this.dim7; ++k) {
                        int n11 = this.stride7 * k + n10;
                        for (int i8 = 0; i8 < this.dim6; ++i8) {
                            int n12 = this.stride6 * i8 + n11;
                            for (int i9 = 0; i9 < this.dim5; ++i9) {
                                int n13 = this.stride5 * i9 + n12;
                                for (int i10 = 0; i10 < this.dim4; ++i10) {
                                    int n14 = this.stride4 * i10 + n13;
                                    for (int i11 = 0; i11 < this.dim3; ++i11) {
                                        int n15 = this.stride3 * i11 + n14;
                                        for (int i12 = 0; i12 < this.dim2; ++i12) {
                                            int n16 = this.stride2 * i12 + n15;
                                            for (int i13 = 0; i13 < this.dim1; ++i13) {
                                                int n17 = this.stride1 * i13 + n16;
                                                this.data[n17] = intGenerator.nextInt();
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void increment(int n) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n2 = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n3 = this.stride2 * j + n2;
                    for (int k = 0; k < this.dim3; ++k) {
                        int n4 = this.stride3 * k + n3;
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            int n5 = this.stride4 * i2 + n4;
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                int n6 = this.stride5 * i3 + n5;
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    int n7 = this.stride6 * i4 + n6;
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        int n8 = this.stride7 * i5 + n7;
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            int n9 = this.stride8 * i6 + n8;
                                            for (int i7 = 0; i7 < this.dim9; ++i7) {
                                                int n10;
                                                int n11 = n10 = this.stride9 * i7 + n9;
                                                this.data[n11] = this.data[n11] + n;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim9; ++i) {
                int n12 = this.stride9 * i + this.offset;
                for (int j = 0; j < this.dim8; ++j) {
                    int n13 = this.stride8 * j + n12;
                    for (int k = 0; k < this.dim7; ++k) {
                        int n14 = this.stride7 * k + n13;
                        for (int i8 = 0; i8 < this.dim6; ++i8) {
                            int n15 = this.stride6 * i8 + n14;
                            for (int i9 = 0; i9 < this.dim5; ++i9) {
                                int n16 = this.stride5 * i9 + n15;
                                for (int i10 = 0; i10 < this.dim4; ++i10) {
                                    int n17 = this.stride4 * i10 + n16;
                                    for (int i11 = 0; i11 < this.dim3; ++i11) {
                                        int n18 = this.stride3 * i11 + n17;
                                        for (int i12 = 0; i12 < this.dim2; ++i12) {
                                            int n19 = this.stride2 * i12 + n18;
                                            for (int i13 = 0; i13 < this.dim1; ++i13) {
                                                int n20;
                                                int n21 = n20 = this.stride1 * i13 + n19;
                                                this.data[n21] = this.data[n21] + n;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void decrement(int n) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n2 = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n3 = this.stride2 * j + n2;
                    for (int k = 0; k < this.dim3; ++k) {
                        int n4 = this.stride3 * k + n3;
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            int n5 = this.stride4 * i2 + n4;
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                int n6 = this.stride5 * i3 + n5;
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    int n7 = this.stride6 * i4 + n6;
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        int n8 = this.stride7 * i5 + n7;
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            int n9 = this.stride8 * i6 + n8;
                                            for (int i7 = 0; i7 < this.dim9; ++i7) {
                                                int n10;
                                                int n11 = n10 = this.stride9 * i7 + n9;
                                                this.data[n11] = this.data[n11] - n;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim9; ++i) {
                int n12 = this.stride9 * i + this.offset;
                for (int j = 0; j < this.dim8; ++j) {
                    int n13 = this.stride8 * j + n12;
                    for (int k = 0; k < this.dim7; ++k) {
                        int n14 = this.stride7 * k + n13;
                        for (int i8 = 0; i8 < this.dim6; ++i8) {
                            int n15 = this.stride6 * i8 + n14;
                            for (int i9 = 0; i9 < this.dim5; ++i9) {
                                int n16 = this.stride5 * i9 + n15;
                                for (int i10 = 0; i10 < this.dim4; ++i10) {
                                    int n17 = this.stride4 * i10 + n16;
                                    for (int i11 = 0; i11 < this.dim3; ++i11) {
                                        int n18 = this.stride3 * i11 + n17;
                                        for (int i12 = 0; i12 < this.dim2; ++i12) {
                                            int n19 = this.stride2 * i12 + n18;
                                            for (int i13 = 0; i13 < this.dim1; ++i13) {
                                                int n20;
                                                int n21 = n20 = this.stride1 * i13 + n19;
                                                this.data[n21] = this.data[n21] - n;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void scale(int n) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n2 = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n3 = this.stride2 * j + n2;
                    for (int k = 0; k < this.dim3; ++k) {
                        int n4 = this.stride3 * k + n3;
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            int n5 = this.stride4 * i2 + n4;
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                int n6 = this.stride5 * i3 + n5;
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    int n7 = this.stride6 * i4 + n6;
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        int n8 = this.stride7 * i5 + n7;
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            int n9 = this.stride8 * i6 + n8;
                                            for (int i7 = 0; i7 < this.dim9; ++i7) {
                                                int n10;
                                                int n11 = n10 = this.stride9 * i7 + n9;
                                                this.data[n11] = this.data[n11] * n;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim9; ++i) {
                int n12 = this.stride9 * i + this.offset;
                for (int j = 0; j < this.dim8; ++j) {
                    int n13 = this.stride8 * j + n12;
                    for (int k = 0; k < this.dim7; ++k) {
                        int n14 = this.stride7 * k + n13;
                        for (int i8 = 0; i8 < this.dim6; ++i8) {
                            int n15 = this.stride6 * i8 + n14;
                            for (int i9 = 0; i9 < this.dim5; ++i9) {
                                int n16 = this.stride5 * i9 + n15;
                                for (int i10 = 0; i10 < this.dim4; ++i10) {
                                    int n17 = this.stride4 * i10 + n16;
                                    for (int i11 = 0; i11 < this.dim3; ++i11) {
                                        int n18 = this.stride3 * i11 + n17;
                                        for (int i12 = 0; i12 < this.dim2; ++i12) {
                                            int n19 = this.stride2 * i12 + n18;
                                            for (int i13 = 0; i13 < this.dim1; ++i13) {
                                                int n20;
                                                int n21 = n20 = this.stride1 * i13 + n19;
                                                this.data[n21] = this.data[n21] * n;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void map(IntFunction intFunction) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n2 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim3; ++k) {
                        int n3 = this.stride3 * k + n2;
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            int n4 = this.stride4 * i2 + n3;
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                int n5 = this.stride5 * i3 + n4;
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    int n6 = this.stride6 * i4 + n5;
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        int n7 = this.stride7 * i5 + n6;
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            int n8 = this.stride8 * i6 + n7;
                                            for (int i7 = 0; i7 < this.dim9; ++i7) {
                                                int n9 = this.stride9 * i7 + n8;
                                                this.data[n9] = intFunction.apply(this.data[n9]);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim9; ++i) {
                int n = this.stride9 * i + this.offset;
                for (int j = 0; j < this.dim8; ++j) {
                    int n10 = this.stride8 * j + n;
                    for (int k = 0; k < this.dim7; ++k) {
                        int n11 = this.stride7 * k + n10;
                        for (int i8 = 0; i8 < this.dim6; ++i8) {
                            int n12 = this.stride6 * i8 + n11;
                            for (int i9 = 0; i9 < this.dim5; ++i9) {
                                int n13 = this.stride5 * i9 + n12;
                                for (int i10 = 0; i10 < this.dim4; ++i10) {
                                    int n14 = this.stride4 * i10 + n13;
                                    for (int i11 = 0; i11 < this.dim3; ++i11) {
                                        int n15 = this.stride3 * i11 + n14;
                                        for (int i12 = 0; i12 < this.dim2; ++i12) {
                                            int n16 = this.stride2 * i12 + n15;
                                            for (int i13 = 0; i13 < this.dim1; ++i13) {
                                                int n17 = this.stride1 * i13 + n16;
                                                this.data[n17] = intFunction.apply(this.data[n17]);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void scan(IntScanner intScanner) {
        boolean bl = false;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n2 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim3; ++k) {
                        int n3 = this.stride3 * k + n2;
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            int n4 = this.stride4 * i2 + n3;
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                int n5 = this.stride5 * i3 + n4;
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    int n6 = this.stride6 * i4 + n5;
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        int n7 = this.stride7 * i5 + n6;
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            int n8 = this.stride8 * i6 + n7;
                                            for (int i7 = 0; i7 < this.dim9; ++i7) {
                                                int n9 = this.stride9 * i7 + n8;
                                                if (bl) {
                                                    intScanner.update(this.data[n9]);
                                                    continue;
                                                }
                                                intScanner.initialize(this.data[n9]);
                                                bl = true;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim9; ++i) {
                int n = this.stride9 * i + this.offset;
                for (int j = 0; j < this.dim8; ++j) {
                    int n10 = this.stride8 * j + n;
                    for (int k = 0; k < this.dim7; ++k) {
                        int n11 = this.stride7 * k + n10;
                        for (int i8 = 0; i8 < this.dim6; ++i8) {
                            int n12 = this.stride6 * i8 + n11;
                            for (int i9 = 0; i9 < this.dim5; ++i9) {
                                int n13 = this.stride5 * i9 + n12;
                                for (int i10 = 0; i10 < this.dim4; ++i10) {
                                    int n14 = this.stride4 * i10 + n13;
                                    for (int i11 = 0; i11 < this.dim3; ++i11) {
                                        int n15 = this.stride3 * i11 + n14;
                                        for (int i12 = 0; i12 < this.dim2; ++i12) {
                                            int n16 = this.stride2 * i12 + n15;
                                            for (int i13 = 0; i13 < this.dim1; ++i13) {
                                                int n17 = this.stride1 * i13 + n16;
                                                if (bl) {
                                                    intScanner.update(this.data[n17]);
                                                    continue;
                                                }
                                                intScanner.initialize(this.data[n17]);
                                                bl = true;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public final boolean isFlat() {
        return this.flat;
    }

    @Override
    public int[] flatten(boolean bl) {
        if (!bl && this.flat) {
            return this.data;
        }
        int[] nArray = new int[this.number];
        if (this.flat) {
            System.arraycopy(this.data, 0, nArray, 0, this.number);
        } else {
            int n = -1;
            for (int i = 0; i < this.dim9; ++i) {
                int n2 = this.stride9 * i + this.offset;
                for (int j = 0; j < this.dim8; ++j) {
                    int n3 = this.stride8 * j + n2;
                    for (int k = 0; k < this.dim7; ++k) {
                        int n4 = this.stride7 * k + n3;
                        for (int i2 = 0; i2 < this.dim6; ++i2) {
                            int n5 = this.stride6 * i2 + n4;
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                int n6 = this.stride5 * i3 + n5;
                                for (int i4 = 0; i4 < this.dim4; ++i4) {
                                    int n7 = this.stride4 * i4 + n6;
                                    for (int i5 = 0; i5 < this.dim3; ++i5) {
                                        int n8 = this.stride3 * i5 + n7;
                                        for (int i6 = 0; i6 < this.dim2; ++i6) {
                                            int n9 = this.stride2 * i6 + n8;
                                            for (int i7 = 0; i7 < this.dim1; ++i7) {
                                                int n10 = this.stride1 * i7 + n9;
                                                nArray[++n] = this.data[n10];
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return nArray;
    }

    @Override
    public int[] getData() {
        return this.flat ? this.data : null;
    }

    @Override
    public Int8D slice(int n) {
        return new StriddenInt8D(this.data, this.offset + this.stride9 * n, this.stride1, this.stride2, this.stride3, this.stride4, this.stride5, this.stride6, this.stride7, this.stride8, this.dim1, this.dim2, this.dim3, this.dim4, this.dim5, this.dim6, this.dim7, this.dim8);
    }

    @Override
    public Int8D slice(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        int n18;
        int n19;
        if (n2 < 0) {
            n2 += 9;
        }
        if (n2 == 0) {
            n19 = this.offset + this.stride1 * n;
            n18 = this.stride2;
            n17 = this.stride3;
            n16 = this.stride4;
            n15 = this.stride5;
            n14 = this.stride6;
            n13 = this.stride7;
            n12 = this.stride8;
            n11 = this.stride9;
            n10 = this.dim2;
            n9 = this.dim3;
            n8 = this.dim4;
            n7 = this.dim5;
            n6 = this.dim6;
            n5 = this.dim7;
            n4 = this.dim8;
            n3 = this.dim9;
        } else if (n2 == 1) {
            n19 = this.offset + this.stride2 * n;
            n18 = this.stride1;
            n17 = this.stride3;
            n16 = this.stride4;
            n15 = this.stride5;
            n14 = this.stride6;
            n13 = this.stride7;
            n12 = this.stride8;
            n11 = this.stride9;
            n10 = this.dim1;
            n9 = this.dim3;
            n8 = this.dim4;
            n7 = this.dim5;
            n6 = this.dim6;
            n5 = this.dim7;
            n4 = this.dim8;
            n3 = this.dim9;
        } else if (n2 == 2) {
            n19 = this.offset + this.stride3 * n;
            n18 = this.stride1;
            n17 = this.stride2;
            n16 = this.stride4;
            n15 = this.stride5;
            n14 = this.stride6;
            n13 = this.stride7;
            n12 = this.stride8;
            n11 = this.stride9;
            n10 = this.dim1;
            n9 = this.dim2;
            n8 = this.dim4;
            n7 = this.dim5;
            n6 = this.dim6;
            n5 = this.dim7;
            n4 = this.dim8;
            n3 = this.dim9;
        } else if (n2 == 3) {
            n19 = this.offset + this.stride4 * n;
            n18 = this.stride1;
            n17 = this.stride2;
            n16 = this.stride3;
            n15 = this.stride5;
            n14 = this.stride6;
            n13 = this.stride7;
            n12 = this.stride8;
            n11 = this.stride9;
            n10 = this.dim1;
            n9 = this.dim2;
            n8 = this.dim3;
            n7 = this.dim5;
            n6 = this.dim6;
            n5 = this.dim7;
            n4 = this.dim8;
            n3 = this.dim9;
        } else if (n2 == 4) {
            n19 = this.offset + this.stride5 * n;
            n18 = this.stride1;
            n17 = this.stride2;
            n16 = this.stride3;
            n15 = this.stride4;
            n14 = this.stride6;
            n13 = this.stride7;
            n12 = this.stride8;
            n11 = this.stride9;
            n10 = this.dim1;
            n9 = this.dim2;
            n8 = this.dim3;
            n7 = this.dim4;
            n6 = this.dim6;
            n5 = this.dim7;
            n4 = this.dim8;
            n3 = this.dim9;
        } else if (n2 == 5) {
            n19 = this.offset + this.stride6 * n;
            n18 = this.stride1;
            n17 = this.stride2;
            n16 = this.stride3;
            n15 = this.stride4;
            n14 = this.stride5;
            n13 = this.stride7;
            n12 = this.stride8;
            n11 = this.stride9;
            n10 = this.dim1;
            n9 = this.dim2;
            n8 = this.dim3;
            n7 = this.dim4;
            n6 = this.dim5;
            n5 = this.dim7;
            n4 = this.dim8;
            n3 = this.dim9;
        } else if (n2 == 6) {
            n19 = this.offset + this.stride7 * n;
            n18 = this.stride1;
            n17 = this.stride2;
            n16 = this.stride3;
            n15 = this.stride4;
            n14 = this.stride5;
            n13 = this.stride6;
            n12 = this.stride8;
            n11 = this.stride9;
            n10 = this.dim1;
            n9 = this.dim2;
            n8 = this.dim3;
            n7 = this.dim4;
            n6 = this.dim5;
            n5 = this.dim6;
            n4 = this.dim8;
            n3 = this.dim9;
        } else if (n2 == 7) {
            n19 = this.offset + this.stride8 * n;
            n18 = this.stride1;
            n17 = this.stride2;
            n16 = this.stride3;
            n15 = this.stride4;
            n14 = this.stride5;
            n13 = this.stride6;
            n12 = this.stride7;
            n11 = this.stride9;
            n10 = this.dim1;
            n9 = this.dim2;
            n8 = this.dim3;
            n7 = this.dim4;
            n6 = this.dim5;
            n5 = this.dim6;
            n4 = this.dim7;
            n3 = this.dim9;
        } else if (n2 == 8) {
            n19 = this.offset + this.stride9 * n;
            n18 = this.stride1;
            n17 = this.stride2;
            n16 = this.stride3;
            n15 = this.stride4;
            n14 = this.stride5;
            n13 = this.stride6;
            n12 = this.stride7;
            n11 = this.stride8;
            n10 = this.dim1;
            n9 = this.dim2;
            n8 = this.dim3;
            n7 = this.dim4;
            n6 = this.dim5;
            n5 = this.dim6;
            n4 = this.dim7;
            n3 = this.dim8;
        } else {
            throw new IndexOutOfBoundsException("Dimension index out of bounds");
        }
        return new StriddenInt8D(this.data, n19, n18, n17, n16, n15, n14, n13, n12, n11, n10, n9, n8, n7, n6, n5, n4, n3);
    }

    @Override
    public Int9D view(Range range, Range range2, Range range3, Range range4, Range range5, Range range6, Range range7, Range range8, Range range9) {
        CompiledRange compiledRange = new CompiledRange(range, this.dim1, this.offset, this.stride1);
        CompiledRange compiledRange2 = new CompiledRange(range2, this.dim2, 0, this.stride2);
        CompiledRange compiledRange3 = new CompiledRange(range3, this.dim3, 0, this.stride3);
        CompiledRange compiledRange4 = new CompiledRange(range4, this.dim4, 0, this.stride4);
        CompiledRange compiledRange5 = new CompiledRange(range5, this.dim5, 0, this.stride5);
        CompiledRange compiledRange6 = new CompiledRange(range6, this.dim6, 0, this.stride6);
        CompiledRange compiledRange7 = new CompiledRange(range7, this.dim7, 0, this.stride7);
        CompiledRange compiledRange8 = new CompiledRange(range8, this.dim8, 0, this.stride8);
        CompiledRange compiledRange9 = new CompiledRange(range9, this.dim9, 0, this.stride9);
        if (compiledRange.doesNothing() && compiledRange2.doesNothing() && compiledRange3.doesNothing() && compiledRange4.doesNothing() && compiledRange5.doesNothing() && compiledRange6.doesNothing() && compiledRange7.doesNothing() && compiledRange8.doesNothing() && compiledRange9.doesNothing()) {
            return this;
        }
        return new StriddenInt9D(this.data, compiledRange.getOffset() + compiledRange2.getOffset() + compiledRange3.getOffset() + compiledRange4.getOffset() + compiledRange5.getOffset() + compiledRange6.getOffset() + compiledRange7.getOffset() + compiledRange8.getOffset() + compiledRange9.getOffset(), compiledRange.getStride(), compiledRange2.getStride(), compiledRange3.getStride(), compiledRange4.getStride(), compiledRange5.getStride(), compiledRange6.getStride(), compiledRange7.getStride(), compiledRange8.getStride(), compiledRange9.getStride(), compiledRange.getNumber(), compiledRange2.getNumber(), compiledRange3.getNumber(), compiledRange4.getNumber(), compiledRange5.getNumber(), compiledRange6.getNumber(), compiledRange7.getNumber(), compiledRange8.getNumber(), compiledRange9.getNumber());
    }

    @Override
    public Int9D view(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5, int[] nArray6, int[] nArray7, int[] nArray8, int[] nArray9) {
        int[] nArray10 = Helper.select(this.offset, this.stride1, this.dim1, nArray);
        int[] nArray11 = Helper.select(0, this.stride2, this.dim2, nArray2);
        int[] nArray12 = Helper.select(0, this.stride3, this.dim3, nArray3);
        int[] nArray13 = Helper.select(0, this.stride4, this.dim4, nArray4);
        int[] nArray14 = Helper.select(0, this.stride5, this.dim5, nArray5);
        int[] nArray15 = Helper.select(0, this.stride6, this.dim6, nArray6);
        int[] nArray16 = Helper.select(0, this.stride7, this.dim7, nArray7);
        int[] nArray17 = Helper.select(0, this.stride8, this.dim8, nArray8);
        int[] nArray18 = Helper.select(0, this.stride9, this.dim9, nArray9);
        return new SelectedInt9D(this.data, nArray10, nArray11, nArray12, nArray13, nArray14, nArray15, nArray16, nArray17, nArray18);
    }

    @Override
    public Int1D as1D() {
        return new FlatInt1D(this.flatten(), this.number);
    }
}

