/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.array.Long1D;
import mitiv.array.Long2D;
import mitiv.array.impl.FlatLong1D;
import mitiv.array.impl.Helper;
import mitiv.array.impl.SelectedLong2D;
import mitiv.array.impl.StriddenLong1D;
import mitiv.base.indexing.CompiledRange;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.LongFunction;
import mitiv.base.mapping.LongScanner;
import mitiv.random.LongGenerator;

public class StriddenLong2D
extends Long2D {
    final int order;
    final long[] data;
    final int offset;
    final int stride1;
    final int stride2;
    final boolean flat;

    public StriddenLong2D(long[] lArray, int n, int[] nArray, int[] nArray2) {
        super(nArray2);
        if (nArray.length != 2) {
            throw new IllegalArgumentException("There must be as many strides as the rank");
        }
        this.data = lArray;
        this.offset = n;
        this.stride1 = nArray[0];
        this.stride2 = nArray[1];
        this.order = Long2D.checkViewStrides(this.data.length, n, this.stride1, this.stride2, this.dim1, this.dim2);
        this.flat = n == 0 && this.stride1 == 1 && this.stride2 == this.dim1;
    }

    public StriddenLong2D(long[] lArray, int n, int n2, int n3, int n4, int n5) {
        super(n4, n5);
        this.data = lArray;
        this.offset = n;
        this.stride1 = n2;
        this.stride2 = n3;
        this.order = Long2D.checkViewStrides(this.data.length, n, n2, n3, n4, n5);
        this.flat = n == 0 && n2 == 1 && n3 == n4;
    }

    @Override
    public void checkSanity() {
        Long2D.checkViewStrides(this.data.length, this.offset, this.stride1, this.stride2, this.dim1, this.dim2);
    }

    final int index(int n, int n2) {
        return this.offset + this.stride2 * n2 + this.stride1 * n;
    }

    @Override
    public final long get(int n, int n2) {
        return this.data[this.offset + this.stride2 * n2 + this.stride1 * n];
    }

    @Override
    public final void set(int n, int n2, long l) {
        this.data[this.offset + this.stride2 * n2 + this.stride1 * n] = l;
    }

    @Override
    public final int getOrder() {
        return this.order;
    }

    @Override
    public void fill(long l) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n2 = this.stride2 * j + n;
                    this.data[n2] = l;
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                int n = this.stride2 * i + this.offset;
                for (int j = 0; j < this.dim1; ++j) {
                    int n3 = this.stride1 * j + n;
                    this.data[n3] = l;
                }
            }
        }
    }

    @Override
    public void fill(LongGenerator longGenerator) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n2 = this.stride2 * j + n;
                    this.data[n2] = longGenerator.nextLong();
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                int n = this.stride2 * i + this.offset;
                for (int j = 0; j < this.dim1; ++j) {
                    int n3 = this.stride1 * j + n;
                    this.data[n3] = longGenerator.nextLong();
                }
            }
        }
    }

    @Override
    public void increment(long l) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n2;
                    int n3 = n2 = this.stride2 * j + n;
                    this.data[n3] = this.data[n3] + l;
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                int n = this.stride2 * i + this.offset;
                for (int j = 0; j < this.dim1; ++j) {
                    int n4;
                    int n5 = n4 = this.stride1 * j + n;
                    this.data[n5] = this.data[n5] + l;
                }
            }
        }
    }

    @Override
    public void decrement(long l) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n2;
                    int n3 = n2 = this.stride2 * j + n;
                    this.data[n3] = this.data[n3] - l;
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                int n = this.stride2 * i + this.offset;
                for (int j = 0; j < this.dim1; ++j) {
                    int n4;
                    int n5 = n4 = this.stride1 * j + n;
                    this.data[n5] = this.data[n5] - l;
                }
            }
        }
    }

    @Override
    public void scale(long l) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n2;
                    int n3 = n2 = this.stride2 * j + n;
                    this.data[n3] = this.data[n3] * l;
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                int n = this.stride2 * i + this.offset;
                for (int j = 0; j < this.dim1; ++j) {
                    int n4;
                    int n5 = n4 = this.stride1 * j + n;
                    this.data[n5] = this.data[n5] * l;
                }
            }
        }
    }

    @Override
    public void map(LongFunction longFunction) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n2 = this.stride2 * j + n;
                    this.data[n2] = longFunction.apply(this.data[n2]);
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                int n = this.stride2 * i + this.offset;
                for (int j = 0; j < this.dim1; ++j) {
                    int n3 = this.stride1 * j + n;
                    this.data[n3] = longFunction.apply(this.data[n3]);
                }
            }
        }
    }

    @Override
    public void scan(LongScanner longScanner) {
        boolean bl = false;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n2 = this.stride2 * j + n;
                    if (bl) {
                        longScanner.update(this.data[n2]);
                        continue;
                    }
                    longScanner.initialize(this.data[n2]);
                    bl = true;
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                int n = this.stride2 * i + this.offset;
                for (int j = 0; j < this.dim1; ++j) {
                    int n3 = this.stride1 * j + n;
                    if (bl) {
                        longScanner.update(this.data[n3]);
                        continue;
                    }
                    longScanner.initialize(this.data[n3]);
                    bl = true;
                }
            }
        }
    }

    @Override
    public final boolean isFlat() {
        return this.flat;
    }

    @Override
    public long[] flatten(boolean bl) {
        if (!bl && this.flat) {
            return this.data;
        }
        long[] lArray = new long[this.number];
        if (this.flat) {
            System.arraycopy(this.data, 0, lArray, 0, this.number);
        } else {
            int n = -1;
            for (int i = 0; i < this.dim2; ++i) {
                int n2 = this.stride2 * i + this.offset;
                for (int j = 0; j < this.dim1; ++j) {
                    int n3 = this.stride1 * j + n2;
                    lArray[++n] = this.data[n3];
                }
            }
        }
        return lArray;
    }

    @Override
    public long[] getData() {
        return this.flat ? this.data : null;
    }

    @Override
    public Long1D slice(int n) {
        return new StriddenLong1D(this.data, this.offset + this.stride2 * n, this.stride1, this.dim1);
    }

    @Override
    public Long1D slice(int n, int n2) {
        int n3;
        int n4;
        int n5;
        if (n2 < 0) {
            n2 += 2;
        }
        if (n2 == 0) {
            n5 = this.offset + this.stride1 * n;
            n4 = this.stride2;
            n3 = this.dim2;
        } else if (n2 == 1) {
            n5 = this.offset + this.stride2 * n;
            n4 = this.stride1;
            n3 = this.dim1;
        } else {
            throw new IndexOutOfBoundsException("Dimension index out of bounds");
        }
        return new StriddenLong1D(this.data, n5, n4, n3);
    }

    @Override
    public Long2D view(Range range, Range range2) {
        CompiledRange compiledRange = new CompiledRange(range, this.dim1, this.offset, this.stride1);
        CompiledRange compiledRange2 = new CompiledRange(range2, this.dim2, 0, this.stride2);
        if (compiledRange.doesNothing() && compiledRange2.doesNothing()) {
            return this;
        }
        return new StriddenLong2D(this.data, compiledRange.getOffset() + compiledRange2.getOffset(), compiledRange.getStride(), compiledRange2.getStride(), compiledRange.getNumber(), compiledRange2.getNumber());
    }

    @Override
    public Long2D view(int[] nArray, int[] nArray2) {
        int[] nArray3 = Helper.select(this.offset, this.stride1, this.dim1, nArray);
        int[] nArray4 = Helper.select(0, this.stride2, this.dim2, nArray2);
        return new SelectedLong2D(this.data, nArray3, nArray4);
    }

    @Override
    public Long1D as1D() {
        return new FlatLong1D(this.flatten(), this.number);
    }
}

