/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo;

import cern.colt.Timer;
import cern.colt.list.tobject.ObjectArrayList;
import cern.colt.matrix.AbstractFormatter;
import cern.colt.matrix.AbstractMatrix1D;
import cern.colt.matrix.AbstractMatrix2D;
import cern.colt.matrix.Former;
import cern.colt.matrix.FormerFactory;
import cern.colt.matrix.tdouble.DoubleFactory2D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix3D;
import cern.colt.matrix.tdouble.algo.DoubleStatistic;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.tobject.ObjectFactory2D;
import cern.colt.matrix.tobject.ObjectMatrix2D;
import cern.colt.matrix.tobject.algo.ObjectFormatter;
import hep.aida.tdouble.bin.DoubleBinFunction1D;
import hep.aida.tdouble.bin.DoubleBinFunctions1D;

public class DoubleFormatter
extends AbstractFormatter {
    private static final long serialVersionUID = 1L;

    public DoubleFormatter() {
        this("%G");
    }

    public DoubleFormatter(String format) {
        this.setFormat(format);
        this.setAlignment("decimal");
    }

    public static void demo1() {
        double[][] values = new double[][]{{3.0, 0.0, -3.4, 0.0}, {5.1, 0.0, 3.0123456789, 0.0}, {16.37, 0.0, 2.5, 0.0}, {-16.3, 0.0, -3.012345678E-4, -1.0}, {1236.3456789, 0.0, 7.0, -1.2}};
        String[] stringArray = new String[6];
        stringArray[0] = "%G";
        stringArray[1] = "%1.10G";
        stringArray[2] = "%f";
        stringArray[3] = "%1.2f";
        stringArray[4] = "%0.2e";
        String[] formats = stringArray;
        int size = formats.length;
        DoubleMatrix2D matrix = DoubleFactory2D.dense.make(values);
        String[] strings = new String[size];
        String[] sourceCodes = new String[size];
        int i = 0;
        while (i < size) {
            String format = formats[i];
            strings[i] = new DoubleFormatter(format).toString(matrix);
            sourceCodes[i] = new DoubleFormatter(format).toSourceCode(matrix);
            ++i;
        }
        System.out.println("original:\n" + new DoubleFormatter().toString(matrix));
        i = 0;
        while (i < size) {
            System.out.println("\nstring(" + formats[i] + "):\n" + strings[i]);
            System.out.println("\nsourceCode(" + formats[i] + "):\n" + sourceCodes[i]);
            ++i;
        }
    }

    public static void demo2() {
        double[] values = new double[]{5.0, 0.0, -0.0, Double.NaN, Double.NaN, Double.NaN, Double.MIN_VALUE, Double.MAX_VALUE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY};
        String[] formats = new String[]{"%G", "%1.19G"};
        int size = formats.length;
        DenseDoubleMatrix1D matrix = new DenseDoubleMatrix1D(values);
        String[] strings = new String[size];
        int i = 0;
        while (i < size) {
            String format = formats[i];
            strings[i] = new DoubleFormatter(format).toString(matrix);
            int j = 0;
            while ((long)j < matrix.size()) {
                System.out.println(String.valueOf(matrix.get(j)));
                ++j;
            }
            ++i;
        }
        System.out.println("original:\n" + new DoubleFormatter().toString(matrix));
        i = 0;
        while (i < size) {
            System.out.println("\nstring(" + formats[i] + "):\n" + strings[i]);
            ++i;
        }
    }

    public static void demo3(int size, double value) {
        Timer timer = new Timer();
        DoubleMatrix2D matrix = DoubleFactory2D.dense.make(size, size, value);
        timer.reset().start();
        StringBuffer buf = new StringBuffer();
        int i = size;
        while (--i >= 0) {
            int j = size;
            while (--j >= 0) {
                buf.append(matrix.getQuick(i, j));
            }
        }
        buf = null;
        timer.stop().display();
        timer.reset().start();
        Former format = new FormerFactory().create("%G");
        buf = new StringBuffer();
        int i2 = size;
        while (--i2 >= 0) {
            int j = size;
            while (--j >= 0) {
                buf.append(format.form(matrix.getQuick(i2, j)));
            }
        }
        buf = null;
        timer.stop().display();
        timer.reset().start();
        String s = new DoubleFormatter(null).toString(matrix);
        System.out.println(s);
        s = null;
        timer.stop().display();
        timer.reset().start();
        s = new DoubleFormatter("%G").toString(matrix);
        System.out.println(s);
        s = null;
        timer.stop().display();
    }

    public static void demo4() {
        double[][] values = new double[][]{{3.0, 0.0, -3.4, 0.0}, {5.1, 0.0, 3.0123456789, 0.0}, {16.37, 0.0, 2.5, 0.0}, {-16.3, 0.0, -3.012345678E-4, -1.0}, {1236.3456789, 0.0, 7.0, -1.2}};
        String[] columnNames = new String[]{"0.1", "0.3", "0.5", "0.7"};
        String[] rowNames = new String[]{"SunJDK1.2.2 classic", "IBMJDK1.1.8", "SunJDK1.3 Hotspot", "other1", "other2"};
        DoubleMatrix2D matrix = DoubleFactory2D.dense.make(values);
        System.out.println("\n\n" + new DoubleFormatter("%G").toTitleString(matrix, rowNames, columnNames, "rowAxis", "colAxis", "VM Performance: Provider vs. matrix density"));
    }

    public static void demo5() {
        double[][] values = new double[][]{{3.0, 0.0, -3.4, 0.0}, {5.1, 0.0, 3.0123456789, 0.0}, {16.37, 0.0, 2.5, 0.0}, {-16.3, 0.0, -3.012345678E-4, -1.0}, {1236.3456789, 0.0, 7.0, -1.2}};
        String[] columnNames = new String[]{"0.1", "0.3", "0.5", "0.7"};
        String[] rowNames = new String[]{"SunJDK1.2.2 classic", "IBMJDK1.1.8", "SunJDK1.3 Hotspot", "other1", "other2"};
        System.out.println(DoubleFactory2D.dense.make(values));
        System.out.println(new DoubleFormatter("%G").toTitleString(DoubleFactory2D.dense.make(values), rowNames, columnNames, "vendor", "density", "title"));
    }

    public static void demo6() {
        double[][] values = new double[][]{{3.0, 0.0, -3.4, 0.0}, {5.1, 0.0, 3.0123456789, 0.0}, {16.37, 0.0, 2.5, 0.0}, {-16.3, 0.0, -3.012345678E-4, -1.0}, {1236.3456789, 0.0, 7.0, -1.2}};
        String[] columnNames = new String[]{"W", "X", "Y", "Z"};
        String[] rowNames = new String[]{"SunJDK1.2.2 classic", "IBMJDK1.1.8", "SunJDK1.3 Hotspot", "other1", "other2"};
        System.out.println(new DoubleFormatter().toString(DoubleFactory2D.dense.make(values)));
        System.out.println(new DoubleFormatter().toTitleString(DoubleFactory2D.dense.make(values), rowNames, columnNames, "vendor", "density", "title"));
    }

    public static void demo7() {
        double[][] values = new double[][]{{5.0, 10.0, 20.0, 40.0}, {7.0, 8.0, 6.0, 7.0}, {12.0, 10.0, 20.0, 19.0}, {3.0, 1.0, 5.0, 6.0}};
        String[] columnNames = new String[]{"1996", "1997", "1998", "1999"};
        String[] rowNames = new String[]{"PowerBar", "Benzol", "Mercedes", "Sparcling"};
        String rowAxisName = "CPU";
        String columnAxisName = "Year";
        String title = "CPU performance over time [nops/sec]";
        DoubleBinFunctions1D F = DoubleBinFunctions1D.functions;
        DoubleBinFunction1D[] aggr = new DoubleBinFunction1D[]{DoubleBinFunctions1D.mean, DoubleBinFunctions1D.rms, DoubleBinFunctions1D.quantile(0.25), DoubleBinFunctions1D.median, DoubleBinFunctions1D.quantile(0.75), DoubleBinFunctions1D.stdDev, DoubleBinFunctions1D.min, DoubleBinFunctions1D.max};
        String format = "%1.2G";
        System.out.println(new DoubleFormatter(format).toTitleString(DoubleFactory2D.dense.make(values), rowNames, columnNames, rowAxisName, columnAxisName, title, aggr));
    }

    protected String form(DoubleMatrix1D matrix, int index, Former formatter) {
        return formatter.form(matrix.get(index));
    }

    @Override
    protected String form(AbstractMatrix1D matrix, int index, Former formatter) {
        return this.form((DoubleMatrix1D)matrix, index, formatter);
    }

    public String[][] format(DoubleMatrix2D matrix) {
        String[][] strings = new String[matrix.rows()][matrix.columns()];
        int row = matrix.rows();
        while (--row >= 0) {
            strings[row] = this.formatRow(matrix.viewRow(row));
        }
        return strings;
    }

    @Override
    protected String[][] format(AbstractMatrix2D matrix) {
        return this.format((DoubleMatrix2D)matrix);
    }

    protected int indexOfDecimalPoint(String s) {
        int i = s.lastIndexOf(46);
        if (i < 0) {
            i = s.lastIndexOf(101);
        }
        if (i < 0) {
            i = s.lastIndexOf(69);
        }
        if (i < 0) {
            i = s.length();
        }
        return i;
    }

    @Override
    protected int lead(String s) {
        if (this.alignment.equals("decimal")) {
            return this.indexOfDecimalPoint(s);
        }
        return super.lead(s);
    }

    public String toSourceCode(DoubleMatrix1D matrix) {
        DoubleFormatter copy = (DoubleFormatter)this.clone();
        copy.setPrintShape(false);
        copy.setColumnSeparator(", ");
        String lead = "{";
        String trail = "};";
        return String.valueOf(lead) + copy.toString(matrix) + trail;
    }

    public String toSourceCode(DoubleMatrix2D matrix) {
        DoubleFormatter copy = (DoubleFormatter)this.clone();
        String b3 = this.blanks(3);
        copy.setPrintShape(false);
        copy.setColumnSeparator(", ");
        copy.setRowSeparator("},\n" + b3 + "{");
        String lead = "{\n" + b3 + "{";
        String trail = "}\n};";
        return String.valueOf(lead) + copy.toString(matrix) + trail;
    }

    public String toSourceCode(DoubleMatrix3D matrix) {
        DoubleFormatter copy = (DoubleFormatter)this.clone();
        String b3 = this.blanks(3);
        String b6 = this.blanks(6);
        copy.setPrintShape(false);
        copy.setColumnSeparator(", ");
        copy.setRowSeparator("},\n" + b6 + "{");
        copy.setSliceSeparator("}\n" + b3 + "},\n" + b3 + "{\n" + b6 + "{");
        String lead = "{\n" + b3 + "{\n" + b6 + "{";
        String trail = "}\n" + b3 + "}\n}";
        return String.valueOf(lead) + copy.toString(matrix) + trail;
    }

    public String toString(DoubleMatrix1D matrix) {
        DoubleMatrix2D easy = matrix.like2D(1, (int)matrix.size());
        easy.viewRow(0).assign(matrix);
        return this.toString(easy);
    }

    public String toString(DoubleMatrix2D matrix) {
        return super.toString(matrix);
    }

    public String toString(DoubleMatrix3D matrix) {
        StringBuffer buf = new StringBuffer();
        boolean oldPrintShape = this.printShape;
        this.printShape = false;
        int slice = 0;
        while (slice < matrix.slices()) {
            if (slice != 0) {
                buf.append(this.sliceSeparator);
            }
            buf.append(this.toString(matrix.viewSlice(slice)));
            ++slice;
        }
        this.printShape = oldPrintShape;
        if (this.printShape) {
            buf.insert(0, String.valueOf(DoubleFormatter.shape(matrix)) + "\n");
        }
        return buf.toString();
    }

    @Override
    protected String toString(AbstractMatrix2D matrix) {
        return this.toString((DoubleMatrix2D)matrix);
    }

    protected String toTitleString(DoubleMatrix2D matrix, String[] rowNames, String[] columnNames, String rowAxisName, String columnAxisName, String title) {
        if (matrix.size() == 0L) {
            return "Empty matrix";
        }
        Object[][] s = this.format(matrix);
        this.align((String[][])s);
        return new ObjectFormatter().toTitleString(ObjectFactory2D.dense.make(s), rowNames, columnNames, rowAxisName, columnAxisName, title);
    }

    public String toTitleString(DoubleMatrix2D matrix, String[] rowNames, String[] columnNames, String rowAxisName, String columnAxisName, String title, DoubleBinFunction1D[] aggr) {
        int last;
        int i;
        ObjectArrayList list;
        if (matrix.size() == 0L) {
            return "Empty matrix";
        }
        if (aggr == null || aggr.length == 0) {
            return this.toTitleString(matrix, rowNames, columnNames, rowAxisName, columnAxisName, title);
        }
        DoubleMatrix2D rowStats = matrix.like(matrix.rows(), aggr.length);
        DoubleMatrix2D colStats = matrix.like(aggr.length, matrix.columns());
        DoubleStatistic.aggregate(matrix, aggr, colStats);
        DoubleStatistic.aggregate(matrix.viewDice(), aggr, rowStats.viewDice());
        DoubleMatrix2D tmp = matrix.like(matrix.rows() + aggr.length, matrix.columns());
        tmp.viewPart(0, 0, matrix.rows(), matrix.columns()).assign(matrix);
        tmp.viewPart(matrix.rows(), 0, aggr.length, matrix.columns()).assign(colStats);
        colStats = null;
        Object[][] s1 = this.format(tmp);
        this.align((String[][])s1);
        tmp = null;
        Object[][] s2 = this.format(rowStats);
        this.align((String[][])s2);
        rowStats = null;
        ObjectMatrix2D allStats = ObjectFactory2D.dense.make(matrix.rows() + aggr.length, matrix.columns() + aggr.length + 1);
        allStats.viewPart(0, 0, matrix.rows() + aggr.length, matrix.columns()).assign(s1);
        allStats.viewColumn(matrix.columns()).assign("|");
        allStats.viewPart(0, matrix.columns() + 1, matrix.rows(), aggr.length).assign(s2);
        s1 = null;
        s2 = null;
        if (columnNames != null) {
            list = new ObjectArrayList(columnNames);
            list.add("|");
            i = 0;
            while (i < aggr.length) {
                list.add(aggr[i].name());
                ++i;
            }
            columnNames = new String[list.size()];
            list.toArray(columnNames);
        }
        if (rowNames != null) {
            list = new ObjectArrayList(rowNames);
            i = 0;
            while (i < aggr.length) {
                list.add(aggr[i].name());
                ++i;
            }
            rowNames = new String[list.size()];
            list.toArray(rowNames);
        }
        String s = new ObjectFormatter().toTitleString(allStats, rowNames, columnNames, rowAxisName, columnAxisName, title);
        int secondLast = last = s.length() + 1;
        int v = Math.max(0, rowAxisName == null ? 0 : rowAxisName.length() - matrix.rows() - aggr.length);
        int k = 0;
        while (k < aggr.length + 1 + v) {
            secondLast = last;
            last = s.lastIndexOf(this.rowSeparator, last - 1);
            ++k;
        }
        StringBuffer buf = new StringBuffer(s);
        buf.insert(secondLast, String.valueOf(this.rowSeparator) + this.repeat('-', secondLast - last - 1));
        return buf.toString();
    }

    public String toTitleString(DoubleMatrix3D matrix, String[] sliceNames, String[] rowNames, String[] columnNames, String sliceAxisName, String rowAxisName, String columnAxisName, String title, DoubleBinFunction1D[] aggr) {
        if (matrix.size() == 0L) {
            return "Empty matrix";
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < matrix.slices()) {
            if (i != 0) {
                buf.append(this.sliceSeparator);
            }
            buf.append(this.toTitleString(matrix.viewSlice(i), rowNames, columnNames, rowAxisName, columnAxisName, String.valueOf(title) + "\n" + sliceAxisName + "=" + sliceNames[i], aggr));
            ++i;
        }
        return buf.toString();
    }

    private String xtoTitleString(DoubleMatrix3D matrix, String[] sliceNames, String[] rowNames, String[] columnNames, String sliceAxisName, String rowAxisName, String columnAxisName, String title) {
        if (matrix.size() == 0L) {
            return "Empty matrix";
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < matrix.slices()) {
            if (i != 0) {
                buf.append(this.sliceSeparator);
            }
            buf.append(this.toTitleString(matrix.viewSlice(i), rowNames, columnNames, rowAxisName, columnAxisName, String.valueOf(title) + "\n" + sliceAxisName + "=" + sliceNames[i]));
            ++i;
        }
        return buf.toString();
    }
}

