/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.array.Double1D;
import mitiv.array.DoubleScalar;
import mitiv.array.impl.Helper;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.DoubleFunction;
import mitiv.base.mapping.DoubleScanner;
import mitiv.random.DoubleGenerator;

public class SelectedDouble1D
extends Double1D {
    static final int order = 0;
    final double[] data;
    final int[] idx1;

    public SelectedDouble1D(double[] dArray, int[] nArray) {
        super(nArray.length);
        this.data = dArray;
        this.idx1 = nArray;
    }

    @Override
    public final void checkSanity() {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = n = this.idx1[0];
        for (int i = 1; i < this.dim1; ++i) {
            int n5 = this.idx1[i];
            if (n5 < n4) {
                n4 = n5;
            }
            if (n5 <= n) continue;
            n = n5;
        }
        if ((n2 += n4) < 0 || (n3 += n) >= this.data.length) {
            throw new IndexOutOfBoundsException("Selected indices are out of bounds");
        }
    }

    final int index(int n) {
        return this.idx1[n];
    }

    @Override
    public final double get(int n) {
        return this.data[this.idx1[n]];
    }

    @Override
    public final void set(int n, double d) {
        this.data[this.idx1[n]] = d;
    }

    @Override
    public final int getOrder() {
        return 0;
    }

    @Override
    public void fill(double d) {
        for (int i = 0; i < this.dim1; ++i) {
            int n = this.idx1[i];
            this.data[n] = d;
        }
    }

    @Override
    public void fill(DoubleGenerator doubleGenerator) {
        for (int i = 0; i < this.dim1; ++i) {
            int n = this.idx1[i];
            this.data[n] = doubleGenerator.nextDouble();
        }
    }

    @Override
    public void increment(double d) {
        for (int i = 0; i < this.dim1; ++i) {
            int n;
            int n2 = n = this.idx1[i];
            this.data[n2] = this.data[n2] + d;
        }
    }

    @Override
    public void decrement(double d) {
        for (int i = 0; i < this.dim1; ++i) {
            int n;
            int n2 = n = this.idx1[i];
            this.data[n2] = this.data[n2] - d;
        }
    }

    @Override
    public void scale(double d) {
        for (int i = 0; i < this.dim1; ++i) {
            int n;
            int n2 = n = this.idx1[i];
            this.data[n2] = this.data[n2] * d;
        }
    }

    @Override
    public void map(DoubleFunction doubleFunction) {
        for (int i = 0; i < this.dim1; ++i) {
            int n = this.idx1[i];
            this.data[n] = doubleFunction.apply(this.data[n]);
        }
    }

    @Override
    public void scan(DoubleScanner doubleScanner) {
        boolean bl = false;
        for (int i = 0; i < this.dim1; ++i) {
            int n = this.idx1[i];
            if (bl) {
                doubleScanner.update(this.data[n]);
                continue;
            }
            doubleScanner.initialize(this.data[n]);
            bl = true;
        }
    }

    @Override
    public final boolean isFlat() {
        return false;
    }

    @Override
    public double[] flatten(boolean bl) {
        double[] dArray = new double[this.number];
        int n = -1;
        for (int i = 0; i < this.dim1; ++i) {
            int n2 = this.idx1[i];
            dArray[++n] = this.data[n2];
        }
        return dArray;
    }

    @Override
    public double[] getData() {
        return null;
    }

    @Override
    public DoubleScalar slice(int n) {
        return new DoubleScalar(this.data, this.idx1[Helper.fixIndex(n, this.dim1)]);
    }

    @Override
    public DoubleScalar slice(int n, int n2) {
        Helper.fixSliceIndex(n2, 1);
        return new DoubleScalar(this.data, Helper.fixIndex(n, this.dim1));
    }

    @Override
    public Double1D view(Range range) {
        int[] nArray = Helper.select(this.idx1, range);
        if (nArray == this.idx1) {
            return this;
        }
        return new SelectedDouble1D(this.data, nArray);
    }

    @Override
    public Double1D view(int[] nArray) {
        int[] nArray2 = Helper.select(this.idx1, nArray);
        if (nArray2 == this.idx1) {
            return this;
        }
        return new SelectedDouble1D(this.data, nArray2);
    }

    @Override
    public Double1D as1D() {
        return this;
    }
}

