/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex.impl;

import cern.colt.ConcurrencyUtils;
import cern.colt.matrix.tdcomplex.DComplexMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.algo.DComplexProperty;
import cern.colt.matrix.tdcomplex.impl.DelegateDComplexMatrix1D;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix1D;
import cern.colt.matrix.tdcomplex.impl.DenseLargeDComplexMatrix2D;
import cern.colt.matrix.tdcomplex.impl.DiagonalDComplexMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DenseLargeDoubleMatrix2D;
import cern.jet.math.tdcomplex.DComplex;
import java.util.concurrent.Future;

public class WrapperDComplexMatrix2D
extends DComplexMatrix2D {
    private static final long serialVersionUID = 1L;
    protected DComplexMatrix2D content;

    public WrapperDComplexMatrix2D(DComplexMatrix2D newContent) {
        if (newContent != null) {
            this.setUp(newContent.rows(), newContent.columns());
        }
        this.content = newContent;
    }

    @Override
    public DComplexMatrix2D assign(final double[] values) {
        if (this.content instanceof DiagonalDComplexMatrix2D) {
            int dlength = ((DiagonalDComplexMatrix2D)this.content).dlength;
            final double[] elems = ((DiagonalDComplexMatrix2D)this.content).elements;
            if (values.length != 2 * dlength) {
                throw new IllegalArgumentException("Must have same length: length=" + values.length + " 2 * dlength=" + 2 * dlength);
            }
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads > 1 && dlength >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                nthreads = Math.min(nthreads, dlength);
                Future[] futures = new Future[nthreads];
                int k = dlength / nthreads;
                int j = 0;
                while (j < nthreads) {
                    final int firstIdx = j * k;
                    final int lastIdx = j == nthreads - 1 ? dlength : firstIdx + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            int i = firstIdx;
                            while (i < lastIdx) {
                                elems[2 * i] = values[2 * i];
                                elems[2 * i + 1] = values[2 * i + 1];
                                ++i;
                            }
                        }
                    });
                    ++j;
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                int i = 0;
                while (i < dlength) {
                    elems[2 * i] = values[2 * i];
                    elems[2 * i + 1] = values[2 * i + 1];
                    ++i;
                }
            }
            return this;
        }
        return super.assign(values);
    }

    @Override
    public DComplexMatrix2D assign(final float[] values) {
        if (this.content instanceof DiagonalDComplexMatrix2D) {
            int dlength = ((DiagonalDComplexMatrix2D)this.content).dlength;
            final double[] elems = ((DiagonalDComplexMatrix2D)this.content).elements;
            if (values.length != 2 * dlength) {
                throw new IllegalArgumentException("Must have same length: length=" + values.length + " 2 * dlength=" + 2 * dlength);
            }
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads > 1 && dlength >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                nthreads = Math.min(nthreads, dlength);
                Future[] futures = new Future[nthreads];
                int k = dlength / nthreads;
                int j = 0;
                while (j < nthreads) {
                    final int firstIdx = j * k;
                    final int lastIdx = j == nthreads - 1 ? dlength : firstIdx + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            int i = firstIdx;
                            while (i < lastIdx) {
                                elems[2 * i] = values[2 * i];
                                elems[2 * i + 1] = values[2 * i + 1];
                                ++i;
                            }
                        }
                    });
                    ++j;
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                int i = 0;
                while (i < dlength) {
                    elems[2 * i] = values[2 * i];
                    elems[2 * i + 1] = values[2 * i + 1];
                    ++i;
                }
            }
            return this;
        }
        return super.assign(values);
    }

    @Override
    public Object elements() {
        return this.content.elements();
    }

    @Override
    public boolean equals(double[] value) {
        if (this.content instanceof DiagonalDComplexMatrix2D) {
            double epsilon = DComplexProperty.DEFAULT.tolerance();
            double[] elements = (double[])this.content.elements();
            int dlength = ((DiagonalDComplexMatrix2D)this.content).dlength;
            double[] x = new double[2];
            double[] diff = new double[2];
            int i = 0;
            while (i < dlength) {
                x[0] = elements[2 * i];
                x[1] = elements[2 * i + 1];
                diff[0] = Math.abs(value[0] - x[0]);
                diff[1] = Math.abs(value[1] - x[1]);
                if (!((diff[0] == diff[0] && diff[1] == diff[1] || value[0] == value[0] && value[1] == value[1] || x[0] == x[0] && x[1] == x[1]) && !DComplex.isEqual(value, x, epsilon))) {
                    diff[0] = 0.0;
                    diff[1] = 0.0;
                }
                if (diff[0] > epsilon || diff[1] > epsilon) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return super.equals(value);
    }

    @Override
    public boolean equals(Object obj) {
        if (this.content instanceof DiagonalDComplexMatrix2D && obj instanceof DiagonalDComplexMatrix2D) {
            DiagonalDComplexMatrix2D other = (DiagonalDComplexMatrix2D)obj;
            int dlength = ((DiagonalDComplexMatrix2D)this.content).dlength;
            double epsilon = DComplexProperty.DEFAULT.tolerance();
            if (this == obj) {
                return true;
            }
            if (this == null || obj == null) {
                return false;
            }
            DiagonalDComplexMatrix2D A = (DiagonalDComplexMatrix2D)this.content;
            DiagonalDComplexMatrix2D B = (DiagonalDComplexMatrix2D)obj;
            if (A.columns() != B.columns() || A.rows() != B.rows() || A.diagonalIndex() != B.diagonalIndex() || A.diagonalLength() != B.diagonalLength()) {
                return false;
            }
            double[] otherElements = other.elements;
            double[] elements = ((DiagonalDComplexMatrix2D)this.content).elements;
            double[] x = new double[2];
            double[] value = new double[2];
            double[] diff = new double[2];
            int i = 0;
            while (i < dlength) {
                x[0] = elements[2 * i];
                x[1] = elements[2 * i + 1];
                value[0] = otherElements[2 * i];
                value[1] = otherElements[2 * i + 1];
                diff[0] = Math.abs(value[0] - x[0]);
                diff[1] = Math.abs(value[1] - x[1]);
                if (!((diff[0] == diff[0] && diff[1] == diff[1] || value[0] == value[0] && value[1] == value[1] || x[0] == x[0] && x[1] == x[1]) && !DComplex.isEqual(value, x, epsilon))) {
                    diff[0] = 0.0;
                    diff[1] = 0.0;
                }
                if (diff[0] > epsilon || diff[1] > epsilon) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return super.equals(obj);
    }

    @Override
    public synchronized double[] getQuick(int row, int column) {
        return this.content.getQuick(row, column);
    }

    @Override
    public DComplexMatrix2D like(int rows, int columns) {
        return this.content.like(rows, columns);
    }

    @Override
    public DComplexMatrix1D like1D(int size) {
        return this.content.like1D(size);
    }

    public void fft2() {
        if (this.content instanceof DenseLargeDComplexMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeDComplexMatrix2D)this.content).fft2();
            } else {
                DenseLargeDComplexMatrix2D copy = (DenseLargeDComplexMatrix2D)this.copy();
                copy.fft2();
                this.assign(copy);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void fftColumns() {
        if (this.content instanceof DenseLargeDComplexMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeDComplexMatrix2D)this.content).fftColumns();
            } else {
                DenseLargeDComplexMatrix2D copy = (DenseLargeDComplexMatrix2D)this.copy();
                copy.fftColumns();
                this.assign(copy);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void fftRows() {
        if (this.content instanceof DenseLargeDComplexMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeDComplexMatrix2D)this.content).fftRows();
            } else {
                DenseLargeDComplexMatrix2D copy = (DenseLargeDComplexMatrix2D)this.copy();
                copy.fftRows();
                this.assign(copy);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void ifftColumns(boolean scale) {
        if (this.content instanceof DenseLargeDComplexMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeDComplexMatrix2D)this.content).ifftColumns(scale);
            } else {
                DenseLargeDComplexMatrix2D copy = (DenseLargeDComplexMatrix2D)this.copy();
                copy.ifftColumns(scale);
                this.assign(copy);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void ifftRows(boolean scale) {
        if (this.content instanceof DenseLargeDComplexMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeDComplexMatrix2D)this.content).ifftRows(scale);
            } else {
                DenseLargeDComplexMatrix2D copy = (DenseLargeDComplexMatrix2D)this.copy();
                copy.ifftRows(scale);
                this.assign(copy);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void ifft2(boolean scale) {
        if (this.content instanceof DenseLargeDComplexMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeDComplexMatrix2D)this.content).ifft2(scale);
            } else {
                DenseLargeDComplexMatrix2D copy = (DenseLargeDComplexMatrix2D)this.copy();
                copy.ifft2(scale);
                this.assign(copy);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    @Override
    public synchronized void setQuick(int row, int column, double[] value) {
        this.content.setQuick(row, column, value);
    }

    @Override
    public synchronized void setQuick(int row, int column, double re, double im) {
        this.content.setQuick(row, column, re, im);
    }

    @Override
    public DComplexMatrix1D vectorize() {
        final DenseDComplexMatrix1D v = new DenseDComplexMatrix1D((int)this.size());
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = firstColumn * WrapperDComplexMatrix2D.this.rows;
                        int c = firstColumn;
                        while (c < lastColumn) {
                            int r = 0;
                            while (r < WrapperDComplexMatrix2D.this.rows) {
                                v.setQuick(idx++, WrapperDComplexMatrix2D.this.getQuick(r, c));
                                ++r;
                            }
                            ++c;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = 0;
            int c = 0;
            while (c < this.columns) {
                int r = 0;
                while (r < this.rows) {
                    v.setQuick(idx++, this.getQuick(r, c));
                    ++r;
                }
                ++c;
            }
        }
        return v;
    }

    @Override
    public DComplexMatrix1D viewColumn(int column) {
        return this.viewDice().viewRow(column);
    }

    @Override
    public DComplexMatrix2D viewColumnFlip() {
        if (this.columns == 0) {
            return this;
        }
        WrapperDComplexMatrix2D view = new WrapperDComplexMatrix2D(this){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized double[] getQuick(int row, int column) {
                return this.content.getQuick(row, this.columns - 1 - column);
            }

            @Override
            public synchronized void setQuick(int row, int column, double[] value) {
                this.content.setQuick(row, this.columns - 1 - column, value);
            }

            @Override
            public synchronized void setQuick(int row, int column, double re, double im) {
                this.content.setQuick(row, this.columns - 1 - column, re, im);
            }

            @Override
            public synchronized double[] get(int row, int column) {
                return this.content.get(row, this.columns - 1 - column);
            }

            @Override
            public synchronized void set(int row, int column, double[] value) {
                this.content.set(row, this.columns - 1 - column, value);
            }

            @Override
            public synchronized void set(int row, int column, double re, double im) {
                this.content.set(row, this.columns - 1 - column, re, im);
            }
        };
        view.isNoView = false;
        return view;
    }

    @Override
    public DComplexMatrix2D viewDice() {
        WrapperDComplexMatrix2D view = new WrapperDComplexMatrix2D(this){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized double[] getQuick(int row, int column) {
                return this.content.getQuick(column, row);
            }

            @Override
            public synchronized void setQuick(int row, int column, double[] value) {
                this.content.setQuick(column, row, value);
            }

            @Override
            public synchronized void setQuick(int row, int column, double re, double im) {
                this.content.setQuick(column, row, re, im);
            }

            @Override
            public synchronized double[] get(int row, int column) {
                return this.content.get(column, row);
            }

            @Override
            public synchronized void set(int row, int column, double[] value) {
                this.content.set(column, row, value);
            }

            @Override
            public synchronized void set(int row, int column, double re, double im) {
                this.content.set(column, row, re, im);
            }
        };
        view.rows = this.columns;
        view.columns = this.rows;
        view.isNoView = false;
        return view;
    }

    @Override
    public DComplexMatrix2D viewPart(final int row, final int column, int height, int width) {
        this.checkBox(row, column, height, width);
        WrapperDComplexMatrix2D view = new WrapperDComplexMatrix2D(this){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized double[] getQuick(int i, int j) {
                return this.content.getQuick(row + i, column + j);
            }

            @Override
            public synchronized void setQuick(int i, int j, double[] value) {
                this.content.setQuick(row + i, column + j, value);
            }

            @Override
            public synchronized void setQuick(int i, int j, double re, double im) {
                this.content.setQuick(row + i, column + j, re, im);
            }

            @Override
            public synchronized double[] get(int i, int j) {
                return this.content.get(row + i, column + j);
            }

            @Override
            public synchronized void set(int i, int j, double[] value) {
                this.content.set(row + i, column + j, value);
            }

            @Override
            public synchronized void set(int i, int j, double re, double im) {
                this.content.set(row + i, column + j, re, im);
            }
        };
        view.rows = height;
        view.columns = width;
        view.isNoView = false;
        return view;
    }

    @Override
    public DComplexMatrix1D viewRow(int row) {
        this.checkRow(row);
        return new DelegateDComplexMatrix1D(this, row);
    }

    @Override
    public DComplexMatrix2D viewRowFlip() {
        if (this.rows == 0) {
            return this;
        }
        WrapperDComplexMatrix2D view = new WrapperDComplexMatrix2D(this){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized double[] getQuick(int row, int column) {
                return this.content.getQuick(this.rows - 1 - row, column);
            }

            @Override
            public synchronized void setQuick(int row, int column, double[] value) {
                this.content.setQuick(this.rows - 1 - row, column, value);
            }

            @Override
            public synchronized void setQuick(int row, int column, double re, double im) {
                this.content.setQuick(this.rows - 1 - row, column, re, im);
            }

            @Override
            public synchronized double[] get(int row, int column) {
                return this.content.get(this.rows - 1 - row, column);
            }

            @Override
            public synchronized void set(int row, int column, double[] value) {
                this.content.set(this.rows - 1 - row, column, value);
            }

            @Override
            public synchronized void set(int row, int column, double re, double im) {
                this.content.set(this.rows - 1 - row, column, re, im);
            }
        };
        view.isNoView = false;
        return view;
    }

    @Override
    public DComplexMatrix2D viewSelection(int[] rowIndexes, int[] columnIndexes) {
        int i;
        if (rowIndexes == null) {
            rowIndexes = new int[this.rows];
            i = this.rows;
            while (--i >= 0) {
                rowIndexes[i] = i;
            }
        }
        if (columnIndexes == null) {
            columnIndexes = new int[this.columns];
            i = this.columns;
            while (--i >= 0) {
                columnIndexes[i] = i;
            }
        }
        this.checkRowIndexes(rowIndexes);
        this.checkColumnIndexes(columnIndexes);
        final int[] rix = rowIndexes;
        final int[] cix = columnIndexes;
        WrapperDComplexMatrix2D view = new WrapperDComplexMatrix2D(this){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized double[] getQuick(int i, int j) {
                return this.content.getQuick(rix[i], cix[j]);
            }

            @Override
            public synchronized void setQuick(int i, int j, double[] value) {
                this.content.setQuick(rix[i], cix[j], value);
            }

            @Override
            public synchronized void setQuick(int i, int j, double re, double im) {
                this.content.setQuick(rix[i], cix[j], re, im);
            }

            @Override
            public synchronized double[] get(int i, int j) {
                return this.content.get(rix[i], cix[j]);
            }

            @Override
            public synchronized void set(int i, int j, double[] value) {
                this.content.set(rix[i], cix[j], value);
            }

            @Override
            public synchronized void set(int i, int j, double re, double im) {
                this.content.set(rix[i], cix[j], re, im);
            }
        };
        view.rows = rowIndexes.length;
        view.columns = columnIndexes.length;
        view.isNoView = false;
        return view;
    }

    @Override
    public DComplexMatrix2D viewStrides(final int _rowStride, final int _columnStride) {
        if (_rowStride <= 0 || _columnStride <= 0) {
            throw new IndexOutOfBoundsException("illegal stride");
        }
        WrapperDComplexMatrix2D view = new WrapperDComplexMatrix2D(this){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized double[] getQuick(int row, int column) {
                return this.content.getQuick(_rowStride * row, _columnStride * column);
            }

            @Override
            public synchronized void setQuick(int row, int column, double[] value) {
                this.content.setQuick(_rowStride * row, _columnStride * column, value);
            }

            @Override
            public synchronized void setQuick(int row, int column, double re, double im) {
                this.content.setQuick(_rowStride * row, _columnStride * column, re, im);
            }

            @Override
            public synchronized double[] get(int row, int column) {
                return this.content.get(_rowStride * row, _columnStride * column);
            }

            @Override
            public synchronized void set(int row, int column, double[] value) {
                this.content.set(_rowStride * row, _columnStride * column, value);
            }

            @Override
            public synchronized void set(int row, int column, double re, double im) {
                this.content.set(_rowStride * row, _columnStride * column, re, im);
            }
        };
        if (this.rows != 0) {
            view.rows = (this.rows - 1) / _rowStride + 1;
        }
        if (this.columns != 0) {
            view.columns = (this.columns - 1) / _columnStride + 1;
        }
        view.isNoView = false;
        return view;
    }

    @Override
    protected DComplexMatrix2D getContent() {
        return this.content;
    }

    @Override
    protected DComplexMatrix1D like1D(int size, int offset, int stride) {
        throw new InternalError();
    }

    @Override
    protected DComplexMatrix2D viewSelectionLike(int[] rowOffsets, int[] columnOffsets) {
        throw new InternalError();
    }

    @Override
    public DoubleMatrix2D getImaginaryPart() {
        final DenseLargeDoubleMatrix2D Im = new DenseLargeDoubleMatrix2D(this.rows, this.columns);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = 0;
                            while (c < WrapperDComplexMatrix2D.this.columns) {
                                Im.setQuick(r, c, WrapperDComplexMatrix2D.this.getQuick(r, c)[1]);
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int r = 0;
            while (r < this.rows) {
                int c = 0;
                while (c < this.columns) {
                    Im.setQuick(r, c, this.getQuick(r, c)[1]);
                    ++c;
                }
                ++r;
            }
        }
        return Im;
    }

    @Override
    public DoubleMatrix2D getRealPart() {
        final DenseLargeDoubleMatrix2D Re = new DenseLargeDoubleMatrix2D(this.rows, this.columns);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = 0;
                            while (c < WrapperDComplexMatrix2D.this.columns) {
                                Re.setQuick(r, c, WrapperDComplexMatrix2D.this.getQuick(r, c)[0]);
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int r = 0;
            while (r < this.rows) {
                int c = 0;
                while (c < this.columns) {
                    Re.setQuick(r, c, this.getQuick(r, c)[0]);
                    ++c;
                }
                ++r;
            }
        }
        return Re;
    }
}

