/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.hssf.record;

import java.util.ArrayList;
import loci.poi.hssf.record.Record;
import loci.poi.hssf.record.RecordFormatException;
import loci.poi.hssf.record.RecordInputStream;
import loci.poi.util.LittleEndian;

public class SelectionRecord
extends Record {
    public static final short sid = 29;
    private byte field_1_pane;
    private int field_2_row_active_cell;
    private short field_3_col_active_cell;
    private short field_4_ref_active_cell;
    private short field_5_num_refs;
    private ArrayList field_6_refs;

    public SelectionRecord() {
    }

    public SelectionRecord(RecordInputStream in) {
        super(in);
    }

    @Override
    protected void validateSid(short id) {
        if (id != 29) {
            throw new RecordFormatException("NOT A valid Selection RECORD");
        }
    }

    @Override
    protected void fillFields(RecordInputStream in) {
        this.field_1_pane = in.readByte();
        this.field_2_row_active_cell = in.readUShort();
        this.field_3_col_active_cell = in.readShort();
        this.field_4_ref_active_cell = in.readShort();
        this.field_5_num_refs = in.readShort();
        this.field_6_refs = new ArrayList(this.field_5_num_refs);
        for (int i = 0; i < this.field_5_num_refs; ++i) {
            this.field_6_refs.add(new Reference(in));
        }
    }

    public void setPane(byte pane) {
        this.field_1_pane = pane;
    }

    public void setActiveCellRow(int row) {
        this.field_2_row_active_cell = row;
    }

    public void setActiveCellCol(short col) {
        this.field_3_col_active_cell = col;
    }

    public void setActiveCellRef(short ref) {
        this.field_4_ref_active_cell = ref;
    }

    public void setNumRefs(short refs) {
        this.field_5_num_refs = refs;
    }

    public byte getPane() {
        return this.field_1_pane;
    }

    public int getActiveCellRow() {
        return this.field_2_row_active_cell;
    }

    public short getActiveCellCol() {
        return this.field_3_col_active_cell;
    }

    public short getActiveCellRef() {
        return this.field_4_ref_active_cell;
    }

    public short getNumRefs() {
        return this.field_5_num_refs;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[SELECTION]\n");
        buffer.append("    .pane            = ").append(Integer.toHexString(this.getPane())).append("\n");
        buffer.append("    .activecellrow   = ").append(Integer.toHexString(this.getActiveCellRow())).append("\n");
        buffer.append("    .activecellcol   = ").append(Integer.toHexString(this.getActiveCellCol())).append("\n");
        buffer.append("    .activecellref   = ").append(Integer.toHexString(this.getActiveCellRef())).append("\n");
        buffer.append("    .numrefs         = ").append(Integer.toHexString(this.getNumRefs())).append("\n");
        buffer.append("[/SELECTION]\n");
        return buffer.toString();
    }

    @Override
    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)29);
        LittleEndian.putShort(data, 2 + offset, (short)15);
        data[4 + offset] = this.getPane();
        LittleEndian.putShort(data, 5 + offset, (short)this.getActiveCellRow());
        LittleEndian.putShort(data, 7 + offset, this.getActiveCellCol());
        LittleEndian.putShort(data, 9 + offset, this.getActiveCellRef());
        LittleEndian.putShort(data, 11 + offset, (short)1);
        LittleEndian.putShort(data, 13 + offset, (short)this.getActiveCellRow());
        LittleEndian.putShort(data, 15 + offset, (short)this.getActiveCellRow());
        data[17 + offset] = (byte)this.getActiveCellCol();
        data[18 + offset] = (byte)this.getActiveCellCol();
        return this.getRecordSize();
    }

    @Override
    public int getRecordSize() {
        return 19;
    }

    @Override
    public short getSid() {
        return 29;
    }

    @Override
    public Object clone() {
        SelectionRecord rec = new SelectionRecord();
        rec.field_1_pane = this.field_1_pane;
        rec.field_2_row_active_cell = this.field_2_row_active_cell;
        rec.field_3_col_active_cell = this.field_3_col_active_cell;
        rec.field_4_ref_active_cell = this.field_4_ref_active_cell;
        rec.field_5_num_refs = this.field_5_num_refs;
        rec.field_6_refs = this.field_6_refs;
        return rec;
    }

    public class Reference {
        private short field_1_first_row;
        private short field_2_last_row;
        private byte field_3_first_column;
        private byte field_4_last_column;

        Reference(RecordInputStream in) {
            this.field_1_first_row = in.readShort();
            this.field_2_last_row = in.readShort();
            this.field_3_first_column = in.readByte();
            this.field_4_last_column = in.readByte();
        }

        public short getFirstRow() {
            return this.field_1_first_row;
        }

        public short getLastRow() {
            return this.field_2_last_row;
        }

        public byte getFirstColumn() {
            return this.field_3_first_column;
        }

        public byte getLastColumn() {
            return this.field_4_last_column;
        }
    }
}

