/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array3D;
import mitiv.array.Byte3D;
import mitiv.array.Double1D;
import mitiv.array.Double2D;
import mitiv.array.DoubleArray;
import mitiv.array.Float3D;
import mitiv.array.Int3D;
import mitiv.array.Long3D;
import mitiv.array.ShapedArray;
import mitiv.array.Short3D;
import mitiv.array.impl.FlatDouble3D;
import mitiv.array.impl.StriddenDouble3D;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.DoubleFunction;
import mitiv.base.mapping.DoubleScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.DoubleGenerator;

public abstract class Double3D
extends Array3D
implements DoubleArray {
    protected Double3D(int n, int n2, int n3) {
        super(n, n2, n3);
    }

    protected Double3D(int[] nArray) {
        super(nArray);
    }

    protected Double3D(Shape shape) {
        super(shape);
    }

    @Override
    public final int getType() {
        return 5;
    }

    public abstract double get(int var1, int var2, int var3);

    public abstract void set(int var1, int var2, int var3, double var4);

    @Override
    public void fill(double d) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        this.set(i, j, k, d);
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        this.set(k, j, i, d);
                    }
                }
            }
        }
    }

    @Override
    public void increment(double d) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        this.set(i, j, k, this.get(i, j, k) + d);
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        this.set(k, j, i, this.get(k, j, i) + d);
                    }
                }
            }
        }
    }

    @Override
    public void decrement(double d) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        this.set(i, j, k, this.get(i, j, k) - d);
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        this.set(k, j, i, this.get(k, j, i) - d);
                    }
                }
            }
        }
    }

    @Override
    public void scale(double d) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        this.set(i, j, k, this.get(i, j, k) * d);
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        this.set(k, j, i, this.get(k, j, i) * d);
                    }
                }
            }
        }
    }

    @Override
    public void map(DoubleFunction doubleFunction) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        this.set(i, j, k, doubleFunction.apply(this.get(i, j, k)));
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        this.set(k, j, i, doubleFunction.apply(this.get(k, j, i)));
                    }
                }
            }
        }
    }

    @Override
    public void fill(DoubleGenerator doubleGenerator) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        this.set(i, j, k, doubleGenerator.nextDouble());
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        this.set(k, j, i, doubleGenerator.nextDouble());
                    }
                }
            }
        }
    }

    @Override
    public void scan(DoubleScanner doubleScanner) {
        boolean bl = false;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        if (bl) {
                            doubleScanner.update(this.get(i, j, k));
                            continue;
                        }
                        doubleScanner.initialize(this.get(i, j, k));
                        bl = true;
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        if (bl) {
                            doubleScanner.update(this.get(k, j, i));
                            continue;
                        }
                        doubleScanner.initialize(this.get(k, j, i));
                        bl = true;
                    }
                }
            }
        }
    }

    @Override
    public final double[] flatten() {
        return this.flatten(false);
    }

    @Override
    public double min() {
        double d = this.get(0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        if (bl) {
                            bl = false;
                            continue;
                        }
                        double d2 = this.get(i, j, k);
                        if (!(d2 < d)) continue;
                        d = d2;
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        if (bl) {
                            bl = false;
                            continue;
                        }
                        double d3 = this.get(k, j, i);
                        if (!(d3 < d)) continue;
                        d = d3;
                    }
                }
            }
        }
        return d;
    }

    @Override
    public double max() {
        double d = this.get(0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        if (bl) {
                            bl = false;
                            continue;
                        }
                        double d2 = this.get(i, j, k);
                        if (!(d2 > d)) continue;
                        d = d2;
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        if (bl) {
                            bl = false;
                            continue;
                        }
                        double d3 = this.get(k, j, i);
                        if (!(d3 > d)) continue;
                        d = d3;
                    }
                }
            }
        }
        return d;
    }

    @Override
    public double[] getMinAndMax() {
        double[] dArray = new double[2];
        this.getMinAndMax(dArray);
        return dArray;
    }

    @Override
    public void getMinAndMax(double[] dArray) {
        double d;
        double d2 = d = this.get(0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        if (bl) {
                            bl = false;
                            continue;
                        }
                        double d3 = this.get(i, j, k);
                        if (d3 < d) {
                            d = d3;
                        }
                        if (!(d3 > d2)) continue;
                        d2 = d3;
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        if (bl) {
                            bl = false;
                            continue;
                        }
                        double d4 = this.get(k, j, i);
                        if (d4 < d) {
                            d = d4;
                        }
                        if (!(d4 > d2)) continue;
                        d2 = d4;
                    }
                }
            }
        }
        dArray[0] = d;
        dArray[1] = d2;
    }

    @Override
    public double sum() {
        double d = 0.0;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        d += this.get(i, j, k);
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        d += this.get(k, j, i);
                    }
                }
            }
        }
        return d;
    }

    @Override
    public double average() {
        return this.sum() / (double)this.number;
    }

    @Override
    public Byte3D toByte() {
        byte[] byArray = new byte[this.number];
        if (this.isFlat()) {
            double[] dArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                byArray[i] = (byte)dArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        byArray[++n] = (byte)this.get(k, j, i);
                    }
                }
            }
        }
        return Byte3D.wrap(byArray, this.getShape());
    }

    @Override
    public Short3D toShort() {
        short[] sArray = new short[this.number];
        if (this.isFlat()) {
            double[] dArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                sArray[i] = (short)dArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        sArray[++n] = (short)this.get(k, j, i);
                    }
                }
            }
        }
        return Short3D.wrap(sArray, this.getShape());
    }

    @Override
    public Int3D toInt() {
        int[] nArray = new int[this.number];
        if (this.isFlat()) {
            double[] dArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                nArray[i] = (int)dArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        nArray[++n] = (int)this.get(k, j, i);
                    }
                }
            }
        }
        return Int3D.wrap(nArray, this.getShape());
    }

    @Override
    public Long3D toLong() {
        long[] lArray = new long[this.number];
        if (this.isFlat()) {
            double[] dArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                lArray[i] = (long)dArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        lArray[++n] = (long)this.get(k, j, i);
                    }
                }
            }
        }
        return Long3D.wrap(lArray, this.getShape());
    }

    @Override
    public Float3D toFloat() {
        float[] fArray = new float[this.number];
        if (this.isFlat()) {
            double[] dArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                fArray[i] = (float)dArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        fArray[++n] = (float)this.get(k, j, i);
                    }
                }
            }
        }
        return Float3D.wrap(fArray, this.getShape());
    }

    @Override
    public Double3D toDouble() {
        return this;
    }

    @Override
    public Double3D copy() {
        return new FlatDouble3D(this.flatten(true), this.shape);
    }

    @Override
    public void assign(ShapedArray shapedArray) {
        if (!this.getShape().equals(shapedArray.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        Double3D double3D = shapedArray.getType() == 5 ? (Double3D)shapedArray : (Double3D)shapedArray.toDouble();
        if (this.getOrder() == 2 && double3D.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        this.set(i, j, k, double3D.get(i, j, k));
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        this.set(k, j, i, double3D.get(k, j, i));
                    }
                }
            }
        }
    }

    @Override
    public void assign(ShapedVector shapedVector) {
        if (!this.getShape().equals(shapedVector.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        int n = -1;
        if (shapedVector.getType() == 5) {
            DoubleShapedVector doubleShapedVector = (DoubleShapedVector)shapedVector;
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        this.set(k, j, i, doubleShapedVector.get(++n));
                    }
                }
            }
        } else if (shapedVector.getType() == 4) {
            FloatShapedVector floatShapedVector = (FloatShapedVector)shapedVector;
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        this.set(k, j, i, floatShapedVector.get(++n));
                    }
                }
            }
        } else {
            throw new IllegalTypeException();
        }
    }

    @Override
    public Double3D create() {
        return new FlatDouble3D(this.getShape());
    }

    public static Double3D create(int n, int n2, int n3) {
        return new FlatDouble3D(n, n2, n3);
    }

    public static Double3D create(int[] nArray) {
        return new FlatDouble3D(nArray);
    }

    public static Double3D create(Shape shape) {
        return new FlatDouble3D(shape);
    }

    public static Double3D wrap(double[] dArray, int n, int n2, int n3) {
        return new FlatDouble3D(dArray, n, n2, n3);
    }

    public static Double3D wrap(double[] dArray, int[] nArray) {
        return new FlatDouble3D(dArray, nArray);
    }

    public static Double3D wrap(double[] dArray, Shape shape) {
        return new FlatDouble3D(dArray, shape);
    }

    public static Double3D wrap(double[] dArray, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return new StriddenDouble3D(dArray, n, n2, n3, n4, n5, n6, n7);
    }

    @Override
    public abstract Double2D slice(int var1);

    @Override
    public abstract Double2D slice(int var1, int var2);

    @Override
    public abstract Double3D view(Range var1, Range var2, Range var3);

    @Override
    public abstract Double3D view(int[] var1, int[] var2, int[] var3);

    @Override
    public abstract Double1D as1D();
}

