/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.array.Int1D;
import mitiv.array.Int2D;
import mitiv.array.impl.FlatInt1D;
import mitiv.array.impl.Helper;
import mitiv.array.impl.SelectedInt2D;
import mitiv.array.impl.StriddenInt1D;
import mitiv.array.impl.StriddenInt2D;
import mitiv.base.Shape;
import mitiv.base.indexing.CompiledRange;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.IntFunction;
import mitiv.base.mapping.IntScanner;
import mitiv.exception.NonConformableArrayException;
import mitiv.random.IntGenerator;

public class FlatInt2D
extends Int2D {
    static final int order = 1;
    final int[] data;

    public FlatInt2D(int n, int n2) {
        super(n, n2);
        this.data = new int[this.number];
    }

    public FlatInt2D(int[] nArray) {
        super(nArray);
        this.data = new int[this.number];
    }

    public FlatInt2D(Shape shape) {
        super(shape);
        this.data = new int[this.number];
    }

    public FlatInt2D(int[] nArray, int n, int n2) {
        super(n, n2);
        this.checkSize(nArray);
        this.data = nArray;
    }

    public FlatInt2D(int[] nArray, int[] nArray2) {
        super(nArray2);
        this.checkSize(nArray);
        this.data = nArray;
    }

    public FlatInt2D(int[] nArray, Shape shape) {
        super(shape);
        this.checkSize(nArray);
        this.data = nArray;
    }

    @Override
    public void checkSanity() {
        if (this.data == null) {
            throw new NonConformableArrayException("Wrapped array is null");
        }
        if (this.data.length < this.number) {
            throw new NonConformableArrayException("Wrapped array is too small");
        }
    }

    private void checkSize(int[] nArray) {
        if (nArray == null || nArray.length < this.number) {
            throw new NonConformableArrayException("Wrapped array is too small");
        }
    }

    final int index(int n, int n2) {
        return this.dim1 * n2 + n;
    }

    @Override
    public final int get(int n, int n2) {
        return this.data[this.dim1 * n2 + n];
    }

    @Override
    public final void set(int n, int n2, int n3) {
        this.data[this.dim1 * n2 + n] = n3;
    }

    @Override
    public final int getOrder() {
        return 1;
    }

    @Override
    public void fill(int n) {
        for (int i = 0; i < this.number; ++i) {
            this.data[i] = n;
        }
    }

    @Override
    public void fill(IntGenerator intGenerator) {
        for (int i = 0; i < this.number; ++i) {
            this.data[i] = intGenerator.nextInt();
        }
    }

    @Override
    public void increment(int n) {
        int n2 = 0;
        while (n2 < this.number) {
            int n3 = n2++;
            this.data[n3] = this.data[n3] + n;
        }
    }

    @Override
    public void decrement(int n) {
        int n2 = 0;
        while (n2 < this.number) {
            int n3 = n2++;
            this.data[n3] = this.data[n3] - n;
        }
    }

    @Override
    public void scale(int n) {
        int n2 = 0;
        while (n2 < this.number) {
            int n3 = n2++;
            this.data[n3] = this.data[n3] * n;
        }
    }

    @Override
    public void map(IntFunction intFunction) {
        for (int i = 0; i < this.number; ++i) {
            this.data[i] = intFunction.apply(this.data[i]);
        }
    }

    @Override
    public void scan(IntScanner intScanner) {
        intScanner.initialize(this.data[0]);
        for (int i = 1; i < this.number; ++i) {
            intScanner.update(this.data[i]);
        }
    }

    @Override
    public final boolean isFlat() {
        return true;
    }

    @Override
    public int[] flatten(boolean bl) {
        if (bl) {
            int[] nArray = new int[this.number];
            System.arraycopy(this.data, 0, nArray, 0, this.number);
            return nArray;
        }
        return this.data;
    }

    @Override
    public int[] getData() {
        return this.data;
    }

    @Override
    public Int1D slice(int n) {
        if ((n = Helper.fixIndex(n, this.dim2)) == 0) {
            return new FlatInt1D(this.data, this.dim1);
        }
        return new StriddenInt1D(this.data, this.dim1 * n, 1, this.dim1);
    }

    @Override
    public Int1D slice(int n, int n2) {
        int n3;
        int n4;
        int n5;
        if ((n2 = Helper.fixSliceIndex(n2, 2)) == 0) {
            n5 = Helper.fixIndex(n, this.dim1);
            n4 = this.dim1;
            n3 = this.dim2;
        } else {
            n5 = this.dim1 * Helper.fixIndex(n, this.dim2);
            n4 = 1;
            n3 = this.dim1;
        }
        return new StriddenInt1D(this.data, n5, n4, n3);
    }

    @Override
    public Int2D view(Range range, Range range2) {
        CompiledRange compiledRange = new CompiledRange(range, this.dim1, 0, 1);
        CompiledRange compiledRange2 = new CompiledRange(range2, this.dim2, 0, this.dim1);
        if (compiledRange.doesNothing() && compiledRange2.doesNothing()) {
            return this;
        }
        return new StriddenInt2D(this.data, compiledRange.getOffset() + compiledRange2.getOffset(), compiledRange.getStride(), compiledRange2.getStride(), compiledRange.getNumber(), compiledRange2.getNumber());
    }

    @Override
    public Int2D view(int[] nArray, int[] nArray2) {
        int[] nArray3 = Helper.select(0, 1, this.dim1, nArray);
        int[] nArray4 = Helper.select(0, this.dim1, this.dim2, nArray2);
        return new SelectedInt2D(this.data, nArray3, nArray4);
    }

    @Override
    public Int1D as1D() {
        return new FlatInt1D(this.data, this.number);
    }
}

