/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point;

import java.util.Date;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.units.DateUnit;
import ucar.unidata.geoloc.EarthLocation;

public abstract class PointFeatureImpl
implements PointFeature,
Comparable<PointFeature> {
    protected EarthLocation location;
    protected double obsTime;
    protected double nomTime;
    protected DateUnit timeUnit;

    public PointFeatureImpl(DateUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public PointFeatureImpl(EarthLocation location, double obsTime, double nomTime, DateUnit timeUnit) {
        this.location = location;
        this.obsTime = obsTime;
        this.nomTime = nomTime == 0.0 ? obsTime : nomTime;
        this.timeUnit = timeUnit;
    }

    @Override
    public EarthLocation getLocation() {
        return this.location;
    }

    @Override
    public double getNominalTime() {
        return this.nomTime;
    }

    @Override
    public double getObservationTime() {
        return this.obsTime;
    }

    public String getZcoordUnits() {
        return "meters";
    }

    public String getDescription() {
        return this.location.toString();
    }

    @Override
    public Date getObservationTimeAsDate() {
        return this.timeUnit.makeDate(this.getObservationTime());
    }

    @Override
    public Date getNominalTimeAsDate() {
        return this.timeUnit.makeDate(this.getNominalTime());
    }

    @Override
    public CalendarDate getObservationTimeAsCalendarDate() {
        return this.timeUnit.makeCalendarDate(this.getObservationTime());
    }

    @Override
    public CalendarDate getNominalTimeAsCalendarDate() {
        return this.timeUnit.makeCalendarDate(this.getNominalTime());
    }

    @Override
    public DateUnit getTimeUnit() {
        return this.timeUnit;
    }

    @Override
    public int compareTo(PointFeature other) {
        if (this.obsTime < other.getObservationTime()) {
            return -1;
        }
        if (this.obsTime > other.getObservationTime()) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return "PointFeatureImpl{location=" + this.location + ", obsTime=" + this.obsTime + ", nomTime=" + this.nomTime + ", timeUnit=" + this.timeUnit + '}';
    }
}

