/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.codec;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.common.services.DependencyException;
import loci.common.services.ServiceFactory;
import loci.formats.FormatException;
import loci.formats.MissingLibraryException;
import loci.formats.UnsupportedCompressionException;
import loci.formats.codec.BaseCodec;
import loci.formats.codec.CodecOptions;
import loci.formats.services.JPEGXRService;

public class JPEGXRCodec
extends BaseCodec {
    private JPEGXRService service;

    @Override
    public byte[] compress(byte[] data, CodecOptions options) throws FormatException {
        throw new UnsupportedCompressionException("JPEG-XR compression not supported");
    }

    @Override
    public byte[] decompress(RandomAccessInputStream in, CodecOptions options) throws FormatException, IOException {
        byte[] buf = new byte[(int)in.length()];
        in.read(buf);
        return this.decompress(buf, options);
    }

    @Override
    public byte[] decompress(byte[] buf, CodecOptions options) throws FormatException {
        this.initialize();
        return this.service.decompress(buf);
    }

    private void initialize() throws FormatException {
        if (this.service != null) {
            return;
        }
        try {
            ServiceFactory factory = new ServiceFactory();
            this.service = factory.getInstance(JPEGXRService.class);
        }
        catch (DependencyException e) {
            throw new MissingLibraryException("JPEG-XR library not available", e);
        }
    }
}

