/*
 * Decompiled with CFR 0.152.
 */
package mitiv.deconv;

import mitiv.array.ShapedArray;
import mitiv.base.Shape;
import mitiv.cost.DifferentiableCostFunction;
import mitiv.cost.WeightedData;
import mitiv.deconv.Convolution;
import mitiv.deconv.ConvolutionDouble1D;
import mitiv.deconv.ConvolutionDouble2D;
import mitiv.deconv.ConvolutionDouble3D;
import mitiv.deconv.ConvolutionFloat1D;
import mitiv.deconv.ConvolutionFloat2D;
import mitiv.deconv.ConvolutionFloat3D;
import mitiv.deconv.WeightedConvolutionDouble1D;
import mitiv.deconv.WeightedConvolutionDouble2D;
import mitiv.deconv.WeightedConvolutionDouble3D;
import mitiv.deconv.WeightedConvolutionFloat1D;
import mitiv.deconv.WeightedConvolutionFloat2D;
import mitiv.deconv.WeightedConvolutionFloat3D;
import mitiv.exception.IllegalTypeException;
import mitiv.linalg.Vector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.linalg.shaped.ShapedVectorSpace;
import mitiv.utils.Timer;

public abstract class WeightedConvolutionCost
extends WeightedData
implements DifferentiableCostFunction {
    protected final ShapedVectorSpace objectSpace;
    protected Timer timerForFFT = new Timer();
    protected Timer timer = new Timer();

    protected WeightedConvolutionCost(ShapedVectorSpace shapedVectorSpace, ShapedVectorSpace shapedVectorSpace2) {
        super(shapedVectorSpace2);
        this.objectSpace = shapedVectorSpace;
    }

    public ShapedVectorSpace getObjectSpace() {
        return this.objectSpace;
    }

    @Override
    public ShapedVectorSpace getInputSpace() {
        return this.objectSpace;
    }

    public static WeightedConvolutionCost build(Convolution convolution) {
        switch (convolution.getType()) {
            case 4: {
                switch (convolution.getRank()) {
                    case 1: {
                        return new WeightedConvolutionFloat1D((ConvolutionFloat1D)convolution);
                    }
                    case 2: {
                        return new WeightedConvolutionFloat2D((ConvolutionFloat2D)convolution);
                    }
                    case 3: {
                        return new WeightedConvolutionFloat3D((ConvolutionFloat3D)convolution);
                    }
                }
                break;
            }
            case 5: {
                switch (convolution.getRank()) {
                    case 1: {
                        return new WeightedConvolutionDouble1D((ConvolutionDouble1D)convolution);
                    }
                    case 2: {
                        return new WeightedConvolutionDouble2D((ConvolutionDouble2D)convolution);
                    }
                    case 3: {
                        return new WeightedConvolutionDouble3D((ConvolutionDouble3D)convolution);
                    }
                }
                break;
            }
            default: {
                throw new IllegalTypeException("Only float and double types are implemented");
            }
        }
        throw new IllegalArgumentException("Only 1D, 2D and 3D convolution are implemented");
    }

    public static WeightedConvolutionCost build(ShapedVectorSpace shapedVectorSpace) {
        return WeightedConvolutionCost.build(Convolution.build(shapedVectorSpace));
    }

    public static WeightedConvolutionCost build(ShapedVectorSpace shapedVectorSpace, ShapedVectorSpace shapedVectorSpace2) {
        return WeightedConvolutionCost.build(Convolution.build(shapedVectorSpace, shapedVectorSpace2));
    }

    public static WeightedConvolutionCost build(Shape shape, ShapedVectorSpace shapedVectorSpace, ShapedVectorSpace shapedVectorSpace2) {
        return WeightedConvolutionCost.build(Convolution.build(shape, shapedVectorSpace, shapedVectorSpace2));
    }

    public static WeightedConvolutionCost build(Shape shape, ShapedVectorSpace shapedVectorSpace, int[] nArray, ShapedVectorSpace shapedVectorSpace2, int[] nArray2) {
        return WeightedConvolutionCost.build(Convolution.build(shape, shapedVectorSpace, nArray, shapedVectorSpace2, nArray2));
    }

    private final void checkObject(Vector vector) {
        if (!vector.belongsTo(this.objectSpace)) {
            throw new IllegalArgumentException("Variables X does not belong to the object space");
        }
    }

    private final void checkGradient(Vector vector) {
        if (!vector.belongsTo(this.objectSpace)) {
            throw new IllegalArgumentException("Gradient GX does not belong to the object space");
        }
    }

    @Override
    public double evaluate(double d, Vector vector) {
        this.checkObject(vector);
        if (d == 0.0) {
            return 0.0;
        }
        return this._cost(d, vector);
    }

    @Override
    public double computeCostAndGradient(double d, Vector vector, Vector vector2, boolean bl) {
        this.checkObject(vector);
        this.checkGradient(vector2);
        if (d == 0.0) {
            if (bl) {
                vector2.zero();
            }
            return 0.0;
        }
        return this._cost(d, vector, vector2, bl);
    }

    protected abstract double _cost(double var1, Vector var3);

    protected abstract double _cost(double var1, Vector var3, Vector var4, boolean var5);

    public abstract void setPSF(ShapedVector var1);

    public void setPSF(ShapedArray shapedArray) {
        this.setPSF(shapedArray, null, false);
    }

    public void setPSF(ShapedArray shapedArray, int[] nArray) {
        this.setPSF(shapedArray, nArray, false);
    }

    public void setPSF(ShapedArray shapedArray, boolean bl) {
        this.setPSF(shapedArray, null, bl);
    }

    public abstract void setPSF(ShapedArray var1, int[] var2, boolean var3);

    protected static int outputOffset(int n, Shape shape, Shape shape2, int[] nArray) {
        if (shape.rank() != n) {
            throw new IllegalArgumentException("Bad rank for input space");
        }
        if (shape2.rank() != n) {
            throw new IllegalArgumentException("Bad rank for output space");
        }
        if (nArray != null && nArray.length != n) {
            throw new IllegalArgumentException("Bad number of coordinates for the first position");
        }
        int n2 = 0;
        int n3 = 1;
        for (int i = 0; i < n; ++i) {
            int n4;
            int n5 = shape.dimension(i);
            int n6 = shape2.dimension(i);
            if (n6 > n5) {
                throw new IllegalArgumentException("Output dimensions must be at most as large as input dimensions");
            }
            if (nArray == null) {
                n4 = n5 / 2 - n6 / 2;
            } else {
                n4 = nArray[i];
                if (n4 < 0 || n4 + n6 > n5) {
                    throw new IllegalArgumentException("Output region is outside bounds");
                }
            }
            n2 += n3 * n4;
            n3 *= n5;
        }
        return n2;
    }

    public void resetTimers() {
        this.timerForFFT.stop();
        this.timerForFFT.reset();
        this.timer.stop();
        this.timer.reset();
    }

    public double getElapsedTime() {
        return this.timer.getElapsedTime();
    }

    public double getElapsedTimeInFFT() {
        return this.timerForFFT.getElapsedTime();
    }
}

