/*
 * Decompiled with CFR 0.152.
 */
package mitiv.deconv;

import mitiv.array.ArrayUtils;
import mitiv.array.FloatArray;
import mitiv.array.ShapedArray;
import mitiv.base.Shape;
import mitiv.deconv.Convolution;
import mitiv.exception.IncorrectSpaceException;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.FloatShapedVectorSpace;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.linalg.shaped.ShapedVectorSpace;

abstract class ConvolutionFloat
extends Convolution {
    private float[] wrk = null;
    private float[] mtf = null;

    protected ConvolutionFloat(Shape shape, ShapedVectorSpace shapedVectorSpace, int[] nArray, ShapedVectorSpace shapedVectorSpace2, int[] nArray2) {
        super(shape, shapedVectorSpace, nArray, shapedVectorSpace2, nArray2);
        if (this.getType() != 4) {
            throw new IllegalArgumentException("Input and output vector spaces must be for float data type");
        }
    }

    public float[] getWorkArray() {
        if (this.wrk == null) {
            this.wrk = new float[2 * this.getNumberOfFrequencies()];
        }
        return this.wrk;
    }

    @Override
    public void push(ShapedVector shapedVector, boolean bl) {
        if (bl) {
            if (!shapedVector.belongsTo(this.outputSpace)) {
                throw new IncorrectSpaceException("Vector does not belong to output space");
            }
        } else if (!shapedVector.belongsTo(this.inputSpace)) {
            throw new IncorrectSpaceException("Vector does not belong to input space");
        }
        this.push(this.getWorkArray(), ((FloatShapedVector)shapedVector).getData(), bl);
    }

    @Override
    public void pull(ShapedVector shapedVector, boolean bl) {
        if (bl) {
            if (!shapedVector.belongsTo(this.inputSpace)) {
                throw new IncorrectSpaceException("Vector does not belong to input space");
            }
        } else if (!shapedVector.belongsTo(this.outputSpace)) {
            throw new IncorrectSpaceException("Vector does not belong to output space");
        }
        this.pull(((FloatShapedVector)shapedVector).getData(), this.getWorkArray(), bl);
    }

    public abstract void push(float[] var1, float[] var2, boolean var3);

    public abstract void pull(float[] var1, float[] var2, boolean var3);

    public abstract void forwardFFT(float[] var1);

    @Override
    public void forwardFFT() {
        this.forwardFFT(this.getWorkArray());
    }

    public abstract void backwardFFT(float[] var1);

    @Override
    public void backwardFFT() {
        this.forwardFFT(this.getWorkArray());
    }

    @Override
    public void convolve(boolean bl) {
        if (this.mtf == null) {
            throw new IllegalArgumentException("You must set the PSF or the MTF first");
        }
        float[] fArray = this.mtf;
        float[] fArray2 = this.getWorkArray();
        int n = this.getNumberOfFrequencies();
        this.forwardFFT();
        if (bl) {
            for (int i = 0; i < n; ++i) {
                int n2 = i + i;
                int n3 = n2 + 1;
                float f = fArray[n2];
                float f2 = fArray[n3];
                float f3 = fArray2[n2];
                float f4 = fArray2[n3];
                fArray2[n2] = f * f3 + f2 * f4;
                fArray2[n3] = f * f4 - f2 * f3;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                int n4 = i + i;
                int n5 = n4 + 1;
                float f = fArray[n4];
                float f5 = fArray[n5];
                float f6 = fArray2[n4];
                float f7 = fArray2[n5];
                fArray2[n4] = f * f6 - f5 * f7;
                fArray2[n5] = f * f7 + f5 * f6;
            }
        }
        this.backwardFFT(fArray2);
    }

    @Override
    public void setPSF(ShapedVector shapedVector) {
        if (!shapedVector.belongsTo(this.inputSpace)) {
            throw new IncorrectSpaceException("PSF does not belong to the correct space");
        }
        this.computeMTF(((FloatShapedVector)shapedVector).getData());
    }

    @Override
    public void setPSF(ShapedArray shapedArray, int[] nArray, boolean bl) {
        float f;
        boolean bl2 = false;
        if (shapedArray.getType() != 4) {
            shapedArray = shapedArray.toFloat();
            bl2 = true;
        }
        if (bl && (f = (float)ArrayUtils.sum(shapedArray)) != 1.0f) {
            if (!bl2) {
                shapedArray = shapedArray.copy();
            }
            ((FloatArray)shapedArray).scale(1.0f / f);
        }
        shapedArray = this.adjustPSF(shapedArray, nArray);
        this.computeMTF(((FloatArray)shapedArray).flatten());
    }

    private final void computeMTF(float[] fArray) {
        int n = this.getNumberOfFrequencies();
        float f = 1.0f / (float)n;
        if (this.mtf == null) {
            this.mtf = new float[2 * n];
        }
        for (int i = 0; i < n; ++i) {
            int n2 = i + i;
            int n3 = n2 + 1;
            this.mtf[n2] = fArray[i] * f;
            this.mtf[n3] = 0.0f;
        }
        this.forwardFFT(this.mtf);
    }

    @Override
    public FloatShapedVectorSpace getInputSpace() {
        return (FloatShapedVectorSpace)this.inputSpace;
    }

    @Override
    public FloatShapedVectorSpace getOutputSpace() {
        return (FloatShapedVectorSpace)this.outputSpace;
    }
}

