/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Byte1D;
import mitiv.array.ByteArray;
import mitiv.array.DoubleArray;
import mitiv.array.DoubleScalar;
import mitiv.array.FloatArray;
import mitiv.array.FloatScalar;
import mitiv.array.IntArray;
import mitiv.array.IntScalar;
import mitiv.array.LongArray;
import mitiv.array.LongScalar;
import mitiv.array.Scalar;
import mitiv.array.ShapedArray;
import mitiv.array.ShortArray;
import mitiv.array.ShortScalar;
import mitiv.array.impl.FlatByte1D;
import mitiv.array.impl.StriddenByte1D;
import mitiv.base.mapping.ByteFunction;
import mitiv.base.mapping.ByteScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.ByteGenerator;

public class ByteScalar
extends Scalar
implements ByteArray {
    final byte[] data;
    final int offset;
    final boolean flat;

    public ByteScalar() {
        this.data = new byte[1];
        this.offset = 0;
        this.flat = true;
    }

    @Override
    public ByteScalar create() {
        return new ByteScalar();
    }

    public ByteScalar(byte[] byArray, int n) {
        this.data = byArray;
        this.offset = n;
        this.flat = n == 0 && byArray.length == 1;
        this.checkSanity();
    }

    public static ByteScalar wrap(byte[] byArray, int n) {
        return new ByteScalar(byArray, n);
    }

    public ByteScalar(byte by) {
        this.data = new byte[]{by};
        this.offset = 0;
        this.flat = true;
    }

    @Override
    public final void checkSanity() {
        if (this.offset < 0 || this.offset >= this.data.length) {
            throw new IndexOutOfBoundsException("Scalar offset is out of bounds");
        }
    }

    @Override
    public final int getType() {
        return 0;
    }

    @Override
    public final int getOrder() {
        return 1;
    }

    final int index() {
        return this.offset;
    }

    public final byte get() {
        return this.data[this.offset];
    }

    public final void set(byte by) {
        this.data[this.offset] = by;
    }

    @Override
    public final void fill(byte by) {
        this.data[this.offset] = by;
    }

    @Override
    public final void fill(ByteGenerator byteGenerator) {
        this.data[this.offset] = byteGenerator.nextByte();
    }

    @Override
    public final void increment(byte by) {
        int n = this.offset;
        this.data[n] = (byte)(this.data[n] + by);
    }

    @Override
    public final void decrement(byte by) {
        int n = this.offset;
        this.data[n] = (byte)(this.data[n] - by);
    }

    @Override
    public final void scale(byte by) {
        int n = this.offset;
        this.data[n] = (byte)(this.data[n] * by);
    }

    @Override
    public final void map(ByteFunction byteFunction) {
        this.data[this.offset] = byteFunction.apply(this.data[this.offset]);
    }

    @Override
    public final void scan(ByteScanner byteScanner) {
        byteScanner.initialize(this.data[this.offset]);
    }

    @Override
    public final boolean isFlat() {
        return this.flat;
    }

    @Override
    public final byte[] flatten() {
        return this.flatten(false);
    }

    @Override
    public final byte[] flatten(boolean bl) {
        if (!bl && this.flat) {
            return this.data;
        }
        return new byte[]{this.data[this.offset]};
    }

    @Override
    public final byte[] getData() {
        return this.flat ? this.data : null;
    }

    @Override
    public int min() {
        return this.data[this.offset] & 0xFF;
    }

    @Override
    public int max() {
        return this.data[this.offset] & 0xFF;
    }

    @Override
    public int[] getMinAndMax() {
        int[] nArray = new int[2];
        this.getMinAndMax(nArray);
        return nArray;
    }

    @Override
    public void getMinAndMax(int[] nArray) {
        int n;
        nArray[0] = n = this.data[this.offset] & 0xFF;
        nArray[1] = n;
    }

    @Override
    public int sum() {
        return this.data[this.offset] & 0xFF;
    }

    @Override
    public double average() {
        return this.data[this.offset] & 0xFF;
    }

    @Override
    public final ByteArray toByte() {
        return this;
    }

    @Override
    public final ShortArray toShort() {
        return new ShortScalar(this.data[this.offset]);
    }

    @Override
    public final IntArray toInt() {
        return new IntScalar(this.data[this.offset]);
    }

    @Override
    public final LongArray toLong() {
        return new LongScalar(this.data[this.offset]);
    }

    @Override
    public final FloatArray toFloat() {
        return new FloatScalar(this.data[this.offset]);
    }

    @Override
    public final DoubleArray toDouble() {
        return new DoubleScalar(this.data[this.offset]);
    }

    @Override
    public final Byte1D as1D() {
        if (this.offset == 0) {
            return new FlatByte1D(this.data, 1);
        }
        return new StriddenByte1D(this.data, this.offset, 0, 1);
    }

    @Override
    public final void assign(ShapedArray shapedArray) {
        if (!shape.equals(shapedArray.getShape())) {
            throw new NonConformableArrayException();
        }
        switch (shapedArray.getType()) {
            case 0: {
                this.data[this.offset] = ((ByteScalar)shapedArray).get();
                break;
            }
            case 1: {
                this.data[this.offset] = (byte)((ShortScalar)shapedArray).get();
                break;
            }
            case 2: {
                this.data[this.offset] = (byte)((IntScalar)shapedArray).get();
                break;
            }
            case 3: {
                this.data[this.offset] = (byte)((LongScalar)shapedArray).get();
                break;
            }
            case 4: {
                this.data[this.offset] = (byte)((FloatScalar)shapedArray).get();
                break;
            }
            case 5: {
                this.data[this.offset] = (byte)((DoubleScalar)shapedArray).get();
                break;
            }
            default: {
                throw new IllegalTypeException();
            }
        }
    }

    @Override
    public final void assign(ShapedVector shapedVector) {
        if (!shape.equals(shapedVector.getShape())) {
            throw new NonConformableArrayException();
        }
        this.data[this.offset] = (byte)shapedVector.get(0);
    }

    @Override
    public final ByteScalar copy() {
        return new ByteScalar(this.data[this.offset]);
    }
}

