/*
 * Decompiled with CFR 0.152.
 */
package mitiv.base;

import java.nio.ByteOrder;

public class Traits {
    static final char[] suffixes = new char[]{'B', 'S', 'I', 'J', 'F', 'D', 'C', 'Z'};
    static final Class[] classes = new Class[]{Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Character.TYPE, Boolean.TYPE};
    private static final String[] names = new String[]{"byte", "short", "int", "long", "float", "double", "char", "boolean"};
    private static final int[] sizes = new int[]{1, 2, 4, 8, 4, 8, 2, 1};
    public static final int FIRST_NUMERIC = 0;
    public static final int LAST_NUMERIC = 5;
    public static final int VOID = -1;
    public static final int BYTE = 0;
    public static final int SHORT = 1;
    public static final int INT = 2;
    public static final int LONG = 3;
    public static final int FLOAT = 4;
    public static final int DOUBLE = 5;
    public static final int CHAR = 6;
    public static final int BOOLEAN = 7;
    public static final int OBJECT = 8;
    public static final int BIG_ENDIAN = 67305985;
    public static final int LITTLE_ENDIAN = 16909060;
    public static final int UNKNOWN_BYTE_ORDER = -1;
    public static final int NATIVE_BYTE_ORDER = Traits.getNativeByteOrder();
    public static final float FLT_EPSILON = Traits.machineEpsilonFloat();
    public static final double DBL_EPSILON = Traits.machineEpsilonDouble();

    protected Traits() {
        throw new RuntimeException("Non instantiable");
    }

    public static final boolean isNumeric(int n) {
        return 0 <= n && n <= 5;
    }

    public static final String nameOf(int n) {
        if (0 <= n && n <= 7) {
            return names[n];
        }
        if (n == -1) {
            return "void";
        }
        if (n == 8) {
            return "Object";
        }
        return "";
    }

    public static final int sizeOf(int n) {
        if (0 <= n && n <= 7) {
            return sizes[n];
        }
        return 0;
    }

    private static final int getNativeByteOrder() {
        ByteOrder byteOrder = ByteOrder.nativeOrder();
        if (byteOrder == ByteOrder.BIG_ENDIAN) {
            return 67305985;
        }
        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
            return 16909060;
        }
        return -1;
    }

    private static final float machineEpsilonFloat() {
        float f = 1.0f;
        while (1.0f + f / 2.0f != 1.0f) {
            f /= 2.0f;
        }
        if (f <= 0.0f) {
            throw new RuntimeException("Failed to compute FLT_EPSILON");
        }
        return f;
    }

    static final double machineEpsilonDouble() {
        double d = 1.0;
        while (1.0 + d / 2.0 != 1.0) {
            d /= 2.0;
        }
        if (d <= 0.0) {
            throw new RuntimeException("Failed to compute DBL_EPSILON");
        }
        return d;
    }

    public static void main(String[] stringArray) {
        System.out.println("FLT_EPSILON = " + FLT_EPSILON);
        System.out.println("DBL_EPSILON = " + DBL_EPSILON);
        String string = NATIVE_BYTE_ORDER == 67305985 ? "BIG_ENDIAN" : (NATIVE_BYTE_ORDER == 16909060 ? "LITTLE_ENDIAN" : "UNKNOWN_BYTE_ORDER");
        System.out.println("This machine byte order: " + string);
        System.out.flush();
    }
}

