/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array1D;
import mitiv.array.Array6D;
import mitiv.array.ShapedArray;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;

public abstract class Array7D
implements ShapedArray {
    protected final Shape shape;
    protected final int number;
    protected final int dim1;
    protected final int dim2;
    protected final int dim3;
    protected final int dim4;
    protected final int dim5;
    protected final int dim6;
    protected final int dim7;

    protected Array7D(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.shape = new Shape(n, n2, n3, n4, n5, n6, n7);
        if (this.shape.number() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Total number of elements is too large");
        }
        this.number = (int)this.shape.number();
        this.dim1 = n;
        this.dim2 = n2;
        this.dim3 = n3;
        this.dim4 = n4;
        this.dim5 = n5;
        this.dim6 = n6;
        this.dim7 = n7;
    }

    protected Array7D(int[] nArray) {
        this(new Shape(nArray));
    }

    protected Array7D(Shape shape) {
        if (shape.rank() != 7) {
            throw new IllegalArgumentException("Bad number of dimensions for 7-D array");
        }
        if (shape.number() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Total number of elements is too large");
        }
        this.number = (int)shape.number();
        this.shape = shape;
        this.dim1 = shape.dimension(0);
        this.dim2 = shape.dimension(1);
        this.dim3 = shape.dimension(2);
        this.dim4 = shape.dimension(3);
        this.dim5 = shape.dimension(4);
        this.dim6 = shape.dimension(5);
        this.dim7 = shape.dimension(6);
    }

    @Override
    public final int getRank() {
        return 7;
    }

    @Override
    public final Shape getShape() {
        return this.shape;
    }

    @Override
    public final int getNumber() {
        return this.number;
    }

    @Override
    public final int getDimension(int n) {
        return this.shape.dimension(n);
    }

    @Override
    public abstract Array7D copy();

    public abstract Array6D slice(int var1);

    public abstract Array6D slice(int var1, int var2);

    public abstract Array7D view(Range var1, Range var2, Range var3, Range var4, Range var5, Range var6, Range var7);

    public abstract Array7D view(int[] var1, int[] var2, int[] var3, int[] var4, int[] var5, int[] var6, int[] var7);

    @Override
    public abstract Array1D as1D();

    public static int checkViewStrides(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16) {
        int n17;
        int n18;
        int n19 = (n10 - 1) * n3;
        if (n19 >= 0) {
            n18 = n2;
            n17 = n2 + n19;
        } else {
            n18 = n2 + n19;
            n17 = n2;
        }
        n19 = (n11 - 1) * n4;
        if (n19 >= 0) {
            n17 += n19;
        } else {
            n18 += n19;
        }
        n19 = (n12 - 1) * n5;
        if (n19 >= 0) {
            n17 += n19;
        } else {
            n18 += n19;
        }
        n19 = (n13 - 1) * n6;
        if (n19 >= 0) {
            n17 += n19;
        } else {
            n18 += n19;
        }
        n19 = (n14 - 1) * n7;
        if (n19 >= 0) {
            n17 += n19;
        } else {
            n18 += n19;
        }
        n19 = (n15 - 1) * n8;
        if (n19 >= 0) {
            n17 += n19;
        } else {
            n18 += n19;
        }
        n19 = (n16 - 1) * n9;
        if (n19 >= 0) {
            n17 += n19;
        } else {
            n18 += n19;
        }
        if (n18 < 0 || n17 >= n) {
            throw new IndexOutOfBoundsException("7D view is not within available space");
        }
        int n20 = Math.abs(n3);
        int n21 = Math.abs(n4);
        int n22 = Math.abs(n5);
        int n23 = Math.abs(n6);
        int n24 = Math.abs(n7);
        int n25 = Math.abs(n8);
        int n26 = Math.abs(n9);
        if (n20 <= n21 && n21 <= n22 && n22 <= n23 && n23 <= n24 && n24 <= n25 && n25 <= n26) {
            return 1;
        }
        if (n20 >= n21 && n21 >= n22 && n22 >= n23 && n23 >= n24 && n24 >= n25 && n25 >= n26) {
            return 2;
        }
        return 0;
    }
}

