/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tlong.impl;

import cern.colt.matrix.tlong.LongMatrix1D;
import cern.colt.matrix.tlong.LongMatrix2D;
import cern.colt.matrix.tlong.LongMatrix3D;

public class WrapperLongMatrix1D
extends LongMatrix1D {
    private static final long serialVersionUID = 1L;
    protected LongMatrix1D content;

    public WrapperLongMatrix1D(LongMatrix1D newContent) {
        if (newContent != null) {
            this.setUp((int)newContent.size());
        }
        this.content = newContent;
    }

    @Override
    protected LongMatrix1D getContent() {
        return this.content;
    }

    @Override
    public synchronized long getQuick(int index) {
        return this.content.getQuick(index);
    }

    @Override
    public Object elements() {
        return this.content.elements();
    }

    @Override
    public LongMatrix1D like(int size) {
        return this.content.like(size);
    }

    @Override
    public LongMatrix2D like2D(int rows, int columns) {
        return this.content.like2D(rows, columns);
    }

    @Override
    public LongMatrix2D reshape(int rows, int columns) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    @Override
    public LongMatrix3D reshape(int slices, int rows, int columns) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    @Override
    public synchronized void setQuick(int index, long value) {
        this.content.setQuick(index, value);
    }

    @Override
    public LongMatrix1D viewFlip() {
        WrapperLongMatrix1D view = new WrapperLongMatrix1D(this){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized long getQuick(int index) {
                return this.content.getQuick(this.size - 1 - index);
            }

            @Override
            public synchronized void setQuick(int index, long value) {
                this.content.setQuick(this.size - 1 - index, value);
            }

            @Override
            public synchronized long get(int index) {
                return this.content.get(this.size - 1 - index);
            }

            @Override
            public synchronized void set(int index, long value) {
                this.content.set(this.size - 1 - index, value);
            }
        };
        return view;
    }

    @Override
    public LongMatrix1D viewPart(final int index, int width) {
        this.checkRange(index, width);
        WrapperLongMatrix1D view = new WrapperLongMatrix1D(this){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized long getQuick(int i) {
                return this.content.getQuick(index + i);
            }

            @Override
            public synchronized void setQuick(int i, long value) {
                this.content.setQuick(index + i, value);
            }

            @Override
            public synchronized long get(int i) {
                return this.content.get(index + i);
            }

            @Override
            public synchronized void set(int i, long value) {
                this.content.set(index + i, value);
            }
        };
        view.setSize(width);
        return view;
    }

    @Override
    public LongMatrix1D viewSelection(int[] indexes) {
        if (indexes == null) {
            indexes = new int[this.size];
            int i = this.size;
            while (--i >= 0) {
                indexes[i] = i;
            }
        }
        this.checkIndexes(indexes);
        final int[] idx = indexes;
        WrapperLongMatrix1D view = new WrapperLongMatrix1D(this){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized long getQuick(int i) {
                return this.content.getQuick(idx[i]);
            }

            @Override
            public synchronized void setQuick(int i, long value) {
                this.content.setQuick(idx[i], value);
            }

            @Override
            public synchronized long get(int i) {
                return this.content.get(idx[i]);
            }

            @Override
            public synchronized void set(int i, long value) {
                this.content.set(idx[i], value);
            }
        };
        view.setSize(indexes.length);
        return view;
    }

    @Override
    protected LongMatrix1D viewSelectionLike(int[] offsets) {
        throw new InternalError();
    }

    @Override
    public LongMatrix1D viewStrides(final int _stride) {
        if (this.stride <= 0) {
            throw new IndexOutOfBoundsException("illegal stride: " + this.stride);
        }
        WrapperLongMatrix1D view = new WrapperLongMatrix1D(this){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized long getQuick(int index) {
                return this.content.getQuick(index * _stride);
            }

            @Override
            public synchronized void setQuick(int index, long value) {
                this.content.setQuick(index * _stride, value);
            }

            @Override
            public synchronized long get(int index) {
                return this.content.get(index * _stride);
            }

            @Override
            public synchronized void set(int index, long value) {
                this.content.set(index * _stride, value);
            }
        };
        view.setSize(this.size);
        if (this.size != 0) {
            view.setSize((this.size - 1) / _stride + 1);
        }
        return view;
    }
}

