/*
 * Decompiled with CFR 0.152.
 */
package mitiv.optim;

import mitiv.linalg.Vector;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVectorSpace;
import mitiv.optim.BoundProjector;

public class SimpleBounds
extends BoundProjector {
    private final double lowerBound;
    private final double upperBound;
    private final boolean single;

    public SimpleBounds(ShapedVectorSpace shapedVectorSpace, double d, double d2) {
        super(shapedVectorSpace);
        if (shapedVectorSpace.getType() == 5) {
            this.single = false;
        } else if (shapedVectorSpace.getType() == 4) {
            this.single = true;
        } else {
            throw new IllegalArgumentException("Only double/double type supported");
        }
        this.checkBounds(d, d2, this.single);
        this.lowerBound = d;
        this.upperBound = d2;
    }

    public double getUpperBound() {
        return this.upperBound;
    }

    public double getLowerBound() {
        return this.lowerBound;
    }

    @Override
    protected void _projectVariables(Vector vector, Vector vector2) {
        int n = vector2.getNumber();
        if (this.single) {
            float f = this.convertToFloat(this.getLowerBound());
            float f2 = this.convertToFloat(this.getUpperBound());
            float[] fArray = ((FloatShapedVector)vector2).getData();
            float[] fArray2 = ((FloatShapedVector)vector).getData();
            for (int i = 0; i < n; ++i) {
                fArray2[i] = SimpleBounds.clamp(fArray[i], f, f2);
            }
        } else {
            double d = this.getLowerBound();
            double d2 = this.getUpperBound();
            double[] dArray = ((DoubleShapedVector)vector2).getData();
            double[] dArray2 = ((DoubleShapedVector)vector).getData();
            for (int i = 0; i < n; ++i) {
                dArray2[i] = SimpleBounds.clamp(dArray[i], d, d2);
            }
        }
    }

    @Override
    protected void _projectDirection(Vector vector, Vector vector2, boolean bl, Vector vector3, double[] dArray) {
        int n = vector.getNumber();
        if (this.single) {
            float f = this.convertToFloat(this.getLowerBound());
            float f2 = this.convertToFloat(this.getUpperBound());
            float[] fArray = ((FloatShapedVector)vector).getData();
            float[] fArray2 = ((FloatShapedVector)vector2).getData();
            float[] fArray3 = ((FloatShapedVector)vector3).getData();
            if (dArray == null) {
                if (bl) {
                    for (int i = 0; i < n; ++i) {
                        fArray3[i] = fArray2[i] < 0.0f ? (fArray[i] < f2 ? fArray2[i] : 0.0f) : (fArray2[i] > 0.0f ? (fArray[i] > f ? fArray2[i] : 0.0f) : 0.0f);
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        fArray3[i] = fArray2[i] > 0.0f ? (fArray[i] < f2 ? fArray2[i] : 0.0f) : (fArray2[i] < 0.0f ? (fArray[i] > f ? fArray2[i] : 0.0f) : 0.0f);
                    }
                }
            } else {
                float f3 = Float.POSITIVE_INFINITY;
                float f4 = 0.0f;
                if (bl) {
                    for (int i = 0; i < n; ++i) {
                        float f5;
                        if (fArray2[i] < 0.0f) {
                            if (fArray[i] < f2) {
                                fArray3[i] = fArray2[i];
                                if (f2 == Float.POSITIVE_INFINITY) {
                                    f4 = Float.POSITIVE_INFINITY;
                                    continue;
                                }
                                f5 = (fArray[i] - f2) / fArray2[i];
                                if (f5 < f3) {
                                    f3 = f5;
                                }
                                if (!(f5 > f4)) continue;
                                f4 = f5;
                                continue;
                            }
                            fArray3[i] = 0.0f;
                            continue;
                        }
                        if (fArray2[i] > 0.0f) {
                            if (fArray[i] > f) {
                                fArray3[i] = fArray2[i];
                                if (f == Float.NEGATIVE_INFINITY) {
                                    f4 = Float.POSITIVE_INFINITY;
                                    continue;
                                }
                                f5 = (fArray[i] - f) / fArray2[i];
                                if (f5 < f3) {
                                    f3 = f5;
                                }
                                if (!(f5 > f4)) continue;
                                f4 = f5;
                                continue;
                            }
                            fArray3[i] = 0.0f;
                            continue;
                        }
                        fArray3[i] = 0.0f;
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        float f6;
                        if (fArray2[i] > 0.0f) {
                            if (fArray[i] < f2) {
                                fArray3[i] = fArray2[i];
                                if (f2 == Float.POSITIVE_INFINITY) {
                                    f4 = Float.POSITIVE_INFINITY;
                                    continue;
                                }
                                f6 = (f2 - fArray[i]) / fArray2[i];
                                if (f6 < f3) {
                                    f3 = f6;
                                }
                                if (!(f6 > f4)) continue;
                                f4 = f6;
                                continue;
                            }
                            fArray3[i] = 0.0f;
                            continue;
                        }
                        if (fArray2[i] < 0.0f) {
                            if (fArray[i] > f) {
                                fArray3[i] = fArray2[i];
                                if (f == Float.NEGATIVE_INFINITY) {
                                    f4 = Float.POSITIVE_INFINITY;
                                    continue;
                                }
                                f6 = (f - fArray[i]) / fArray2[i];
                                if (f6 < f3) {
                                    f3 = f6;
                                }
                                if (!(f6 > f4)) continue;
                                f4 = f6;
                                continue;
                            }
                            fArray3[i] = 0.0f;
                            continue;
                        }
                        fArray3[i] = 0.0f;
                    }
                }
                dArray[0] = f3;
                dArray[1] = f4;
            }
        } else {
            double d = this.getLowerBound();
            double d2 = this.getUpperBound();
            double[] dArray2 = ((DoubleShapedVector)vector).getData();
            double[] dArray3 = ((DoubleShapedVector)vector2).getData();
            double[] dArray4 = ((DoubleShapedVector)vector3).getData();
            if (dArray == null) {
                if (bl) {
                    for (int i = 0; i < n; ++i) {
                        dArray4[i] = dArray3[i] < 0.0 ? (dArray2[i] < d2 ? dArray3[i] : 0.0) : (dArray3[i] > 0.0 ? (dArray2[i] > d ? dArray3[i] : 0.0) : 0.0);
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        dArray4[i] = dArray3[i] > 0.0 ? (dArray2[i] < d2 ? dArray3[i] : 0.0) : (dArray3[i] < 0.0 ? (dArray2[i] > d ? dArray3[i] : 0.0) : 0.0);
                    }
                }
            } else {
                double d3 = Double.POSITIVE_INFINITY;
                double d4 = 0.0;
                if (bl) {
                    for (int i = 0; i < n; ++i) {
                        double d5;
                        if (dArray3[i] < 0.0) {
                            if (dArray2[i] < d2) {
                                dArray4[i] = dArray3[i];
                                if (d2 == Double.POSITIVE_INFINITY) {
                                    d4 = Double.POSITIVE_INFINITY;
                                    continue;
                                }
                                d5 = (dArray2[i] - d2) / dArray3[i];
                                if (d5 < d3) {
                                    d3 = d5;
                                }
                                if (!(d5 > d4)) continue;
                                d4 = d5;
                                continue;
                            }
                            dArray4[i] = 0.0;
                            continue;
                        }
                        if (dArray3[i] > 0.0) {
                            if (dArray2[i] > d) {
                                dArray4[i] = dArray3[i];
                                if (d == Double.NEGATIVE_INFINITY) {
                                    d4 = Double.POSITIVE_INFINITY;
                                    continue;
                                }
                                d5 = (dArray2[i] - d) / dArray3[i];
                                if (d5 < d3) {
                                    d3 = d5;
                                }
                                if (!(d5 > d4)) continue;
                                d4 = d5;
                                continue;
                            }
                            dArray4[i] = 0.0;
                            continue;
                        }
                        dArray4[i] = 0.0;
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        double d6;
                        if (dArray3[i] > 0.0) {
                            if (dArray2[i] < d2) {
                                dArray4[i] = dArray3[i];
                                if (d2 == Double.POSITIVE_INFINITY) {
                                    d4 = Double.POSITIVE_INFINITY;
                                    continue;
                                }
                                d6 = (d2 - dArray2[i]) / dArray3[i];
                                if (d6 < d3) {
                                    d3 = d6;
                                }
                                if (!(d6 > d4)) continue;
                                d4 = d6;
                                continue;
                            }
                            dArray4[i] = 0.0;
                            continue;
                        }
                        if (dArray3[i] < 0.0) {
                            if (dArray2[i] > d) {
                                dArray4[i] = dArray3[i];
                                if (d == Double.NEGATIVE_INFINITY) {
                                    d4 = Double.POSITIVE_INFINITY;
                                    continue;
                                }
                                d6 = (d - dArray2[i]) / dArray3[i];
                                if (d6 < d3) {
                                    d3 = d6;
                                }
                                if (!(d6 > d4)) continue;
                                d4 = d6;
                                continue;
                            }
                            dArray4[i] = 0.0;
                            continue;
                        }
                        dArray4[i] = 0.0;
                    }
                }
                dArray[0] = d3;
                dArray[1] = d4;
            }
        }
    }
}

