/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array2D;
import mitiv.array.Byte2D;
import mitiv.array.Double1D;
import mitiv.array.DoubleArray;
import mitiv.array.Float2D;
import mitiv.array.Int2D;
import mitiv.array.Long2D;
import mitiv.array.ShapedArray;
import mitiv.array.Short2D;
import mitiv.array.impl.FlatDouble2D;
import mitiv.array.impl.StriddenDouble2D;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.DoubleFunction;
import mitiv.base.mapping.DoubleScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.DoubleGenerator;

public abstract class Double2D
extends Array2D
implements DoubleArray {
    protected Double2D(int n, int n2) {
        super(n, n2);
    }

    protected Double2D(int[] nArray) {
        super(nArray);
    }

    protected Double2D(Shape shape) {
        super(shape);
    }

    @Override
    public final int getType() {
        return 5;
    }

    public abstract double get(int var1, int var2);

    public abstract void set(int var1, int var2, double var3);

    @Override
    public void fill(double d) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    this.set(i, j, d);
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    this.set(j, i, d);
                }
            }
        }
    }

    @Override
    public void increment(double d) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    this.set(i, j, this.get(i, j) + d);
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    this.set(j, i, this.get(j, i) + d);
                }
            }
        }
    }

    @Override
    public void decrement(double d) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    this.set(i, j, this.get(i, j) - d);
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    this.set(j, i, this.get(j, i) - d);
                }
            }
        }
    }

    @Override
    public void scale(double d) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    this.set(i, j, this.get(i, j) * d);
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    this.set(j, i, this.get(j, i) * d);
                }
            }
        }
    }

    @Override
    public void map(DoubleFunction doubleFunction) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    this.set(i, j, doubleFunction.apply(this.get(i, j)));
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    this.set(j, i, doubleFunction.apply(this.get(j, i)));
                }
            }
        }
    }

    @Override
    public void fill(DoubleGenerator doubleGenerator) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    this.set(i, j, doubleGenerator.nextDouble());
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    this.set(j, i, doubleGenerator.nextDouble());
                }
            }
        }
    }

    @Override
    public void scan(DoubleScanner doubleScanner) {
        boolean bl = false;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    if (bl) {
                        doubleScanner.update(this.get(i, j));
                        continue;
                    }
                    doubleScanner.initialize(this.get(i, j));
                    bl = true;
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    if (bl) {
                        doubleScanner.update(this.get(j, i));
                        continue;
                    }
                    doubleScanner.initialize(this.get(j, i));
                    bl = true;
                }
            }
        }
    }

    @Override
    public final double[] flatten() {
        return this.flatten(false);
    }

    @Override
    public double min() {
        double d = this.get(0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    if (bl) {
                        bl = false;
                        continue;
                    }
                    double d2 = this.get(i, j);
                    if (!(d2 < d)) continue;
                    d = d2;
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    if (bl) {
                        bl = false;
                        continue;
                    }
                    double d3 = this.get(j, i);
                    if (!(d3 < d)) continue;
                    d = d3;
                }
            }
        }
        return d;
    }

    @Override
    public double max() {
        double d = this.get(0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    if (bl) {
                        bl = false;
                        continue;
                    }
                    double d2 = this.get(i, j);
                    if (!(d2 > d)) continue;
                    d = d2;
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    if (bl) {
                        bl = false;
                        continue;
                    }
                    double d3 = this.get(j, i);
                    if (!(d3 > d)) continue;
                    d = d3;
                }
            }
        }
        return d;
    }

    @Override
    public double[] getMinAndMax() {
        double[] dArray = new double[2];
        this.getMinAndMax(dArray);
        return dArray;
    }

    @Override
    public void getMinAndMax(double[] dArray) {
        double d;
        double d2 = d = this.get(0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    if (bl) {
                        bl = false;
                        continue;
                    }
                    double d3 = this.get(i, j);
                    if (d3 < d) {
                        d = d3;
                    }
                    if (!(d3 > d2)) continue;
                    d2 = d3;
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    if (bl) {
                        bl = false;
                        continue;
                    }
                    double d4 = this.get(j, i);
                    if (d4 < d) {
                        d = d4;
                    }
                    if (!(d4 > d2)) continue;
                    d2 = d4;
                }
            }
        }
        dArray[0] = d;
        dArray[1] = d2;
    }

    @Override
    public double sum() {
        double d = 0.0;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    d += this.get(i, j);
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    d += this.get(j, i);
                }
            }
        }
        return d;
    }

    @Override
    public double average() {
        return this.sum() / (double)this.number;
    }

    @Override
    public Byte2D toByte() {
        byte[] byArray = new byte[this.number];
        if (this.isFlat()) {
            double[] dArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                byArray[i] = (byte)dArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    byArray[++n] = (byte)this.get(j, i);
                }
            }
        }
        return Byte2D.wrap(byArray, this.getShape());
    }

    @Override
    public Short2D toShort() {
        short[] sArray = new short[this.number];
        if (this.isFlat()) {
            double[] dArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                sArray[i] = (short)dArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    sArray[++n] = (short)this.get(j, i);
                }
            }
        }
        return Short2D.wrap(sArray, this.getShape());
    }

    @Override
    public Int2D toInt() {
        int[] nArray = new int[this.number];
        if (this.isFlat()) {
            double[] dArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                nArray[i] = (int)dArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    nArray[++n] = (int)this.get(j, i);
                }
            }
        }
        return Int2D.wrap(nArray, this.getShape());
    }

    @Override
    public Long2D toLong() {
        long[] lArray = new long[this.number];
        if (this.isFlat()) {
            double[] dArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                lArray[i] = (long)dArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    lArray[++n] = (long)this.get(j, i);
                }
            }
        }
        return Long2D.wrap(lArray, this.getShape());
    }

    @Override
    public Float2D toFloat() {
        float[] fArray = new float[this.number];
        if (this.isFlat()) {
            double[] dArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                fArray[i] = (float)dArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    fArray[++n] = (float)this.get(j, i);
                }
            }
        }
        return Float2D.wrap(fArray, this.getShape());
    }

    @Override
    public Double2D toDouble() {
        return this;
    }

    @Override
    public Double2D copy() {
        return new FlatDouble2D(this.flatten(true), this.shape);
    }

    @Override
    public void assign(ShapedArray shapedArray) {
        if (!this.getShape().equals(shapedArray.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        Double2D double2D = shapedArray.getType() == 5 ? (Double2D)shapedArray : (Double2D)shapedArray.toDouble();
        if (this.getOrder() == 2 && double2D.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    this.set(i, j, double2D.get(i, j));
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    this.set(j, i, double2D.get(j, i));
                }
            }
        }
    }

    @Override
    public void assign(ShapedVector shapedVector) {
        if (!this.getShape().equals(shapedVector.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        int n = -1;
        if (shapedVector.getType() == 5) {
            DoubleShapedVector doubleShapedVector = (DoubleShapedVector)shapedVector;
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    this.set(j, i, doubleShapedVector.get(++n));
                }
            }
        } else if (shapedVector.getType() == 4) {
            FloatShapedVector floatShapedVector = (FloatShapedVector)shapedVector;
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    this.set(j, i, floatShapedVector.get(++n));
                }
            }
        } else {
            throw new IllegalTypeException();
        }
    }

    @Override
    public Double2D create() {
        return new FlatDouble2D(this.getShape());
    }

    public static Double2D create(int n, int n2) {
        return new FlatDouble2D(n, n2);
    }

    public static Double2D create(int[] nArray) {
        return new FlatDouble2D(nArray);
    }

    public static Double2D create(Shape shape) {
        return new FlatDouble2D(shape);
    }

    public static Double2D wrap(double[] dArray, int n, int n2) {
        return new FlatDouble2D(dArray, n, n2);
    }

    public static Double2D wrap(double[] dArray, int[] nArray) {
        return new FlatDouble2D(dArray, nArray);
    }

    public static Double2D wrap(double[] dArray, Shape shape) {
        return new FlatDouble2D(dArray, shape);
    }

    public static Double2D wrap(double[] dArray, int n, int n2, int n3, int n4, int n5) {
        return new StriddenDouble2D(dArray, n, n2, n3, n4, n5);
    }

    @Override
    public abstract Double1D slice(int var1);

    @Override
    public abstract Double1D slice(int var1, int var2);

    @Override
    public abstract Double2D view(Range var1, Range var2);

    @Override
    public abstract Double2D view(int[] var1, int[] var2);

    @Override
    public abstract Double1D as1D();
}

