package plugins.ylemontag.ssim;

/**
 * 
 * @author Yoann Le Montagner
 *
 * Object used to control and interrupt SSIM computation
 */
public class Controller
{	
	/**
	 * Exception thrown when a SSIM computation have been interrupted
	 */
	public static class CanceledByUser extends Exception
	{
		private static final long serialVersionUID = 1L;
	}
	
	private boolean _cancelFlag;
	
	/**
	 * Constructor
	 */
	public Controller()
	{
		_cancelFlag = false;
	}
	
	/**
	 * Method to call to ask the SSIM calculator to stop the computation it finishes
	 * @warning Calling this method does not mean the computation will actually
	 *          be interrupted. The SSIM computation is interrupted if a
	 *          CanceledByUser exception is thrown.
	 */
	public void cancelComputation()
	{
		_cancelFlag = true;
	}
	
	/**
	 * Check-point function called by the thread
	 */
	void checkPoint() throws CanceledByUser
	{
		if(_cancelFlag) {
			throw new CanceledByUser();
		}
	}
}
